/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.AbstractMapperEventHandler;
import org.netbeans.modules.soa.mappercore.LeftTree;
import org.netbeans.modules.soa.mappercore.LinkTool;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;

public class LeftTreeEventHandler
extends AbstractMapperEventHandler {
    private MouseEvent initialEvent = null;
    private TreePath initialPath = null;
    private TreeSourcePin initialSourcePin = null;

    public LeftTreeEventHandler(LeftTree leftTree) {
        super(leftTree.getMapper(), leftTree);
    }

    private void reset() {
        this.initialEvent = null;
        this.initialPath = null;
        this.initialSourcePin = null;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.reset();
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.initialPath = this.getLeftTree().getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (this.initialPath != null) {
            this.initialSourcePin = this.getMapperModel().getTreeSourcePin(this.initialPath);
            if (this.initialSourcePin != null) {
                this.initialEvent = mouseEvent;
            }
        }
        if (this.initialEvent == null) {
            this.reset();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.reset();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.initialEvent != null && this.initialEvent.getPoint().distance(mouseEvent.getPoint()) >= 5.0) {
            LeftTree leftTree = this.getLeftTree();
            LinkTool linkTool = this.getMapper().getLinkTool();
            Transferable transferable = linkTool.activateOutgoing(this.initialSourcePin, null, null);
            this.startDrag(this.initialEvent, transferable, 2);
            this.reset();
        }
    }
}

