/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.LeftTree;
import org.netbeans.modules.soa.mappercore.LinkTool;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.MapperNode;
import org.netbeans.modules.soa.mappercore.RightTree;
import org.netbeans.modules.soa.mappercore.SelectionModel;
import org.netbeans.modules.soa.mappercore.model.MapperModel;

public class MapperPanel
extends JPanel {
    private Mapper mapper;

    public MapperPanel(Mapper mapper) {
        this.mapper = mapper;
        this.setFocusable(true);
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    LinkTool getLinkTool() {
        return this.mapper.getLinkTool();
    }

    public LeftTree getLeftTree() {
        return this.mapper.getLeftTree();
    }

    public Canvas getCanvas() {
        return this.mapper.getCanvas();
    }

    public RightTree getRightTree() {
        return this.mapper.getRightTree();
    }

    public MapperModel getMapperModel() {
        return this.mapper.getFilteredModel();
    }

    public MapperNode getRoot() {
        return this.mapper.getRoot();
    }

    public MapperNode getNodeAt(int n) {
        return this.mapper.getNodeAt(n);
    }

    public SelectionModel getSelectionModel() {
        return this.mapper.getSelectionModel();
    }

    public int yToMapper(int n) {
        for (Container container = this; container != this.mapper; container = container.getParent()) {
            n += ((Component)container).getY();
        }
        return n;
    }

    public int yFromMapper(int n) {
        for (Container container = this; container != this.mapper; container = container.getParent()) {
            n -= ((Component)container).getY();
        }
        return n;
    }

    public int getStep() {
        return this.mapper.getStepSize();
    }

    public TreePath getTreePath(int n) {
        MapperNode mapperNode = this.getNodeAt(n);
        return mapperNode != null ? mapperNode.getTreePath() : null;
    }
}

