/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.MapperKeyboardAction;
import org.netbeans.modules.soa.mappercore.SelectionModel;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.GraphSubset;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.openide.actions.PasteAction;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public class PasteMapperAction
extends MapperKeyboardAction {
    PasteMapperAction(Canvas canvas) {
        super(canvas);
        this.putValue("Name", "Paste");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 128));
    }

    public String getActionKey() {
        return ((CallbackSystemAction)SystemAction.get(PasteAction.class)).getActionMapKey().toString();
    }

    public KeyStroke[] getShortcuts() {
        return new KeyStroke[]{KeyStroke.getKeyStroke(86, 128), KeyStroke.getKeyStroke(155, 64), KeyStroke.getKeyStroke(65487, 0)};
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2;
        GraphSubset graphSubset = this.canvas.getBufferCopyPaste();
        if (graphSubset == null) {
            return;
        }
        if (graphSubset.getVertexCount() < 1) {
            return;
        }
        SelectionModel selectionModel = this.canvas.getSelectionModel();
        TreePath treePath = selectionModel.getSelectedPath();
        if (treePath == null) {
            return;
        }
        MapperModel mapperModel = this.canvas.getMapperModel();
        Graph graph = selectionModel.getSelectedGraph();
        Vertex vertex = graph.getPrevVertex(null);
        int n3 = this.canvas.getStep();
        if (vertex == null) {
            n2 = this.canvas.toGraph(this.canvas.getRendererContext().getCanvasVisibleMinX());
            n2 = (int)Math.round((double)n2 / (double)n3) + 2;
            n = 0;
        } else {
            n2 = vertex.getX() + vertex.getWidth() + 3;
            n = 0;
        }
        n2 = n2 + graphSubset.getMinYVertex().getX() - graphSubset.getMinXVertex().getX();
        graphSubset = mapperModel.copy(treePath, graphSubset, n2, n);
        if (graphSubset != null && !graphSubset.isEmpty()) {
            selectionModel.setSelected(treePath, graphSubset);
        }
    }
}

