/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.MapperPropertyAccess;
import org.netbeans.modules.soa.mappercore.event.MapperSelectionEvent;
import org.netbeans.modules.soa.mappercore.event.MapperSelectionListener;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.GraphItem;
import org.netbeans.modules.soa.mappercore.model.GraphListener;
import org.netbeans.modules.soa.mappercore.model.GraphSubset;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.soa.mappercore.utils.MapperTreePath;
import org.netbeans.modules.soa.mappercore.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionModel
extends MapperPropertyAccess {
    private MapperModel model = null;
    private TreePath selectedPath = null;
    private Graph selectedGraph = null;
    private List<GraphItem> selected = new ArrayList<GraphItem>();
    private ListenersImpl listenersImpl;
    private List<MapperSelectionListener> listeners = new ArrayList<MapperSelectionListener>();

    public SelectionModel(Mapper mapper) {
        super(mapper);
        this.listenersImpl = new ListenersImpl();
        this.updateMapperModel();
        mapper.addPropertyChangeListener(this.listenersImpl);
        mapper.addRightTreeExpansionListener(this.listenersImpl);
    }

    public void addSelectionListener(MapperSelectionListener mapperSelectionListener) {
        this.listeners.add(mapperSelectionListener);
    }

    public void removeSelectionListener(MapperSelectionListener mapperSelectionListener) {
        int n = this.listeners.lastIndexOf(mapperSelectionListener);
        if (n >= 0) {
            this.listeners.remove(n);
        }
    }

    private void fireSelectionChanged() {
        int n = this.listeners.size();
        if (n > 0) {
            MapperSelectionEvent mapperSelectionEvent = new MapperSelectionEvent(this);
            for (MapperSelectionListener mapperSelectionListener : this.listeners.toArray(new MapperSelectionListener[n])) {
                mapperSelectionListener.mapperSelectionChanged(mapperSelectionEvent);
            }
        }
    }

    public GraphSubset getSelectedSubset() {
        if (this.selectedPath != null && this.selectedGraph != null) {
            return new GraphSubset(this.selectedPath, this.selectedGraph, this.getSelectedVerteces(), this.getSelectedLinks());
        }
        return null;
    }

    public List<Vertex> getSelectedVerteces() {
        return this.getSelectedImpl(Vertex.class);
    }

    public List<Link> getSelectedLinks() {
        return this.getSelectedImpl(Link.class);
    }

    public TreePath getSelectedPath() {
        return this.selectedPath;
    }

    public Graph getSelectedGraph() {
        return this.selectedGraph;
    }

    public VertexItem getSelectedVertexItem() {
        GraphItem graphItem;
        if (this.selected.size() == 1 && (graphItem = this.selected.get(0)) instanceof VertexItem) {
            return (VertexItem)graphItem;
        }
        return null;
    }

    public void setSelected(TreePath treePath) {
        if (this.setSelectedPathImpl(treePath)) {
            this.fireSelectionChanged();
        }
    }

    public void setSelected(TreePath treePath, GraphItem graphItem) {
        boolean bl = this.setSelectedPathImpl(treePath);
        if (this.selected.size() != 1 || this.selected.get(0) != graphItem) {
            this.selected.clear();
            this.selected.add(graphItem);
            bl = true;
        }
        if (bl) {
            this.fireSelectionChanged();
        }
    }

    public void switchSelected(TreePath treePath, GraphItem graphItem) {
        boolean bl = this.setSelectedPathImpl(treePath);
        if (graphItem instanceof VertexItem) {
            graphItem = ((VertexItem)graphItem).getVertex();
        }
        if (this.selected.contains(graphItem)) {
            this.selected.remove(graphItem);
            bl = true;
        } else {
            this.selected.add(graphItem);
            bl = true;
        }
        if (bl |= this.removeVertexItemsImpl()) {
            this.fireSelectionChanged();
        }
    }

    public void setSelected(TreePath treePath, GraphSubset graphSubset) {
        GraphItem graphItem;
        int n;
        boolean bl = this.setSelectedPathImpl(treePath);
        this.selected.clear();
        for (n = 0; n < graphSubset.getVertexCount(); ++n) {
            graphItem = graphSubset.getVertex(n);
            this.selected.add(graphItem);
            bl = true;
        }
        for (n = 0; n < graphSubset.getLinkCount(); ++n) {
            graphItem = graphSubset.getLink(n);
            this.selected.add(graphItem);
            bl = true;
        }
        if (bl) {
            this.fireSelectionChanged();
        }
    }

    public void clearSelection(TreePath treePath) {
        boolean bl = this.setSelectedPathImpl(treePath);
        if (!this.selected.isEmpty()) {
            this.selected.clear();
            bl = true;
        }
        if (bl) {
            this.fireSelectionChanged();
        }
    }

    public void selectAll(TreePath treePath) {
        boolean bl = this.setSelectedPathImpl(treePath);
        if (this.selectedGraph != null) {
            int n;
            HashSet<GraphItem> hashSet = new HashSet<GraphItem>();
            for (n = this.selectedGraph.getLinkCount() - 1; n >= 0; --n) {
                hashSet.add(this.selectedGraph.getLink(n));
            }
            for (n = this.selectedGraph.getVertexCount() - 1; n >= 0; --n) {
                hashSet.add(this.selectedGraph.getVertex(n));
            }
            hashSet.removeAll(this.selected);
            if (!hashSet.isEmpty()) {
                this.selected.addAll(0, hashSet);
                bl = true;
            }
            bl |= this.removeVertexItemsImpl();
        }
        if (bl) {
            this.fireSelectionChanged();
        }
    }

    private boolean removeVertexItemsImpl() {
        boolean bl = false;
        for (int i = this.selected.size() - 1; i >= 0; --i) {
            if (!(this.selected.get(i) instanceof VertexItem)) continue;
            this.selected.remove(i);
            bl = true;
        }
        return bl;
    }

    private <T extends GraphItem> List<T> getSelectedImpl(Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>(this.selected.size());
        for (GraphItem graphItem : this.selected) {
            if (!clazz.isInstance(graphItem)) continue;
            arrayList.add(clazz.cast(graphItem));
        }
        return arrayList;
    }

    private boolean setSelectedPathImpl(TreePath treePath) {
        if (!Utils.equal(this.selectedPath, treePath)) {
            this.selected.clear();
            this.selectedPath = treePath;
            this.updateGraph(false);
            return true;
        }
        return false;
    }

    public boolean isSelected(TreePath treePath) {
        return Utils.equal(this.selectedPath, treePath);
    }

    public boolean isSelected(TreePath treePath, GraphItem graphItem) {
        return this.isSelected(treePath) && this.selected.contains(graphItem);
    }

    private void updateMapperModel() {
        MapperModel mapperModel = this.model;
        MapperModel mapperModel2 = this.getMapperModel();
        if (mapperModel != mapperModel2) {
            if (mapperModel != null) {
                mapperModel.removeTreeModelListener(this.listenersImpl);
            }
            if (mapperModel2 != null) {
                mapperModel2.addTreeModelListener(this.listenersImpl);
            }
            this.model = mapperModel2;
            this.setSelectedPathImpl(null);
        }
    }

    private void updateGraph(boolean bl) {
        Graph graph;
        Graph graph2 = this.selectedGraph;
        Graph graph3 = graph = this.model != null && this.selectedPath != null ? this.model.getGraph(this.selectedPath) : null;
        if (graph2 != graph) {
            if (graph2 != null) {
                graph2.removeGraphListener(this.listenersImpl);
            }
            if (graph != null) {
                graph.addGraphListener(this.listenersImpl);
            }
            this.selectedGraph = graph;
            this.selected.clear();
            if (bl) {
                this.fireSelectionChanged();
            }
        }
    }

    private void updateSelectedItems() {
        boolean bl = false;
        if (this.selectedGraph != null && !this.selected.isEmpty()) {
            int n;
            HashSet<GraphItem> hashSet = new HashSet<GraphItem>(this.selected);
            for (n = this.selectedGraph.getVertexCount() - 1; n >= 0; --n) {
                hashSet.remove(this.selectedGraph.getVertex(n));
            }
            for (n = this.selectedGraph.getLinkCount() - 1; n >= 0; --n) {
                hashSet.remove(this.selectedGraph.getLink(n));
            }
            for (GraphItem graphItem : hashSet) {
                if (graphItem instanceof VertexItem) {
                    VertexItem vertexItem = (VertexItem)graphItem;
                    Vertex vertex = vertexItem.getVertex();
                    if (vertex.getItemIndex(vertexItem) < 0) {
                        this.selected.remove(graphItem);
                        bl = true;
                        continue;
                    }
                    if (vertex.getGraph() == this.selectedGraph) continue;
                    this.selected.remove(graphItem);
                    bl = true;
                    continue;
                }
                this.selected.remove(graphItem);
                bl = true;
            }
        }
        if (bl) {
            this.fireSelectionChanged();
        }
    }

    private class ListenersImpl
    implements GraphListener,
    TreeModelListener,
    PropertyChangeListener,
    TreeExpansionListener {
        private ListenersImpl() {
        }

        public void graphBoundsChanged(Graph graph) {
            SelectionModel.this.updateSelectedItems();
        }

        public void graphLinksChanged(Graph graph) {
            SelectionModel.this.updateSelectedItems();
        }

        public void graphContentChanged(Graph graph) {
            SelectionModel.this.updateSelectedItems();
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            Object[] objectArray = treeModelEvent.getChildren();
            for (int i = 0; i < objectArray.length; ++i) {
                MapperTreePath mapperTreePath = new MapperTreePath(treePath, objectArray[i]);
                if (!Utils.equal(mapperTreePath, SelectionModel.this.selectedPath)) continue;
                SelectionModel.this.updateGraph(true);
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreePath treePath = treeModelEvent.getTreePath();
            Object object = treePath.getLastPathComponent();
            Object[] objectArray = treeModelEvent.getChildren();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2;
                Object object3 = objectArray[i];
                MapperTreePath mapperTreePath = new MapperTreePath(treePath, object3);
                boolean bl = false;
                for (object2 = SelectionModel.this.selectedPath; object2 != null; object2 = ((TreePath)object2).getParentPath()) {
                    if (!Utils.equal(object2, mapperTreePath)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                object2 = SelectionModel.this.getMapperModel();
                int n = object2.getChildCount(object);
                int n2 = Math.min(treeModelEvent.getChildIndices()[i], n - 1);
                if (n2 < 0) {
                    SelectionModel.this.setSelected(treePath);
                    continue;
                }
                SelectionModel.this.setSelected(new MapperTreePath(treePath, object2.getChild(object, n2)));
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == SelectionModel.this.getMapper() && propertyChangeEvent.getPropertyName() == "mapper-model-property") {
                SelectionModel.this.updateMapperModel();
            }
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            TreePath treePath2 = SelectionModel.this.selectedPath;
            if (treePath2 != null) {
                for (treePath2 = treePath2.getParentPath(); treePath2 != null; treePath2 = treePath2.getParentPath()) {
                    if (!Utils.equal(treePath2, treePath)) continue;
                    SelectionModel.this.setSelectedPathImpl(treePath);
                    return;
                }
            }
        }
    }
}

