/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore.demo;

import java.awt.datatransfer.Transferable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.model.Constant;
import org.netbeans.modules.soa.mappercore.model.Function;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.GraphSubset;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.model.Operation;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.TargetPin;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.soa.mappercore.utils.GraphLayout;

public class DemoMapperModel
extends DefaultTreeModel
implements MapperModel {
    private Map<Object, Graph> graphs = new HashMap<Object, Graph>();
    private Map<TreePath, TreeSourcePin> treeEdgeSources = new HashMap<TreePath, TreeSourcePin>();
    private TreeModel leftTreeModel = DemoMapperModel.createDefaultTreeModel();
    private Graph stubGraph;

    public DemoMapperModel() {
        super(new DefaultMutableTreeNode("Root Node"));
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Music");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Classic");
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Richard Wagner");
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("Ludwig van Beethoven");
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode("Rock and Roll");
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode("T-Rex");
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode("Fruits");
        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        defaultMutableTreeNode3.add(defaultMutableTreeNode5);
        defaultMutableTreeNode6.add(defaultMutableTreeNode7);
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode2.add(defaultMutableTreeNode6);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode8);
        this.graphs.put(defaultMutableTreeNode5, this.createSamleGraph1());
        this.graphs.put(defaultMutableTreeNode6, this.createSamleGraph2());
        this.stubGraph = new Graph(this, null);
    }

    public TreeModel getLeftTreeModel() {
        return this.leftTreeModel;
    }

    public void addChild(TreePath treePath, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        int n = defaultMutableTreeNode.getChildCount();
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.nodesWereInserted(defaultMutableTreeNode, new int[]{n});
    }

    public void remove(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getParentPath().getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        int n = defaultMutableTreeNode.getIndex(defaultMutableTreeNode2);
        defaultMutableTreeNode.remove(n);
        this.nodesWereRemoved(defaultMutableTreeNode, new int[]{n}, new Object[]{defaultMutableTreeNode2});
    }

    public Graph getGraph(TreePath treePath) {
        Graph graph = this.graphs.get(treePath.getLastPathComponent());
        return graph == null ? this.stubGraph : graph;
    }

    public boolean searchGraphsInside(TreePath treePath) {
        return !this.isLeaf(treePath.getLastPathComponent());
    }

    public TreeSourcePin getTreeSourcePin(TreePath treePath) {
        TreeSourcePin treeSourcePin = this.treeEdgeSources.get(treePath);
        if (treeSourcePin == null) {
            treeSourcePin = new TreeSourcePin(treePath);
            this.treeEdgeSources.put(treePath, treeSourcePin);
        }
        return treeSourcePin;
    }

    private Graph createSamleGraph1() {
        Graph graph = new Graph(this, null);
        Constant constant = DemoMapperModel.createNumber(1200);
        Constant constant2 = DemoMapperModel.createNumber(1600);
        Function function = DemoMapperModel.createConcat();
        constant.setLocation(5, 0);
        constant2.setLocation(-1, 5);
        function.setLocation(20, 4);
        Link link = new Link(constant, function.getItem(1));
        Link link2 = new Link(function, graph);
        graph.addVertex(constant);
        graph.addVertex(constant2);
        graph.addVertex(function);
        graph.addLink(link);
        graph.addLink(link2);
        GraphLayout.layout(graph);
        return graph;
    }

    private Graph createSamleGraph2() {
        Graph graph = new Graph(this, null);
        Operation operation = DemoMapperModel.createPlus();
        Operation operation2 = DemoMapperModel.createPlus();
        operation.setLocation(10, 4);
        Object[] objectArray = new Object[]{this.leftTreeModel.getRoot(), null, null};
        objectArray[1] = this.leftTreeModel.getChild(objectArray[0], 1);
        objectArray[2] = this.leftTreeModel.getChild(objectArray[1], 2);
        Object[] objectArray2 = new Object[]{this.leftTreeModel.getRoot(), null, null};
        objectArray2[1] = this.leftTreeModel.getChild(objectArray2[0], 2);
        objectArray2[2] = this.leftTreeModel.getChild(objectArray2[1], 1);
        Link link = new Link(operation, graph);
        Link link2 = new Link(this.getTreeSourcePin(new TreePath(objectArray)), operation2.getItem(1));
        Link link3 = new Link(this.getTreeSourcePin(new TreePath(objectArray2)), operation2.getItem(0));
        graph.addVertex(operation);
        graph.addVertex(operation2);
        graph.addLink(link);
        graph.addLink(link2);
        graph.addLink(link3);
        return graph;
    }

    private static Function createConcat() {
        Function function = new Function(null, null, "Concat", "Returns String");
        function.addItem(new VertexItem((Vertex)function, null));
        function.addItem(new VertexItem(function, null, "Huba", String.class));
        function.addItem(new VertexItem(function, null, null, String.class));
        return function;
    }

    private static Operation createPlus() {
        Operation operation = new Operation(null, null);
        operation.addItem(new VertexItem(operation, null, Number.class));
        operation.addItem(new VertexItem(operation, null, Number.class));
        return operation;
    }

    private static Constant createNumber(int n) {
        Constant constant = new Constant(null, null);
        constant.addItem(new VertexItem(constant, null, new Integer(n), Number.class));
        return constant;
    }

    private static TreeModel createDefaultTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("LeftTree");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("colors");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("blue"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("violet"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("red"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("yellow"));
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("sports");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("basketball"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("soccer"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("football"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("hockey"));
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("food");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("hot dogs"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("pizza"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ravioli"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("bananas"));
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    public boolean canConnect(TreePath treePath, SourcePin sourcePin, TargetPin targetPin, TreePath treePath2, Link link) {
        return link == null;
    }

    public void connect(TreePath treePath, SourcePin sourcePin, TargetPin targetPin, TreePath treePath2, Link link) {
        TreePath treePath3;
        Graph graph;
        if (treePath2 != null && link != null) {
            link.disconnect();
        }
        Object object = treePath.getLastPathComponent();
        Graph graph2 = this.getGraph(treePath);
        if (graph2 == this.stubGraph) {
            graph = new Graph(this, null);
            targetPin = graph;
        } else {
            graph = graph2;
        }
        Link link2 = new Link(sourcePin, targetPin);
        graph.addLink(link2);
        if (graph != graph2) {
            this.graphs.put(object, graph);
        }
        if ((treePath3 = treePath.getParentPath()) != null) {
            Object object2 = treePath3.getLastPathComponent();
            int n = this.getIndexOfChild(object2, object);
            this.fireTreeNodesChanged(this, treePath3.getPath(), new int[]{n}, new Object[]{object});
        } else {
            this.fireTreeNodesChanged(this, treePath.getPath(), null, null);
        }
    }

    public GraphSubset getGraphSubset(Transferable transferable) {
        Function function = new Function(null, null, "Drop Test", "Something");
        function.addItem(new VertexItem((Vertex)function, "blah, blah"));
        return new GraphSubset(function);
    }

    public GraphSubset copy(TreePath treePath, GraphSubset graphSubset, int n, int n2) {
        TreePath treePath2;
        Object object;
        Object object2 = treePath.getLastPathComponent();
        Graph graph = this.getGraph(treePath);
        Graph graph2 = graph == this.stubGraph ? new Graph(this, null) : graph;
        for (int i = graphSubset.getVertexCount() - 1; i >= 0; --i) {
            object = graphSubset.getVertex(i);
            ((Vertex)object).setLocation(n, n2);
            graph2.addVertex((Vertex)object);
        }
        if (graph2 != graph) {
            this.graphs.put(object2, graph2);
        }
        if ((treePath2 = treePath.getParentPath()) != null) {
            object = treePath2.getLastPathComponent();
            int n3 = this.getIndexOfChild(object, object2);
            this.fireTreeNodesChanged(this, treePath2.getPath(), new int[]{n3}, new Object[]{object2});
        } else {
            this.fireTreeNodesChanged(this, treePath.getPath(), null, null);
        }
        return null;
    }

    public void move(TreePath treePath, GraphSubset graphSubset, int n, int n2) {
        this.copy(treePath, graphSubset, n, n2);
    }

    public boolean canCopy(TreePath treePath, GraphSubset graphSubset) {
        return true;
    }

    public boolean canMove(TreePath treePath, GraphSubset graphSubset) {
        return true;
    }

    public void valueChanged(TreePath treePath, VertexItem vertexItem, Object object) {
        vertexItem.setValue(object);
    }

    public boolean canEditInplace(VertexItem vertexItem) {
        return true;
    }

    public void delete(TreePath treePath, GraphSubset graphSubset) {
    }
}

