/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore.model;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.CanvasRendererContext;
import org.netbeans.modules.soa.mappercore.LeftTree;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.MapperStyle;
import org.netbeans.modules.soa.mappercore.RightTree;
import org.netbeans.modules.soa.mappercore.graphics.Triangle;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.GraphItem;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.TargetPin;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.soa.mappercore.utils.Utils;

public class Link
implements GraphItem {
    private Graph graph;
    private SourcePin source;
    private TargetPin target;

    public Link() {
    }

    public Link(SourcePin sourcePin, TargetPin targetPin) {
        this.setSource(sourcePin);
        this.setTarget(targetPin);
    }

    public void moveOnTop() {
        this.graph.moveOnTop(this);
    }

    public Graph getGraph() {
        return this.graph;
    }

    void setGraph(Graph graph) {
        this.graph = graph;
    }

    public boolean isInGraph() {
        return this.graph != null;
    }

    public void setSource(SourcePin sourcePin) {
        SourcePin sourcePin2 = this.source;
        if (sourcePin2 != sourcePin) {
            if (sourcePin2 instanceof Vertex) {
                ((Vertex)sourcePin2).setOutgoingLink(null);
            }
            if (sourcePin instanceof Vertex) {
                ((Vertex)sourcePin).setOutgoingLink(this);
            }
            this.source = sourcePin;
            this.fireChanged();
        }
    }

    public SourcePin getSource() {
        return this.source;
    }

    public TargetPin getTarget() {
        return this.target;
    }

    public void connect(SourcePin sourcePin, TargetPin targetPin) {
        this.setSource(sourcePin);
        this.setTarget(targetPin);
    }

    public void disconnect() {
        this.setSource(null);
        this.setTarget(null);
        this.getGraph().removeLink(this);
    }

    public void setTarget(TargetPin targetPin) {
        TargetPin targetPin2 = this.target;
        if (targetPin2 != targetPin) {
            if (targetPin2 instanceof VertexItem) {
                ((VertexItem)targetPin2).setIngoingLink(null);
            }
            if (targetPin instanceof VertexItem) {
                ((VertexItem)targetPin).setIngoingLink(this);
            }
            this.target = targetPin;
            this.fireChanged();
        }
    }

    private void fireChanged() {
        Graph graph = this.getGraph();
        if (graph != null) {
            graph.fireGraphLinksChanges();
        }
    }

    public Point getSourcePoint(CanvasRendererContext canvasRendererContext, int n) {
        if (this.source instanceof Vertex) {
            return ((Vertex)this.source).getSourcePinPoint(canvasRendererContext.getGraphX(), n, canvasRendererContext.getStep());
        }
        if (this.source instanceof TreeSourcePin) {
            LeftTree leftTree = canvasRendererContext.getLeftTree();
            Canvas canvas = canvasRendererContext.getCanvas();
            TreePath treePath = ((TreeSourcePin)this.source).getTreePath();
            int n2 = leftTree.getCenterY(treePath);
            n2 = leftTree.yToMapper(n2);
            n2 = canvas.yFromMapper(n2);
            return new Point(Integer.MIN_VALUE, n2);
        }
        return null;
    }

    public Point getTargetPoint(CanvasRendererContext canvasRendererContext, int n) {
        int n2 = canvasRendererContext.getStep();
        if (this.target instanceof VertexItem) {
            return ((VertexItem)this.target).getTargetPinPoint(canvasRendererContext.getGraphX(), n, n2);
        }
        if (this.target instanceof Graph) {
            if (this.getGraph().isEmptyOrOneLink()) {
                RightTree rightTree = canvasRendererContext.getRightTree();
                int n3 = rightTree.getFontMetrics(rightTree.getFont()).getHeight();
                n3 = Math.max(n3, 16) + 4;
                int n4 = n2 - 1;
                int n5 = n4 / 2 + 1;
                return new Point(Integer.MAX_VALUE, n + n3 / 2 - n5);
            }
            return ((Graph)this.target).getTargetPinPoint(canvasRendererContext.getGraphX(), n, n2);
        }
        return null;
    }

    public void paint(Graphics2D graphics2D, TreePath treePath, CanvasRendererContext canvasRendererContext, int n) {
        Stroke stroke;
        Color color;
        if (this.source == null) {
            return;
        }
        if (this.target == null) {
            return;
        }
        if (!canvasRendererContext.paintLink(treePath, this)) {
            return;
        }
        Mapper mapper = canvasRendererContext.getMapper();
        int n2 = canvasRendererContext.getStep();
        boolean bl = canvasRendererContext.isSelected(treePath, this);
        boolean bl2 = bl ? true : canvasRendererContext.isSelected(treePath);
        Point point = this.getSourcePoint(canvasRendererContext, n);
        Point point2 = this.getTargetPoint(canvasRendererContext, n);
        if (bl) {
            color = MapperStyle.SELECTION_COLOR;
            stroke = MapperStyle.SELECTION_STROKE;
        } else if (bl2) {
            color = MapperStyle.LINK_COLOR_SELECTED_NODE;
            stroke = MapperStyle.LINK_STROKE;
        } else {
            color = MapperStyle.LINK_COLOR_UNSELECTED_NODE;
            stroke = MapperStyle.LINK_STROKE;
        }
        Link.paintLine(graphics2D, color, stroke, point, point2, n2, canvasRendererContext.getCanvasVisibleMinX(), canvasRendererContext.getCanvasVisibleMaxX());
    }

    public double distance(int n, int n2, CanvasRendererContext canvasRendererContext, int n3) {
        if (this.source == null) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.target == null) {
            return Double.POSITIVE_INFINITY;
        }
        Point point = this.getSourcePoint(canvasRendererContext, n3);
        Point point2 = this.getTargetPoint(canvasRendererContext, n3);
        int n4 = canvasRendererContext.getStep();
        int n5 = point.x == Integer.MIN_VALUE ? canvasRendererContext.getCanvasVisibleMinX() : point.x + n4 / 2;
        int n6 = point2.x == Integer.MAX_VALUE ? canvasRendererContext.getCanvasVisibleMaxX() : point2.x - n4 / 2;
        Shape shape = Link.createShape(n5, point.y, n6, point2.y, canvasRendererContext.getStep(), canvasRendererContext.getCanvasVisibleMinX(), canvasRendererContext.getCanvasVisibleMaxX());
        return Utils.distance(shape, n, n2);
    }

    public static void paintLine(Graphics2D graphics2D, Paint paint, Stroke stroke, Point point, Point point2, int n, int n2, int n3) {
        if (point == null) {
            return;
        }
        if (point2 == null) {
            return;
        }
        int n4 = point.x == Integer.MIN_VALUE ? n2 : point.x + n / 2;
        int n5 = point2.x == Integer.MAX_VALUE ? n3 : point2.x - n / 2;
        Link.paintLine(graphics2D, paint, stroke, n4, point.y, n5, point2.y, n, n2, n3);
    }

    public static Shape createShape(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n;
        int n9 = n8 + n5;
        int n10 = n3 == Integer.MAX_VALUE ? n7 : n3;
        int n11 = n10 - n5;
        int n12 = Math.max((n11 - n9) / 4, n5 * 2);
        int n13 = n9 + n12;
        int n14 = n11 - n12;
        int n15 = n2;
        int n16 = n4;
        float f = (float)(n13 + n14) / 2.0f;
        float f2 = (float)(n15 + n16) / 2.0f;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.5f + (float)n8, 0.5f + (float)n15);
        generalPath.lineTo(0.5f + (float)n9, 0.5f + (float)n15);
        generalPath.quadTo(0.5f + (float)n13, 0.5f + (float)n15, 0.5f + f, 0.5f + f2);
        generalPath.quadTo(0.5f + (float)n14, 0.5f + (float)n16, 0.5f + (float)n11, 0.5f + (float)n16);
        generalPath.lineTo(0.5f + (float)n10, 0.5f + (float)n16);
        return generalPath;
    }

    public static void paintLine(Graphics2D graphics2D, Paint paint, Stroke stroke, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Stroke stroke2 = graphics2D.getStroke();
        if (stroke != null) {
            graphics2D.setStroke(stroke);
        }
        graphics2D.setPaint(paint);
        graphics2D.draw(Link.createShape(n, n2, n3, n4, n5, n6, n7));
        graphics2D.setStroke(stroke2);
    }

    public static void paintTargetDecoration(Graphics2D graphics2D, Point point, Color color, int n) {
        if (color == null) {
            color = MapperStyle.LINK_COLOR_SELECTED_NODE;
        }
        int n2 = point.x - 1;
        int n3 = point.y;
        int n4 = n2 - n + 1;
        int n5 = Math.max(1, (n - 1) / 2 - 1);
        graphics2D.translate(0.5, 0.5);
        graphics2D.setPaint(color);
        graphics2D.fill(new Triangle(n2, n3, n4, n3 - n5, n4, n3 + n5));
        graphics2D.translate(-0.5, -0.5);
    }

    public static void paintSourceDecoration(Graphics2D graphics2D, Point point, Color color, int n) {
        if (color == null) {
            color = MapperStyle.LINK_COLOR_SELECTED_NODE;
        }
        int n2 = point.x + n / 2;
        int n3 = point.y;
        int n4 = Math.max(1, (n - 1) / 2 - 1);
        int n5 = n4 * 2;
        graphics2D.translate(0.5, 0.5);
        graphics2D.setPaint(color);
        graphics2D.fillOval(n2 - n4, n3 - n4, n5, n5);
        graphics2D.translate(-0.5, -0.5);
    }
}

