/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.model.jaxb.Group;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaasGroup {
    public static final String PROP_GROUP_NAME = "groupName";
    private final Group delegate;
    private final SaasGroup parent;
    private boolean userDefined = true;
    private SortedMap<String, Saas> services;
    private SortedMap<String, SaasGroup> children;
    private String icon16Path;
    private String icon32Path;

    public SaasGroup(SaasGroup saasGroup, Group group) {
        this.parent = saasGroup;
        this.delegate = group;
        this.services = Collections.synchronizedSortedMap(new TreeMap());
    }

    public SaasGroup getParent() {
        return this.parent;
    }

    public Group getDelegate() {
        return this.delegate;
    }

    public List<Saas> getServices() {
        return Collections.unmodifiableList(new ArrayList<Saas>(this.services.values()));
    }

    public Saas getChildService(String string) {
        this.getServices();
        return (Saas)this.services.get(string);
    }

    public void addService(Saas saas) {
        this.getServices();
        this.services.put(saas.getDisplayName(), saas);
    }

    public boolean removeService(Saas saas) {
        Saas saas2 = (Saas)this.services.remove(saas.getDisplayName());
        return saas2 != null;
    }

    public void setName(String string) {
        if (this.getParent() == null) {
            throw new IllegalArgumentException("Cannot rename root group");
        }
        if (string == null || string.equals(this.getName())) {
            return;
        }
        String string2 = null;
        if (!this.isUserDefined()) {
            string2 = NbBundle.getMessage(this.getClass(), (String)"MSG_GroupNotUserDefined");
        }
        for (SaasGroup saasGroup : this.getParent().getChildrenGroups()) {
            if (!saasGroup.getName().equals(string)) continue;
            string2 = NbBundle.getMessage(this.getClass(), (String)"MSG_DuplicateGroupName");
        }
        if (string2 != null) {
            throw new IllegalArgumentException(string2);
        }
        this.delegate.setName(string);
        this.resetAllServicesGroupPath();
    }

    private void resetAllServicesGroupPath() {
        for (Saas object : this.getServices()) {
            object.computePathFromRoot();
        }
        for (SaasGroup saasGroup : this.getChildrenGroups()) {
            saasGroup.resetAllServicesGroupPath();
        }
    }

    public String getName() {
        return this.delegate.getName();
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    void setUserDefined(boolean bl) {
        if (this.userDefined) {
            this.userDefined = bl;
        }
    }

    public String getIcon16Path() {
        return this.icon16Path;
    }

    protected void setIcon16Path(String string) {
        this.icon16Path = string;
    }

    public String getIcon32Path() {
        return this.icon32Path;
    }

    protected void setIcon32Path(String string) {
        this.icon32Path = string;
    }

    public List<SaasGroup> getChildrenGroups() {
        if (this.children == null) {
            this.children = Collections.synchronizedSortedMap(new TreeMap());
            for (Group group : this.delegate.getGroup()) {
                SaasGroup saasGroup = new SaasGroup(this, group);
                this.children.put(saasGroup.getName(), saasGroup);
            }
        }
        return Collections.unmodifiableList(new ArrayList<SaasGroup>(this.children.values()));
    }

    public SaasGroup getChildGroup(String string) {
        this.getChildrenGroups();
        return (SaasGroup)this.children.get(string);
    }

    protected boolean removeChildGroup(SaasGroup saasGroup) {
        if (!saasGroup.canRemove()) {
            return false;
        }
        this._removeChildGroup(saasGroup);
        return true;
    }

    private void _removeChildGroup(SaasGroup saasGroup) {
        if (saasGroup != null) {
            for (Saas object : saasGroup.getServices()) {
                this.removeService(object);
                SaasServicesModel.getInstance()._removeService(object);
            }
            for (SaasGroup saasGroup2 : saasGroup.getChildrenGroups()) {
                this._removeChildGroup(saasGroup2);
            }
            this.getDelegate().getGroup().remove(saasGroup.getDelegate());
            this.children.remove(saasGroup.getName());
        }
    }

    public boolean canRemove() {
        if (!this.isUserDefined()) {
            return false;
        }
        for (Saas object : this.getServices()) {
            if (object.isUserDefined()) continue;
            return false;
        }
        for (SaasGroup saasGroup : this.getChildrenGroups()) {
            if (saasGroup.canRemove()) continue;
            return false;
        }
        return true;
    }

    protected void addChildGroup(SaasGroup saasGroup) {
        this.getChildrenGroups();
        this.children.put(saasGroup.getName(), saasGroup);
        this.getDelegate().getGroup().add(saasGroup.getDelegate());
    }

    public Group getPathFromRoot() {
        SaasGroup saasGroup = this.getParent();
        if (saasGroup == null) {
            return null;
        }
        Group group = new Group();
        group.setName(this.getName());
        while (saasGroup != SaasServicesModel.getInstance().getRootGroup()) {
            Group group2 = new Group();
            group2.setName(saasGroup.getName());
            group2.getGroup().add(group);
            group = group2;
            saasGroup = saasGroup.getParent();
        }
        return group;
    }

    public boolean serviceExists(String string) {
        SaasGroup saasGroup = this.getRoot();
        return this.serviceExists(saasGroup, string);
    }

    private boolean serviceExists(SaasGroup saasGroup, String string) {
        for (Saas object : saasGroup.getServices()) {
            if (!string.equals(object.getUrl())) continue;
            return true;
        }
        for (SaasGroup saasGroup2 : saasGroup.getChildrenGroups()) {
            if (!this.serviceExists(saasGroup2, string)) continue;
            return true;
        }
        return false;
    }

    protected SaasGroup createGroup(String string) {
        SaasGroup saasGroup2;
        List<SaasGroup> list = this.getChildrenGroups();
        for (SaasGroup saasGroup2 : list) {
            if (!saasGroup2.getName().equals(string)) continue;
            throw new IllegalArgumentException(NbBundle.getMessage(SaasGroup.class, (String)"MSG_GroupAlreadyExists"));
        }
        Group group = new Group();
        group.setName(string);
        saasGroup2 = new SaasGroup(this, group);
        saasGroup2.setUserDefined(true);
        return saasGroup2;
    }

    private SaasGroup getRoot() {
        SaasGroup saasGroup = this;
        SaasGroup saasGroup2 = this;
        while ((saasGroup2 = saasGroup2.getParent()) != null) {
            saasGroup = saasGroup2;
        }
        return saasGroup;
    }

    public String toString() {
        return this.getName();
    }
}

