/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.data.ApplicationVerificationReport;
import com.sun.esb.management.common.data.EndpointInformation;
import com.sun.esb.management.common.data.JavaEEVerifierReport;
import com.sun.esb.management.common.data.helper.ApplicationVerificationReportXMLConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ApplicationVerificationReportReader
extends DefaultHandler
implements ApplicationVerificationReportXMLConstants,
Serializable {
    static final long serialVersionUID = -1L;
    private boolean parsingInProgress;
    private Stack<String> qNameStack = new Stack();
    private EndpointInformation endpointInformation;
    private List<EndpointInformation> endpointInformationList;
    private List<JavaEEVerifierReport> javaEEVerifierReportList;
    private JavaEEVerifierReport javaEEVerifierReport;
    private JavaEEVerifierReport.JavaEEReportItem javaEEVerifierTableItem;
    private List<String> missingComponentsList;
    private ApplicationVerificationReport report;
    private String applicationVerificationReportVersion;
    private List<String> missingAppVars;
    private List<String> missingAppConfigs;

    public ApplicationVerificationReport getApplicationVerificationReport() {
        return this.report;
    }

    public void startDocument() throws SAXException {
        this.parsingInProgress = true;
        this.qNameStack.removeAllElements();
    }

    public void endDocument() throws SAXException {
        this.parsingInProgress = false;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName != null) {
            if (qName.endsWith("ApplicationVerificationReport")) {
                if (attributes != null && attributes.getLength() > 0) {
                    String namespace = attributes.getValue("xmlns");
                    this.applicationVerificationReportVersion = attributes.getValue("version");
                    if (this.applicationVerificationReportVersion != null && "1.0".equals(this.applicationVerificationReportVersion)) {
                        this.report = new ApplicationVerificationReport();
                    }
                }
            } else if (qName.endsWith("MissingComponentsList")) {
                if (this.report != null) {
                    this.missingComponentsList = new ArrayList<String>();
                }
            } else if (qName.endsWith("EndpointInformationList")) {
                if (this.report != null) {
                    this.endpointInformationList = new ArrayList<EndpointInformation>();
                }
            } else if (qName.endsWith("Endpoint")) {
                if (this.report != null && this.endpointInformationList != null) {
                    this.endpointInformation = new EndpointInformation();
                }
            } else if (qName.endsWith("MissingApplicationVariables")) {
                if (this.report != null && this.endpointInformationList != null) {
                    this.missingAppVars = new ArrayList<String>();
                }
            } else if (qName.endsWith("MissingApplicationConfigurations")) {
                if (this.report != null && this.endpointInformationList != null) {
                    this.missingAppConfigs = new ArrayList<String>();
                }
            } else if (qName.endsWith("JavaEEVerifierReports")) {
                if (this.report != null) {
                    this.javaEEVerifierReportList = new ArrayList<JavaEEVerifierReport>();
                }
            } else if (qName.endsWith("JavaEEVerifierReport")) {
                if (this.report != null && this.javaEEVerifierReportList != null) {
                    this.javaEEVerifierReport = new JavaEEVerifierReport();
                }
            } else if (qName.endsWith("ReportItem") && this.report != null && this.javaEEVerifierReport != null) {
                this.javaEEVerifierTableItem = this.javaEEVerifierReport.new JavaEEVerifierReport.JavaEEReportItem();
            }
            this.qNameStack.push(qName);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String chars = new String(ch, start, length);
        String qName = this.qNameStack.peek();
        if (qName.endsWith("ServiceAssemblyName")) {
            if (this.report != null) {
                this.report.setServiceAssemblyName(chars);
            }
        } else if (qName.endsWith("ServiceAssemblyDescription")) {
            if (this.report != null) {
                this.report.setServiceAssemblyDescription(chars);
            }
        } else if (qName.endsWith("NumberOfServiceUnits")) {
            if (this.report != null) {
                int numberOfServiceUnits = Integer.valueOf(chars);
                this.report.setNumberOfServiceUnits(numberOfServiceUnits);
            }
        } else if (qName.endsWith("AllComponentsInstalled")) {
            if (this.report != null) {
                boolean allComponentsInstalled = Boolean.valueOf(chars);
                this.report.setAllComponentsInstalled(allComponentsInstalled);
            }
        } else if (qName.endsWith("TemplateZIPID")) {
            if (this.report != null) {
                this.report.setTemplateZipId(chars);
            }
        } else if (qName.endsWith("MissingComponentName")) {
            if (this.report != null && this.missingComponentsList != null) {
                this.missingComponentsList.add(chars);
            }
        } else if (qName.endsWith("EndpointName")) {
            if (this.report != null && this.endpointInformationList != null && this.endpointInformation != null) {
                this.endpointInformation.setEndpointName(chars);
            }
        } else if (qName.endsWith("ServiceUnitName")) {
            if (this.report != null && this.endpointInformationList != null && this.endpointInformation != null) {
                this.endpointInformation.setServiceUnitName(chars);
            }
        } else if (qName.endsWith("ComponentName")) {
            if (this.report != null && this.endpointInformationList != null && this.endpointInformation != null) {
                this.endpointInformation.setComponentName(chars);
            }
        } else if (qName.endsWith("Status")) {
            if (this.report != null && this.endpointInformationList != null && this.endpointInformation != null) {
                this.endpointInformation.setStatus(chars);
            }
        } else if (qName.endsWith("ApplicationVariable")) {
            if (this.report != null && this.missingAppVars != null) {
                this.missingAppVars.add(chars);
            }
        } else if (qName.endsWith("ApplicationConfiguration")) {
            if (this.report != null && this.missingAppConfigs != null) {
                this.missingAppConfigs.add(chars);
            }
        } else if (qName.endsWith("JavaEESUName")) {
            if (this.report != null && this.javaEEVerifierReportList != null && this.javaEEVerifierReport != null) {
                this.javaEEVerifierReport.setServiceUnitName(chars);
            }
        } else if (qName.endsWith("EarFileName")) {
            if (this.report != null && this.javaEEVerifierReportList != null && this.javaEEVerifierReport != null && this.javaEEVerifierTableItem != null) {
                this.javaEEVerifierTableItem.setEarFileName(chars);
            }
        } else if (qName.endsWith("ReferenceBy")) {
            if (this.report != null && this.javaEEVerifierReportList != null && this.javaEEVerifierReport != null && this.javaEEVerifierTableItem != null) {
                this.javaEEVerifierTableItem.setReferenceBy(chars);
            }
        } else if (qName.endsWith("ReferenceClass")) {
            if (this.report != null && this.javaEEVerifierReportList != null && this.javaEEVerifierReport != null && this.javaEEVerifierTableItem != null) {
                this.javaEEVerifierTableItem.setReferenceClass(chars);
            }
        } else if (qName.endsWith("JndiName")) {
            if (this.report != null && this.javaEEVerifierReportList != null && this.javaEEVerifierReport != null && this.javaEEVerifierTableItem != null) {
                this.javaEEVerifierTableItem.setJndiName(chars);
            }
        } else if (qName.endsWith("JndiClass")) {
            if (this.report != null && this.javaEEVerifierReportList != null && this.javaEEVerifierReport != null && this.javaEEVerifierTableItem != null) {
                this.javaEEVerifierTableItem.setJndiClass(chars);
            }
        } else if (qName.endsWith("Message")) {
            if (this.report != null && this.javaEEVerifierReportList != null && this.javaEEVerifierReport != null && this.javaEEVerifierTableItem != null) {
                this.javaEEVerifierTableItem.setMessage(chars);
            }
        } else if (qName.endsWith("JavaEEStat") && this.report != null && this.javaEEVerifierReportList != null && this.javaEEVerifierReport != null && this.javaEEVerifierTableItem != null) {
            this.javaEEVerifierTableItem.setStatus(Integer.parseInt(chars));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.qNameStack.pop();
        if (qName != null) {
            if (qName.endsWith("MissingComponentsList")) {
                if (this.report != null && this.missingComponentsList != null) {
                    this.report.setMissingComponentsList(this.missingComponentsList);
                    this.missingComponentsList = null;
                }
            } else if (qName.endsWith("EndpointInformationList")) {
                if (this.report != null && this.endpointInformationList != null) {
                    this.report.setEndpointInformationList(this.endpointInformationList);
                    this.endpointInformationList = null;
                }
            } else if (qName.endsWith("Endpoint")) {
                if (this.report != null && this.endpointInformationList != null) {
                    this.endpointInformationList.add(this.endpointInformation);
                    this.endpointInformation = null;
                }
            } else if (qName.endsWith("MissingApplicationVariables")) {
                if (this.report != null && this.missingAppVars != null) {
                    this.endpointInformation.setMissingApplicationVariables(this.missingAppVars.toArray(new String[0]));
                    this.missingAppVars = null;
                }
            } else if (qName.endsWith("MissingApplicationConfigurations")) {
                if (this.report != null && this.missingAppConfigs != null) {
                    this.endpointInformation.setMissingApplicationConfigurations(this.missingAppConfigs.toArray(new String[0]));
                    this.missingAppConfigs = null;
                }
            } else if (qName.endsWith("ReportItem")) {
                if (this.report != null && this.javaEEVerifierReportList != null && this.javaEEVerifierReport != null) {
                    this.javaEEVerifierReport.addJavaEEVerifierReportItem(this.javaEEVerifierTableItem);
                    this.javaEEVerifierTableItem = null;
                }
            } else if (qName.endsWith("JavaEEVerifierReport")) {
                if (this.report != null && this.javaEEVerifierReportList != null && this.javaEEVerifierReport != null) {
                    this.javaEEVerifierReportList.add(this.javaEEVerifierReport);
                    this.javaEEVerifierReport = null;
                }
            } else if (qName.endsWith("JavaEEVerifierReports") && this.report != null && this.javaEEVerifierReportList != null) {
                this.report.setJavaEEVerifierReports(this.javaEEVerifierReportList);
                this.javaEEVerifierReportList = null;
            }
        }
    }

    public static ApplicationVerificationReport parseFromXMLData(String rawXMLData) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        StringReader reader = new StringReader(rawXMLData);
        InputSource inputSource = new InputSource(reader);
        ApplicationVerificationReportReader parser = new ApplicationVerificationReportReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getApplicationVerificationReport();
    }

    public static ApplicationVerificationReport parseFromFile(String fileName) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        File file = new File(fileName);
        return ApplicationVerificationReportReader.parseFromFile(file);
    }

    public static ApplicationVerificationReport parseFromFile(File file) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        FileInputStream inputStream = new FileInputStream(file);
        InputSource inputSource = new InputSource(inputStream);
        ApplicationVerificationReportReader parser = new ApplicationVerificationReportReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getApplicationVerificationReport();
    }

    public static ApplicationVerificationReport parseFromURI(String uriString) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        URI uri = new URI(uriString);
        return ApplicationVerificationReportReader.parseFromURI(uri);
    }

    public static ApplicationVerificationReport parseFromURI(URI uri) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        InputStream inputStream = uri.toURL().openStream();
        InputSource inputSource = new InputSource(inputStream);
        ApplicationVerificationReportReader parser = new ApplicationVerificationReportReader();
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser.getApplicationVerificationReport();
    }

    public static void main(String[] args) {
        String uri = "C:/test/schema/verification/ApplicationVerificationReport.xml";
        try {
            ApplicationVerificationReport report = ApplicationVerificationReportReader.parseFromFile(uri);
            System.out.println(report.getDisplayString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

