/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.impl.configuration;

import com.sun.esb.management.api.configuration.ConfigurationService;
import com.sun.esb.management.base.services.BaseServiceImpl;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.esb.management.common.data.ApplicationVerificationReport;
import com.sun.esb.management.common.data.helper.ApplicationVerificationReportReader;
import com.sun.jbi.ui.common.JarFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.zip.ZipFile;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationServiceImpl
extends BaseServiceImpl
implements Serializable,
ConfigurationService {
    static final long serialVersionUID = -1L;

    public ConfigurationServiceImpl() {
        super(null, false);
    }

    public ConfigurationServiceImpl(MBeanServerConnection serverConnection) {
        super(serverConnection, false);
    }

    public ConfigurationServiceImpl(MBeanServerConnection serverConnection, boolean isRemoteConnection) {
        super(serverConnection, isRemoteConnection);
    }

    @Override
    public boolean isComponentConfigSupported(String componentName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Boolean result = null;
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        result = (Boolean)this.invokeMBeanOperation(mbeanName, "isComponentConfigSupported", params, signature);
        return result;
    }

    @Override
    public boolean isAppConfigSupported(String componentName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Boolean result = null;
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        result = (Boolean)this.invokeMBeanOperation(mbeanName, "isAppConfigSupported", params, signature);
        return result;
    }

    @Override
    public boolean isAppVarsSupported(String componentName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Boolean result = null;
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        result = (Boolean)this.invokeMBeanOperation(mbeanName, "isAppVarsSupported", params, signature);
        return result;
    }

    @Override
    public String addApplicationConfiguration(String componentName, String targetName, String name, Properties config) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String jbiMgtMsgResponse = null;
        Object[] params = new Object[]{componentName, targetName, name, config};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.util.Properties"};
        jbiMgtMsgResponse = (String)this.invokeMBeanOperation(mbeanName, "addApplicationConfiguration", params, signature);
        return jbiMgtMsgResponse;
    }

    @Override
    public String addApplicationVariables(String componentName, String targetName, Properties appVariables) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String result = null;
        Object[] params = new Object[]{componentName, targetName, appVariables};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.util.Properties"};
        result = (String)this.invokeMBeanOperation(mbeanName, "addApplicationVariables", params, signature);
        return result;
    }

    @Override
    public String deleteApplicationConfiguration(String componentName, String targetName, String name) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String jbiMgtMsgResponse = null;
        Object[] params = new Object[]{componentName, targetName, name};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        jbiMgtMsgResponse = (String)this.invokeMBeanOperation(mbeanName, "deleteApplicationConfiguration", params, signature);
        return jbiMgtMsgResponse;
    }

    @Override
    public String deleteApplicationVariables(String componentName, String targetName, String[] appVariableNames) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String result = null;
        Object[] params = new Object[]{componentName, targetName, appVariableNames};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "[Ljava.lang.String;"};
        result = (String)this.invokeMBeanOperation(mbeanName, "deleteApplicationVariables", params, signature);
        return result;
    }

    @Override
    public String exportApplicationConfiguration(String applicationName, String targetName, String configDir) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String result = null;
        Object[] params = new Object[]{applicationName, targetName, configDir};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        result = (String)this.invokeMBeanOperation(mbeanName, "exportApplicationConfiguration", params, signature);
        this.downloadAndExtractZip(result, configDir);
        return result;
    }

    @Override
    public Properties getApplicationConfiguration(String componentName, String name, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Properties appConfig = new Properties();
        Object[] params = new Object[]{componentName, name, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        appConfig = (Properties)this.invokeMBeanOperation(mbeanName, "getApplicationConfiguration", params, signature);
        return appConfig;
    }

    @Override
    public Map<String, Properties> getApplicationConfigurations(String componentName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        HashMap<String, Properties> appConfigMap = new HashMap();
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        appConfigMap = (Map)this.invokeMBeanOperation(mbeanName, "getApplicationConfigurations", params, signature);
        return appConfigMap;
    }

    @Override
    public Properties getApplicationVariables(String componentName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Properties appVarProps = new Properties();
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        appVarProps = (Properties)this.invokeMBeanOperation(mbeanName, "getApplicationVariables", params, signature);
        return appVarProps;
    }

    @Override
    public Properties getComponentConfiguration(String componentName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Properties resultObject = null;
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = (Properties)this.invokeMBeanOperation(mbeanName, "getComponentConfiguration", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, ObjectName[]> getComponentExtensionMBeanObjectNames(String componentName, String extensionName, String targetName) throws ManagementRemoteException {
        HashMap<String, ObjectName[]> result = new HashMap<String, ObjectName[]>();
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        HashMap<String, ObjectName[]> resultObject = null;
        Object[] params = new Object[]{componentName, extensionName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        resultObject = (HashMap<String, ObjectName[]>)this.invokeMBeanOperation(mbeanName, "getComponentExtensionMBeanObjectNames", params, signature);
        Map<String, String[]> targetToInstanceMap = null;
        try {
            targetToInstanceMap = super.listTargetNames();
            if (targetToInstanceMap != null) {
                String[] targetInstanceNames = targetToInstanceMap.get(targetName);
                if (targetInstanceNames != null && resultObject != null) {
                    for (String instanceName : targetInstanceNames) {
                        ObjectName[] values;
                        if (instanceName == null || (values = (ObjectName[])resultObject.get(instanceName)) == null) continue;
                        result.put(instanceName, values);
                    }
                    resultObject = result;
                } else if (resultObject != null) {
                    ObjectName[] values = (ObjectName[])resultObject.get(targetName);
                    if (values != null) {
                        result.put(targetName, values);
                    }
                    resultObject = result;
                }
            }
        }
        catch (ManagementRemoteException e) {
            // empty catch block
        }
        return resultObject;
    }

    @Override
    public ObjectName[] getComponentExtensionMBeanObjectNames(String componentName, String extensionName, String targetName, String targetInstanceName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        ObjectName[] resultObject = null;
        Object[] params = new Object[]{componentName, extensionName, targetName, targetInstanceName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        resultObject = (ObjectName[])this.invokeMBeanOperation(mbeanName, "getComponentExtensionMBeanObjectNames", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, Level> getComponentLoggerLevels(String componentName, String targetName, String targetInstanceName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Map resultObject = null;
        Object[] params = new Object[]{componentName, targetName, targetInstanceName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "getComponentLoggerLevels", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> getComponentLoggerDisplayNames(String componentName, String targetName, String targetInstanceName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Map resultObject = null;
        Object[] params = new Object[]{componentName, targetName, targetInstanceName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "getComponentLoggerDisplayNames", params, signature);
        return resultObject;
    }

    @Override
    public Properties getDefaultRuntimeConfiguration() throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Properties resultObject = null;
        Object[] params = null;
        String[] signature = null;
        resultObject = (Properties)this.invokeMBeanOperation(mbeanName, "getDefaultRuntimeConfiguration", params, signature);
        return resultObject;
    }

    @Override
    public Properties getRuntimeConfiguration(String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Properties resultObject = null;
        Object[] params = new Object[]{targetName};
        String[] signature = new String[]{"java.lang.String"};
        resultObject = (Properties)this.invokeMBeanOperation(mbeanName, "getRuntimeConfiguration", params, signature);
        return resultObject;
    }

    @Override
    public Properties getRuntimeConfigurationMetaData(String propertyKeyName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Properties resultObject = null;
        Object[] params = new Object[]{propertyKeyName};
        String[] signature = new String[]{"java.lang.String"};
        resultObject = (Properties)this.invokeMBeanOperation(mbeanName, "getRuntimeConfigurationMetaData", params, signature);
        return resultObject;
    }

    @Override
    public Level getRuntimeLoggerLevel(String runtimeLoggerName, String targetName, String targetInstanceName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Level resultObject = null;
        Object[] params = new Object[]{runtimeLoggerName, targetName, targetInstanceName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        resultObject = (Level)this.invokeMBeanOperation(mbeanName, "getRuntimeLoggerLevel", params, signature);
        return resultObject;
    }

    @Override
    public Level getRuntimeLoggerLevel(String runtimeLoggerName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Level resultObject = null;
        Object[] params = new Object[]{runtimeLoggerName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = (Level)this.invokeMBeanOperation(mbeanName, "getRuntimeLoggerLevel", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, Level> getRuntimeLoggerLevels(String targetName, String targetInstanceName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Map resultObject = null;
        Object[] params = new Object[]{targetName, targetInstanceName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "getRuntimeLoggerLevels", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, Level> getRuntimeLoggerLevels(String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Map resultObject = null;
        Object[] params = new Object[]{targetName};
        String[] signature = new String[]{"java.lang.String"};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "getRuntimeLoggerLevels", params, signature);
        return resultObject;
    }

    @Override
    public boolean isServerRestartRequired() throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Boolean resultObject = null;
        Object[] params = null;
        String[] signature = null;
        resultObject = (Boolean)this.invokeMBeanOperation(mbeanName, "isServerRestartRequired", params, signature);
        return resultObject;
    }

    @Override
    public String[] listApplicationConfigurationNames(String componentName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String[] appConfigNames = new String[]{};
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        appConfigNames = (String[])this.invokeMBeanOperation(mbeanName, "listApplicationConfigurationNames", params, signature);
        return appConfigNames;
    }

    @Override
    public String setApplicationConfiguration(String componentName, String name, Properties config, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String jbiMgtMsgResponse = null;
        Object[] params = new Object[]{componentName, name, config, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.util.Properties", "java.lang.String"};
        jbiMgtMsgResponse = (String)this.invokeMBeanOperation(mbeanName, "setApplicationConfiguration", params, signature);
        return jbiMgtMsgResponse;
    }

    @Override
    public String setApplicationVariables(String componentName, Properties appVariables, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String result = null;
        Object[] params = new Object[]{componentName, appVariables, targetName};
        String[] signature = new String[]{"java.lang.String", "java.util.Properties", "java.lang.String"};
        result = (String)this.invokeMBeanOperation(mbeanName, "setApplicationVariables", params, signature);
        return result;
    }

    @Override
    public String setComponentConfiguration(String componentName, Properties configurationValues, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String resultObject = null;
        Object[] params = new Object[]{componentName, configurationValues, targetName};
        String[] signature = new String[]{"java.lang.String", "java.util.Properties", "java.lang.String"};
        resultObject = (String)this.invokeMBeanOperation(mbeanName, "setComponentConfiguration", params, signature);
        return resultObject;
    }

    @Override
    public void setComponentLoggerLevel(String componentName, String loggerCustomName, Level logLevel, String targetName, String targetInstanceName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Object[] params = new Object[]{componentName, loggerCustomName, logLevel, targetName, targetInstanceName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.util.logging.Level", "java.lang.String", "java.lang.String"};
        this.invokeMBeanOperation(mbeanName, "setComponentLoggerLevel", params, signature);
    }

    @Override
    public boolean setRuntimeConfiguration(Properties parameters, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Boolean resultObject = null;
        Object[] params = new Object[]{parameters, targetName};
        String[] signature = new String[]{"java.util.Properties", "java.lang.String"};
        resultObject = (Boolean)this.invokeMBeanOperation(mbeanName, "setRuntimeConfiguration", params, signature);
        return resultObject;
    }

    @Override
    public void setRuntimeLoggerLevel(String runtimeLoggerName, Level logLevel, String targetName, String targetInstanceName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Object[] params = new Object[]{runtimeLoggerName, logLevel, targetName, targetInstanceName};
        String[] signature = new String[]{"java.lang.String", "java.util.logging.Level", "java.lang.String", "java.lang.String"};
        this.invokeMBeanOperation(mbeanName, "setRuntimeLoggerLevel", params, signature);
    }

    @Override
    public void setRuntimeLoggerLevel(String runtimeLoggerName, Level logLevel, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Object[] params = new Object[]{runtimeLoggerName, logLevel, targetName};
        String[] signature = new String[]{"java.lang.String", "java.util.logging.Level", "java.lang.String"};
        this.invokeMBeanOperation(mbeanName, "setRuntimeLoggerLevel", params, signature);
    }

    @Override
    public Map<String, String> getRuntimeLoggerNames(String targetName, String targetInstanceName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Map resultObject = null;
        Object[] params = new Object[]{targetName, targetInstanceName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "getRuntimeLoggerNames", params, signature);
        return resultObject;
    }

    @Override
    public Map<String, String> getRuntimeLoggerNames(String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Map resultObject = null;
        Object[] params = new Object[]{targetName};
        String[] signature = new String[]{"java.lang.String"};
        resultObject = (Map)this.invokeMBeanOperation(mbeanName, "getRuntimeLoggerNames", params, signature);
        return resultObject;
    }

    @Override
    public String getRuntimeLoggerDisplayName(String runtimeLoggerName, String targetName, String targetInstanceName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String resultString = null;
        Object[] params = new Object[]{runtimeLoggerName, targetName, targetInstanceName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        resultString = (String)this.invokeMBeanOperation(mbeanName, "getRuntimeLoggerDisplayName", params, signature);
        return resultString;
    }

    @Override
    public String getRuntimeLoggerDisplayName(String runtimeLoggerName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String resultString = null;
        Object[] params = new Object[]{runtimeLoggerName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        resultString = (String)this.invokeMBeanOperation(mbeanName, "getRuntimeLoggerDisplayName", params, signature);
        return resultString;
    }

    @Override
    public String verifyApplication(String applicationURL, boolean generateTemplates, String templateDir, boolean includeDeployCommand, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String appFilePath = applicationURL;
        if (this.isRemoteConnection()) {
            appFilePath = this.uploadFile(applicationURL);
        }
        Object[] params = new Object[]{appFilePath, generateTemplates, templateDir, includeDeployCommand, targetName};
        String[] signature = new String[]{"java.lang.String", "boolean", "java.lang.String", "boolean", "java.lang.String"};
        String rawXMLData = (String)this.invokeMBeanOperation(mbeanName, "verifyApplication", params, signature);
        ApplicationVerificationReport report = null;
        try {
            report = ApplicationVerificationReportReader.parseFromXMLData(rawXMLData);
        }
        catch (MalformedURLException e) {
            throw new ManagementRemoteException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ManagementRemoteException(e);
        }
        catch (SAXException e) {
            throw new ManagementRemoteException(e);
        }
        catch (URISyntaxException e) {
            throw new ManagementRemoteException(e);
        }
        catch (IOException e) {
            throw new ManagementRemoteException(e);
        }
        if (generateTemplates) {
            this.downloadAndExtractZip(report.getTemplateZipId(), templateDir);
        }
        return rawXMLData;
    }

    protected void downloadAndExtractZip(String filePath, String templateDir) throws ManagementRemoteException {
        try {
            File directory = new File(templateDir);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            String fileName = this.downloadFile(templateDir, filePath);
            JarFactory jarFactory = new JarFactory(templateDir);
            File templateZip = new File(templateDir, fileName);
            ZipFile zipFile = new ZipFile(templateZip);
            jarFactory.unJar(zipFile);
            if (templateZip.isFile()) {
                zipFile = null;
                if (!templateZip.delete()) {
                    templateZip.deleteOnExit();
                }
            }
        }
        catch (Exception ex) {
            throw new ManagementRemoteException(ex);
        }
    }

    @Override
    public CompositeType queryApplicationConfigurationType(String componentName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        CompositeType appCfgType = null;
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        appCfgType = (CompositeType)this.invokeMBeanOperation(mbeanName, "queryApplicationConfigurationType", params, signature);
        return appCfgType;
    }

    @Override
    public String retrieveConfigurationDisplaySchema(String componentName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String schema = "";
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        schema = (String)this.invokeMBeanOperation(mbeanName, "retrieveConfigurationDisplaySchema", params, signature);
        return schema;
    }

    @Override
    public String retrieveConfigurationDisplayData(String componentName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String data = "";
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        data = (String)this.invokeMBeanOperation(mbeanName, "retrieveConfigurationDisplayData", params, signature);
        return data;
    }

    @Override
    public String addApplicationConfiguration(String componentName, String targetName, String name, CompositeData appConfig) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String data = "";
        Object[] params = new Object[]{componentName, targetName, name, appConfig};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "javax.management.openmbean.CompositeData"};
        data = (String)this.invokeMBeanOperation(mbeanName, "addApplicationConfiguration", params, signature);
        return data;
    }

    @Override
    public String setApplicationConfiguration(String componentName, String targetName, String name, CompositeData appConfig) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String data = "";
        Object[] params = new Object[]{componentName, targetName, name, appConfig};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "javax.management.openmbean.CompositeData"};
        data = (String)this.invokeMBeanOperation(mbeanName, "setApplicationConfiguration", params, signature);
        return data;
    }

    @Override
    public TabularData getApplicationConfigurationsAsTabularData(String componentName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        TabularData data = null;
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        data = (TabularData)this.invokeMBeanOperation(mbeanName, "getApplicationConfigurationsAsTabularData", params, signature);
        return data;
    }

    @Override
    public TabularData getApplicationVariablesAsTabularData(String componentName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        TabularData data = null;
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        data = (TabularData)this.invokeMBeanOperation(mbeanName, "getApplicationVariablesAsTabularData", params, signature);
        return data;
    }

    @Override
    public String addApplicationVariable(String componentName, String targetName, String name, CompositeData appVar) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String data = "";
        Object[] params = new Object[]{componentName, targetName, name, appVar};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "javax.management.openmbean.CompositeData"};
        data = (String)this.invokeMBeanOperation(mbeanName, "addApplicationVariable", params, signature);
        return data;
    }

    @Override
    public String setApplicationVariable(String componentName, String targetName, String name, CompositeData appVar) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String data = "";
        Object[] params = new Object[]{componentName, targetName, name, appVar};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "javax.management.openmbean.CompositeData"};
        data = (String)this.invokeMBeanOperation(mbeanName, "setApplicationVariable", params, signature);
        return data;
    }

    @Override
    public Map<String, Object> getDefaultRuntimeConfigurationAsMap() throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Map data = null;
        Object[] params = null;
        String[] signature = null;
        data = (Map)this.invokeMBeanOperation(mbeanName, "getDefaultRuntimeConfigurationAsMap", params, signature);
        return data;
    }

    @Override
    public Map<String, Object> getRuntimeConfigurationAsMap(String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Map data = null;
        Object[] params = new Object[]{targetName};
        String[] signature = new String[]{"java.lang.String"};
        data = (Map)this.invokeMBeanOperation(mbeanName, "getRuntimeConfigurationAsMap", params, signature);
        return data;
    }

    @Override
    public boolean setRuntimeConfiguration(Map<String, Object> parameters, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Boolean data = null;
        Object[] params = new Object[]{parameters, targetName};
        String[] signature = new String[]{"java.util.Map", "java.lang.String"};
        data = (Boolean)this.invokeMBeanOperation(mbeanName, "setRuntimeConfiguration", params, signature);
        return data;
    }

    @Override
    public Map<String, Object> getComponentConfigurationAsMap(String componentName, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Map data = null;
        Object[] params = new Object[]{componentName, targetName};
        String[] signature = new String[]{"java.lang.String", "java.lang.String"};
        data = (Map)this.invokeMBeanOperation(mbeanName, "getComponentConfigurationAsMap", params, signature);
        return data;
    }

    @Override
    public String setComponentConfiguration(String componentName, Map<String, Object> configurationValues, String targetName) throws ManagementRemoteException {
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        String data = null;
        Object[] params = new Object[]{componentName, configurationValues, targetName};
        String[] signature = new String[]{"java.lang.String", "java.util.Map", "java.lang.String"};
        data = (String)this.invokeMBeanOperation(mbeanName, "setComponentConfiguration", params, signature);
        return data;
    }

    @Override
    public Object invokeExtensionMBeanOperation(String componentName, String extensionName, String operationName, Object[] parameters, String[] signature, String targetName, String targetInstanceName) throws ManagementRemoteException {
        Object result = null;
        ObjectName mbeanName = this.getConfigurationServiceMBeanObjectName();
        Object[] params = new Object[]{componentName, extensionName, operationName, parameters, signature, targetName, targetInstanceName};
        String[] signatureArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "[Ljava.lang.Object;", "[Ljava.lang.String;", "java.lang.String", "java.lang.String"};
        result = this.invokeMBeanOperation(mbeanName, "invokeExtensionMBeanOperation", params, signatureArray);
        return result;
    }

    public static void main(String[] args) {
    }
}

