/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.classfile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.netbeans.lib.profiler.classfile.ClassLoaderTable;
import org.netbeans.lib.profiler.classfile.ClassPath;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.utils.FileOrZipEntry;
import org.netbeans.lib.profiler.utils.MiscUtils;

public class ClassFileCache {
    private static ClassFileCache defaultClassFileCache;
    private ClassPath classPath;
    private Hashtable vmSuppliedClassCache;
    private byte[][] classFileBytes;
    private String[] classNameAndLocation;
    private long[] lastTimeUsed;
    private int capacity = 877;
    private int size = 0;
    private int sizeLimit = this.capacity * 3 / 4;
    private long timeCounter;

    ClassFileCache() {
        this.classNameAndLocation = new String[this.capacity];
        this.classFileBytes = new byte[this.capacity][];
        this.lastTimeUsed = new long[this.capacity];
        this.vmSuppliedClassCache = new Hashtable();
    }

    static ClassFileCache getDefault() {
        if (defaultClassFileCache == null) {
            defaultClassFileCache = new ClassFileCache();
        }
        return defaultClassFileCache;
    }

    static void resetDefaultCache() {
        defaultClassFileCache = null;
    }

    byte[] getClassFile(String string, String string2) throws IOException {
        byte[] byArray;
        String string3 = (string + "#" + string2).intern();
        if (string2.startsWith("<VM_SUPPLIED>")) {
            byArray = (byte[])this.vmSuppliedClassCache.get(string3);
        } else {
            byArray = this.get(string3);
            if (byArray == null) {
                if (this.size > this.sizeLimit) {
                    this.removeLRUEntry();
                }
                byArray = this.readAndPut(string, string2, string3);
            }
        }
        return byArray;
    }

    void addVMSuppliedClassFile(String string, int n, byte[] byArray) {
        String string2 = (string + "#" + "<VM_SUPPLIED>" + n).intern();
        this.vmSuppliedClassCache.put(string2, byArray);
    }

    int hasVMSuppliedClassFile(String string, int n) {
        do {
            boolean bl;
            if (bl = this.vmSuppliedClassCache.containsKey((string + "#" + "<VM_SUPPLIED>" + n).intern())) {
                return n;
            }
            if (n != 0) {
                n = ClassLoaderTable.getParentLoader(n);
            }
            if (n != -1) continue;
            MiscUtils.printWarningMessage("Failed to lookup classloader for: " + string);
            return -1;
        } while (n != 0);
        return -1;
    }

    private byte[] get(String string) {
        int n = (string.hashCode() & Integer.MAX_VALUE) % this.capacity;
        while (this.classNameAndLocation[n] != null && this.classNameAndLocation[n] != string) {
            n = (n + 1) % this.capacity;
        }
        if (this.classNameAndLocation[n] != null) {
            this.lastTimeUsed[n] = ++this.timeCounter;
            return this.classFileBytes[n];
        }
        return null;
    }

    private byte[] readAndPut(String string, String string2, String string3) throws IOException {
        byte[] byArray = this.readClassFile(string, string2);
        int n = (string3.hashCode() & Integer.MAX_VALUE) % this.capacity;
        while (this.classNameAndLocation[n] != null) {
            n = (n + 1) % this.capacity;
        }
        this.classNameAndLocation[n] = string3;
        this.classFileBytes[n] = byArray;
        this.lastTimeUsed[n] = ++this.timeCounter;
        ++this.size;
        return byArray;
    }

    private byte[] readClassFile(String string, String string2) throws IOException {
        int n;
        ZipEntry zipEntry;
        String string3 = string + ".class";
        File file = new File(string2);
        if (file.isDirectory()) {
            return MiscUtils.readFileIntoBuffer(new FileOrZipEntry(string2, string3));
        }
        ZipFile zipFile = null;
        if (this.classPath == null) {
            this.classPath = ClassRepository.getClassPath();
        }
        if (this.classPath != null) {
            try {
                zipFile = this.classPath.getZipFileForName(string2);
            }
            catch (ZipException zipException) {
                throw new IOException("Could not open archive " + string2);
            }
        }
        if ((zipEntry = zipFile.getEntry(string3)) == null) {
            throw new IOException("Could not find entry for " + string3 + " in " + string2);
        }
        int n2 = (int)zipEntry.getSize();
        byte[] byArray = new byte[n2];
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        int n3 = 0;
        int n4 = n2;
        do {
            n = inputStream.read(byArray, n3, n4);
            n4 -= n;
        } while ((n3 += n) < n2);
        inputStream.close();
        return byArray;
    }

    private void removeLRUEntry() {
        long l = Long.MAX_VALUE;
        int n = 0;
        for (int i = 0; i < this.capacity; ++i) {
            if (this.lastTimeUsed[i] <= 0L || this.lastTimeUsed[i] >= l) continue;
            n = i;
        }
        this.classNameAndLocation[n] = null;
        this.classFileBytes[n] = null;
        this.lastTimeUsed[n] = 0L;
        --this.size;
    }
}

