/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.LoadClassSegment;
import org.netbeans.lib.profiler.heap.StringSegment;

class LoadClass
extends HprofObject {
    private final LoadClassSegment loadClassSegment;
    static final /* synthetic */ boolean $assertionsDisabled;

    LoadClass(LoadClassSegment loadClassSegment, long l) {
        super(l);
        this.loadClassSegment = loadClassSegment;
        if (!$assertionsDisabled && this.getHprofBuffer().get(l) != 2) {
            throw new AssertionError();
        }
    }

    long getClassObjectID() {
        return this.getHprofBuffer().getID(this.fileOffset + (long)this.loadClassSegment.classIDOffset);
    }

    String getName() {
        return LoadClass.convertToName(this.getVMName());
    }

    long getNameID() {
        return this.getHprofBuffer().getID(this.fileOffset + (long)this.loadClassSegment.nameStringIDOffset);
    }

    String getVMName() {
        StringSegment stringSegment = this.loadClassSegment.hprofHeap.getStringSegment();
        return stringSegment.getStringByID(this.getNameID());
    }

    private HprofByteBuffer getHprofBuffer() {
        return this.loadClassSegment.hprofHeap.dumpBuffer;
    }

    private static String convertToName(String string) {
        int n;
        String string2 = string.replace('/', '.');
        for (n = 0; n < string2.length() && string2.charAt(n) == '['; ++n) {
        }
        if (n != 0) {
            char c = (string2 = string2.substring(n)).charAt(0);
            if (c == 'L') {
                string2 = string2.substring(1, string2.length() - 1);
            } else {
                switch (c) {
                    case 'C': {
                        string2 = "char";
                        break;
                    }
                    case 'B': {
                        string2 = "byte";
                        break;
                    }
                    case 'I': {
                        string2 = "int";
                        break;
                    }
                    case 'Z': {
                        string2 = "boolean";
                        break;
                    }
                    case 'F': {
                        string2 = "float";
                        break;
                    }
                    case 'D': {
                        string2 = "double";
                        break;
                    }
                    case 'S': {
                        string2 = "short";
                        break;
                    }
                    case 'J': {
                        string2 = "long";
                    }
                }
            }
            while (n > 0) {
                string2 = string2.concat("[]");
                --n;
            }
        }
        return string2;
    }

    static {
        $assertionsDisabled = !LoadClass.class.desiredAssertionStatus();
    }
}

