/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.marker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;

public class PackageMarker
implements Marker {
    private static Logger LOGGER = Logger.getLogger(PackageMarker.class.getName());
    private Map markMap = new HashMap();

    public MarkMapping[] getMappings() {
        ArrayList<MarkMapping> arrayList = new ArrayList<MarkMapping>();
        Iterator iterator = this.markMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ClientUtils.SourceCodeSelection sourceCodeSelection = new ClientUtils.SourceCodeSelection(string, "", "");
            sourceCodeSelection.setMarkerMethod(true);
            arrayList.add(new MarkMapping(sourceCodeSelection, (Mark)this.markMap.get(string)));
        }
        return arrayList.toArray(new MarkMapping[arrayList.size()]);
    }

    public Mark[] getMarks() {
        return new HashSet(this.markMap.values()).toArray(new Mark[0]);
    }

    public void addPackageMark(String string, Mark mark, boolean bl) {
        if (string.length() == 0) {
            string = "default";
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Marking package " + string + " with " + mark.getId());
        }
        this.markMap.put(string + (bl ? ".**" : ".*"), mark);
    }

    public void removePackageMark(String string) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Unmarking package " + string);
        }
        this.markMap.remove(string);
    }

    public void resetPackageMarks() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Unmarking all packages");
        }
        this.markMap.clear();
    }
}

