/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjLivenessTermCCTNode;
import org.netbeans.lib.profiler.results.memory.SurvGenSet;

public class PresoObjLivenessCCTNode
extends PresoObjAllocCCTNode {
    static int currentEpoch;
    public static final int SORT_BY_LIVE_OBJ_SIZE = 1;
    public static final int SORT_BY_LIVE_OBJ_NUMBER = 2;
    public static final int SORT_BY_ALLOC_OBJ = 3;
    public static final int SORT_BY_AVG_AGE = 4;
    public static final int SORT_BY_SURV_GEN = 5;
    public static final int SORT_BY_NAME = 6;
    public static final int SORT_BY_TOTAL_ALLOC_OBJ = 7;
    private static boolean dontShowZeroLiveObjNodes;
    public float avgObjectAge;
    public int nLiveObjects;
    public int survGen;

    protected PresoObjLivenessCCTNode(RuntimeMemoryCCTNode runtimeMemoryCCTNode) {
        super(runtimeMemoryCCTNode);
    }

    public static PresoObjAllocCCTNode createPresentationCCTFromSnapshot(LivenessMemoryResultsSnapshot livenessMemoryResultsSnapshot, RuntimeMemoryCCTNode runtimeMemoryCCTNode, String string, int n, boolean bl) {
        currentEpoch = n;
        dontShowZeroLiveObjNodes = bl;
        SurvGenSet survGenSet = new SurvGenSet();
        PresoObjAllocCCTNode presoObjAllocCCTNode = PresoObjLivenessCCTNode.generateMirrorNode(runtimeMemoryCCTNode, survGenSet);
        if (presoObjAllocCCTNode != null) {
            PresoObjLivenessCCTNode.assignNamesToNodesFromSnapshot(livenessMemoryResultsSnapshot, presoObjAllocCCTNode, string);
        }
        return presoObjAllocCCTNode;
    }

    public static PresoObjAllocCCTNode createPresentationCCTFromVM(ProfilerClient profilerClient, RuntimeMemoryCCTNode runtimeMemoryCCTNode, String string, int n, boolean bl) throws ClientUtils.TargetAppOrVMTerminated {
        currentEpoch = n;
        dontShowZeroLiveObjNodes = bl;
        SurvGenSet survGenSet = new SurvGenSet();
        PresoObjAllocCCTNode presoObjAllocCCTNode = PresoObjLivenessCCTNode.generateMirrorNode(runtimeMemoryCCTNode, survGenSet);
        if (presoObjAllocCCTNode != null) {
            PresoObjLivenessCCTNode.assignNamesToNodesFromVM(profilerClient, presoObjAllocCCTNode, string);
        }
        return presoObjAllocCCTNode;
    }

    public void sortChildren(int n, boolean bl) {
        int n2 = this.getNChildren();
        if (n2 == 0) {
            return;
        }
        for (int i = 0; i < n2; ++i) {
            this.children[i].sortChildren(n, bl);
        }
        if (n2 > 1) {
            switch (n) {
                case 1: {
                    this.sortChildrenByLiveObjSize(bl);
                    break;
                }
                case 2: {
                    this.sortChildrenByLiveObjNumber(bl);
                    break;
                }
                case 3: {
                    this.sortChildrenByAllocObjNumber(bl);
                    break;
                }
                case 4: {
                    this.sortChildrenByAvgAge(bl);
                    break;
                }
                case 5: {
                    this.sortChildrenBySurvGen(bl);
                    break;
                }
                case 6: {
                    this.sortChildrenByName(bl);
                }
            }
        }
    }

    protected static PresoObjAllocCCTNode generateMirrorNode(RuntimeMemoryCCTNode runtimeMemoryCCTNode, SurvGenSet survGenSet) {
        RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray;
        int n;
        Object object;
        PresoObjLivenessCCTNode presoObjLivenessCCTNode = null;
        if (runtimeMemoryCCTNode instanceof RuntimeObjLivenessTermCCTNode) {
            object = (RuntimeObjLivenessTermCCTNode)runtimeMemoryCCTNode;
            int n2 = ((RuntimeObjLivenessTermCCTNode)object).calculateTotalNLiveObjects();
            if (dontShowZeroLiveObjNodes && n2 == 0 && runtimeMemoryCCTNode.children == null) {
                return null;
            }
            presoObjLivenessCCTNode = new PresoObjLivenessCCTNode(runtimeMemoryCCTNode);
            presoObjLivenessCCTNode.nLiveObjects = n2;
            RuntimeObjLivenessTermCCTNode.calculateTotalNumberOfSurvGens((RuntimeMemoryCCTNode)object, survGenSet);
            presoObjLivenessCCTNode.survGen = survGenSet.getTotalNoOfAges();
            presoObjLivenessCCTNode.avgObjectAge = RuntimeObjLivenessTermCCTNode.calculateAvgObjectAgeForAllPaths((RuntimeMemoryCCTNode)object, currentEpoch);
            if (runtimeMemoryCCTNode.children != null) {
                n = runtimeMemoryCCTNode.children instanceof RuntimeMemoryCCTNode ? 1 : ((RuntimeMemoryCCTNode[])runtimeMemoryCCTNode.children).length;
                presoObjLivenessCCTNode.children = new PresoObjAllocCCTNode[n];
            }
        }
        if ((object = runtimeMemoryCCTNode.children) != null && (n = (runtimeMemoryCCTNodeArray = object instanceof RuntimeMemoryCCTNode ? new RuntimeMemoryCCTNode[]{(RuntimeMemoryCCTNode)object} : (RuntimeMemoryCCTNode[])object).length) > 0) {
            double d = 0.0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                SurvGenSet survGenSet2 = n == 1 ? survGenSet : new SurvGenSet();
                PresoObjLivenessCCTNode presoObjLivenessCCTNode2 = (PresoObjLivenessCCTNode)PresoObjLivenessCCTNode.generateMirrorNode(runtimeMemoryCCTNodeArray[i], survGenSet2);
                if (presoObjLivenessCCTNode2 == null) continue;
                if (presoObjLivenessCCTNode == null) {
                    presoObjLivenessCCTNode = new PresoObjLivenessCCTNode(runtimeMemoryCCTNode);
                    presoObjLivenessCCTNode.children = new PresoObjAllocCCTNode[n];
                }
                presoObjLivenessCCTNode.children[n3++] = presoObjLivenessCCTNode2;
                presoObjLivenessCCTNode2.parent = presoObjLivenessCCTNode;
                presoObjLivenessCCTNode.nCalls += presoObjLivenessCCTNode2.nCalls;
                presoObjLivenessCCTNode.totalObjSize += presoObjLivenessCCTNode2.totalObjSize;
                presoObjLivenessCCTNode.nLiveObjects += presoObjLivenessCCTNode2.nLiveObjects;
                d += (double)(presoObjLivenessCCTNode2.avgObjectAge * (float)presoObjLivenessCCTNode2.nLiveObjects);
                if (n <= 1) continue;
                survGenSet.mergeWith(survGenSet2);
            }
            if (dontShowZeroLiveObjNodes && (presoObjLivenessCCTNode == null || presoObjLivenessCCTNode.nLiveObjects == 0)) {
                return null;
            }
            if (n3 < n) {
                PresoObjAllocCCTNode[] presoObjAllocCCTNodeArray = new PresoObjAllocCCTNode[n3];
                System.arraycopy(presoObjLivenessCCTNode.children, 0, presoObjAllocCCTNodeArray, 0, n3);
                presoObjLivenessCCTNode.children = presoObjAllocCCTNodeArray;
            }
            presoObjLivenessCCTNode.avgObjectAge = presoObjLivenessCCTNode.nLiveObjects > 0 ? (float)(d / (double)presoObjLivenessCCTNode.nLiveObjects) : 0.0f;
            presoObjLivenessCCTNode.survGen = survGenSet.getTotalNoOfAges();
        }
        return presoObjLivenessCCTNode;
    }

    protected void sortChildrenByAvgAge(boolean bl) {
        int n = this.children.length;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = ((PresoObjLivenessCCTNode)this.children[i]).avgObjectAge;
        }
        this.sortFloats(fArray, bl);
    }

    protected void sortChildrenByLiveObjNumber(boolean bl) {
        int n = this.children.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = ((PresoObjLivenessCCTNode)this.children[i]).nLiveObjects;
        }
        this.sortInts(nArray, bl);
    }

    protected void sortChildrenByLiveObjSize(boolean bl) {
        this.sortChildrenByAllocObjSize(bl);
    }

    protected void sortChildrenBySurvGen(boolean bl) {
        int n = this.children.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = ((PresoObjLivenessCCTNode)this.children[i]).survGen;
        }
        this.sortInts(nArray, bl);
    }
}

