/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.quicksearch.ProviderModel;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.lookup.Lookups;

final class ProviderRegistry {
    private static final String SEARCH_PROVIDERS_FOLDER = "/QuickSearch";
    private static final String COMMAND_PREFIX = "command";
    private ProviderModel providers;
    private static ProviderRegistry instance;

    private ProviderRegistry() {
    }

    public static ProviderRegistry getInstance() {
        if (instance == null) {
            instance = new ProviderRegistry();
        }
        return instance;
    }

    public ProviderModel getProviders() {
        if (this.providers == null) {
            this.providers = new ProviderModel();
            this.loadProviders(this.providers);
        }
        return this.providers;
    }

    private void loadProviders(ProviderModel providerModel) {
        FileObject[] fileObjectArray = Repository.getDefault().getDefaultFileSystem().findResource(SEARCH_PROVIDERS_FOLDER).getChildren();
        List list = FileUtil.getOrder(Arrays.asList(fileObjectArray), (boolean)false);
        ArrayList<ProviderModel.Category> arrayList = new ArrayList<ProviderModel.Category>(list.size());
        for (FileObject fileObject : list) {
            String string = null;
            try {
                string = fileObject.getFileSystem().getStatus().annotateName(fileObject.getNameExt(), Collections.singleton(fileObject));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Obtaining display name for " + fileObject + " failed.", fileStateInvalidException);
            }
            String string2 = null;
            Object object = fileObject.getAttribute(COMMAND_PREFIX);
            if (object instanceof String) {
                string2 = (String)object;
            }
            Collection collection = Lookups.forPath((String)fileObject.getPath()).lookupAll(SearchProvider.class);
            arrayList.add(new ProviderModel.Category(fileObject.getNameExt(), string, string2, new ArrayList<SearchProvider>(collection)));
        }
        providerModel.setCategories(arrayList);
    }
}

