/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredTableModel
extends AbstractTableModel {
    private TableModel model;
    private String filterString;
    List<List<Object>> rows = new ArrayList<List<Object>>();
    private Integer[] modelIndex;

    public FilteredTableModel(TableModel tableModel) {
        this.model = tableModel;
        this.rebuildRows();
        tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                FilteredTableModel.this.rebuildRows();
            }
        });
    }

    public void setFilterString(String string) {
        this.filterString = string;
        this.rebuildRows();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this.model.getColumnName(n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.model.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.rows.get(n).get(n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    public TableModel getTableModel() {
        return this.model;
    }

    private void rebuildRows() {
        this.rows = new ArrayList<List<Object>>();
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            boolean bl = false;
            for (int j = 0; j < this.model.getColumnCount(); ++j) {
                Object object = this.model.getValueAt(i, j);
                arrayList.add(object);
                if (!(object instanceof String) || !this.filter((String)object)) continue;
                bl = true;
            }
            if (!bl) continue;
            this.rows.add(arrayList);
            linkedList.add(i);
        }
        this.modelIndex = linkedList.toArray(new Integer[linkedList.size()]);
        TableModelEvent tableModelEvent = new TableModelEvent(this);
        this.fireTableChanged(tableModelEvent);
    }

    public int modelIndex(int n) {
        return this.modelIndex[n];
    }

    private boolean filter(String string) {
        if (this.filterString == null || "".equals(this.filterString)) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.toLowerCase().contains(this.filterString.toLowerCase());
    }
}

