/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.refactoring;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.xml.refactoring.XMLRefactoringPlugin;
import org.netbeans.modules.xml.refactoring.impl.UndoRedoProgress;
import org.netbeans.modules.xml.refactoring.spi.RefactoringUtil;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.retriever.catalog.ProjectCatalogSupport;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.AbstractModel;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.EmbeddableRoot;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentModel;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLRefactoringTransaction
implements Transaction {
    AbstractRefactoring request;
    List<RefactoringElementImplementation> elements;
    List<XMLRefactoringPlugin> plugins;
    Referenceable target;
    private Map<Model, UndoManager> undoManagers;
    Model targetModel;
    boolean isLocal = false;
    ModelSource movedTargetModelSource;
    Map<Model, Set<RefactoringElementImplementation>> modelsInRefactoring;
    private boolean commited = false;
    private UndoManager genericChangeUndoManager;
    Map<String, FileObject> targetModelRefs;
    ArrayList<BackupFacility.Handle> ids = new ArrayList();
    private boolean useBackupFacility = false;

    public XMLRefactoringTransaction(Referenceable referenceable, AbstractRefactoring abstractRefactoring) {
        this.target = referenceable;
        this.elements = new ArrayList<RefactoringElementImplementation>();
        this.plugins = new ArrayList<XMLRefactoringPlugin>();
        this.request = abstractRefactoring;
        this.targetModel = SharedUtils.getModel(referenceable);
    }

    public void commit() {
        try {
            if (this.commited) {
                if (this.genericChangeUndoManager != null && this.genericChangeUndoManager.canRedo()) {
                    this.genericChangeUndoManager.redo();
                }
                for (BackupFacility.Handle object : this.ids) {
                    try {
                        object.restore();
                    }
                    catch (IOException model) {
                        model.printStackTrace();
                        throw (RuntimeException)new RuntimeException().initCause(model);
                    }
                }
                if (this.modelsInRefactoring != null) {
                    Set<Model> set = this.modelsInRefactoring.keySet();
                    Iterator string = set.iterator();
                    while (string.hasNext()) {
                        Model message = (Model)string.next();
                        try {
                            if (!(message instanceof AbstractDocumentModel)) continue;
                            ((AbstractDocumentModel)message).sync();
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else {
                this.commited = true;
                this.backup();
                this.process();
            }
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        UndoRedoProgress undoRedoProgress = new UndoRedoProgress();
        undoRedoProgress.start();
        try {
            if (this.genericChangeUndoManager != null && this.genericChangeUndoManager.canUndo()) {
                this.genericChangeUndoManager.undo();
            }
            for (BackupFacility.Handle object : this.ids) {
                try {
                    object.restore();
                }
                catch (IOException model) {
                    model.printStackTrace();
                    throw (RuntimeException)new RuntimeException().initCause(model);
                }
            }
            if (this.modelsInRefactoring != null) {
                Set<Model> set = this.modelsInRefactoring.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Model model = (Model)iterator.next();
                    try {
                        if (!(model instanceof AbstractDocumentModel)) continue;
                        ((AbstractDocumentModel)model).sync();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        finally {
            undoRedoProgress.stop();
        }
    }

    public void register(XMLRefactoringPlugin xMLRefactoringPlugin, List<? extends RefactoringElementImplementation> list) {
        this.elements.addAll(list);
        this.plugins.add(xMLRefactoringPlugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void process() throws IOException {
        block17: {
            if (this.modelsInRefactoring == null) {
                this.modelsInRefactoring = this.getModels();
            }
            Set<Model> set = this.modelsInRefactoring.keySet();
            Set<Model> set2 = RefactoringUtil.getDirtyModels(set, this.targetModel);
            GeneralChangeExecutor generalChangeExecutor = new GeneralChangeExecutor();
            try {
                if (!this.isLocal) {
                    if (generalChangeExecutor.canChange(this.request.getClass(), this.target)) {
                        this.addUndoableListener(generalChangeExecutor);
                        generalChangeExecutor.doChange(this.request);
                    } else {
                        this.addUndoableRefactorListener(this.targetModel);
                    }
                    this.doRefactorTarget();
                    for (Model object : set) {
                        this.addUndoableRefactorListener(object);
                    }
                    for (XMLRefactoringPlugin xMLRefactoringPlugin : this.plugins) {
                        xMLRefactoringPlugin.doRefactoring(this.elements);
                    }
                    break block17;
                }
                if (this.targetModel == null) break block17;
                try {
                    this.addUndoableRefactorListener(this.targetModel);
                    this.targetModel.startTransaction();
                    this.doRefactorTarget();
                    for (XMLRefactoringPlugin xMLRefactoringPlugin : this.plugins) {
                        xMLRefactoringPlugin.doRefactoring(this.elements);
                    }
                }
                finally {
                    if (this.targetModel.isIntransaction()) {
                        this.targetModel.endTransaction();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            finally {
                if (!this.isLocal) {
                    this.removeRefactorUndoEventListeners();
                    this.removeUndoableListener(generalChangeExecutor);
                }
            }
        }
    }

    private synchronized void addUndoableRefactorListener(Model model) {
        FileObject fileObject;
        if (this.undoManagers == null) {
            this.undoManagers = new HashMap<Model, UndoManager>();
        }
        if ((fileObject = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class)) == null) {
            throw new IllegalArgumentException("Could not get source file from provided model");
        }
        for (Model model2 : this.undoManagers.keySet()) {
            FileObject fileObject2 = (FileObject)model2.getModelSource().getLookup().lookup(FileObject.class);
            if (!fileObject.equals(fileObject2)) continue;
            return;
        }
        if (this.undoManagers.get(model) == null) {
            UndoManager undoManager = new UndoManager();
            model.addUndoableRefactorListener((UndoableEditListener)undoManager);
            this.undoManagers.put(model, undoManager);
        }
    }

    private synchronized void removeRefactorUndoEventListeners() {
        if (this.undoManagers == null) {
            return;
        }
        for (Model model : this.undoManagers.keySet()) {
            model.removeUndoableRefactorListener((UndoableEditListener)this.undoManagers.get(model));
        }
    }

    public void doRefactorTarget() throws IOException {
        if (this.target instanceof Nameable && this.request instanceof RenameRefactoring) {
            SharedUtils.renameTarget((Nameable)this.target, ((RenameRefactoring)this.request).getNewName());
        } else if (this.target instanceof NamedReferenceable && this.request instanceof SafeDeleteRefactoring) {
            SharedUtils.deleteTarget((NamedReferenceable)this.target);
        } else if (this.target instanceof Model) {
            // empty if block
        }
    }

    public void register(List<? extends RefactoringElementImplementation> list) {
        if (list != null && list.size() > 0) {
            this.elements.addAll(list);
        }
    }

    public void setLocalScope() {
        this.isLocal = true;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public synchronized boolean canUndo() {
        if (this.undoManagers == null || this.undoManagers.isEmpty()) {
            return false;
        }
        for (UndoManager undoManager : this.undoManagers.values()) {
            if (undoManager.canUndo()) continue;
            return false;
        }
        return true;
    }

    private void refactorFile() throws IOException {
        String string;
        FileObject fileObject;
        FileObject fileObject2;
        if (this.modelsInRefactoring == null) {
            this.modelsInRefactoring = this.getModels();
        }
        Set<Model> set = this.modelsInRefactoring.keySet();
        FileObject fileObject3 = (FileObject)((Model)this.target).getModelSource().getLookup().lookup(FileObject.class);
        assert (fileObject3 != null) : "Failed to lookup for file object in model source";
        RefactoringUtil.saveTargetFile((Model)this.target, set);
        if (this.request instanceof RenameRefactoring) {
            fileObject3 = SharedUtils.renameFile(fileObject3, ((RenameRefactoring)this.request).getNewName());
            this.refreshCatalogModel(fileObject3);
        } else if (this.request instanceof MoveRefactoring) {
            FileObject fileObject4 = SharedUtils.getOrCreateFolder((URL)((MoveRefactoring)this.request).getTarget().lookup(URL.class));
            this.updateTargetModelReferences(this.targetModel, fileObject4);
            RefactoringUtil.saveTargetFile(this.targetModel, set);
            fileObject3 = SharedUtils.moveFile(fileObject3, fileObject4);
            if (fileObject3 != null) {
                this.movedTargetModelSource = Utilities.getModelSource((FileObject)fileObject3, (boolean)true);
                this.updateCatalogForTarget(this.movedTargetModelSource);
                this.refreshCatalogModel(fileObject3);
            }
        } else if (this.request instanceof SingleCopyRefactoring && (fileObject2 = SharedUtils.copyFile(fileObject3, fileObject = SharedUtils.getOrCreateFolder((URL)((SingleCopyRefactoring)this.request).getTarget().lookup(URL.class)), string = ((SingleCopyRefactoring)this.request).getNewName())) != null) {
            Object object;
            this.movedTargetModelSource = Utilities.getModelSource((FileObject)fileObject2, (boolean)true);
            Model model = null;
            Object object2 = this.plugins.iterator();
            while (object2.hasNext() && (model = (object = object2.next()).getModel(this.movedTargetModelSource)) == null) {
            }
            if (model == null) {
                return;
            }
            object2 = new ArrayList();
            for (XMLRefactoringPlugin object3 : this.plugins) {
                object2.addAll(object3.getExternalReferences(this.targetModel));
            }
            if (object2.size() > 0) {
                Object object32;
                boolean bl = !model.isIntransaction();
                ArrayList<Component> arrayList = new ArrayList<Component>();
                for (XMLRefactoringPlugin xMLRefactoringPlugin : this.plugins) {
                    arrayList.addAll(xMLRefactoringPlugin.getExternalReferences(model));
                }
                HashMap hashMap = new HashMap();
                block7: for (Object object32 : arrayList) {
                    for (XMLRefactoringPlugin xMLRefactoringPlugin : this.plugins) {
                        String string2 = xMLRefactoringPlugin.getModelReference((Component)object32);
                        if (string2 == null) continue;
                        hashMap.put(string2, object32);
                        continue block7;
                    }
                }
                CatalogModel catalogModel = (CatalogModel)this.targetModel.getModelSource().getLookup().lookup(CatalogModel.class);
                if (bl) {
                    model.startTransaction();
                }
                object32 = object2.iterator();
                block9: while (object32.hasNext()) {
                    Component component = (Component)object32.next();
                    try {
                        boolean bl2 = true;
                        for (XMLRefactoringPlugin xMLRefactoringPlugin : this.plugins) {
                            String string3;
                            FileObject fileObject4;
                            String string4;
                            block24: {
                                string4 = xMLRefactoringPlugin.getModelReference(component);
                                if (string4 == null) continue;
                                URI uRI = new URI(string4);
                                ModelSource modelSource = null;
                                fileObject4 = null;
                                try {
                                    modelSource = catalogModel.getModelSource(uRI);
                                    fileObject4 = (FileObject)modelSource.getLookup().lookup(FileObject.class);
                                }
                                catch (CatalogModelException catalogModelException) {
                                    fileObject4 = SharedUtils.getFileObject(this.targetModel, uRI);
                                    if (fileObject4 == null) break block24;
                                    bl2 = SharedUtils.inSameProject(fileObject, fileObject4);
                                }
                            }
                            if (fileObject4 == null) continue block9;
                            Component component2 = (Component)hashMap.get(string4);
                            if (bl2) {
                                string3 = SharedUtils.getReferenceURI(fileObject, fileObject4).toString();
                                if (component2 == null) continue block9;
                                xMLRefactoringPlugin.setModelReference(component2, string3);
                                continue block9;
                            }
                            string3 = fileObject4.getURL().toString();
                            if (component2 == null) continue block9;
                            xMLRefactoringPlugin.setModelReference(component2, string3);
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
                if (bl && model.isIntransaction()) {
                    model.endTransaction();
                }
            }
            RefactoringUtil.saveTargetFile(model, set);
        }
    }

    private void refreshCatalogModel(FileObject fileObject) {
        if (this.modelsInRefactoring == null) {
            this.modelsInRefactoring = this.getModels();
        }
        boolean bl = false;
        Set<Model> set = this.modelsInRefactoring.keySet();
        for (Model model : set) {
            FileObject fileObject2 = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
            ProjectCatalogSupport projectCatalogSupport = SharedUtils.getCatalogSupport(fileObject2);
            if (projectCatalogSupport == null) continue;
            Set<RefactoringElementImplementation> set2 = this.modelsInRefactoring.get(model);
            for (Component component : this.getRefactorComponents(set2)) {
                String string = this.getModelReference(component);
                if (string == null) continue;
                try {
                    if (projectCatalogSupport != null && projectCatalogSupport.removeCatalogEntry(new URI(string))) {
                        projectCatalogSupport.createCatalogEntry(fileObject2, fileObject);
                        bl = true;
                    }
                    if (projectCatalogSupport == null || bl) continue;
                    Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                    Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject2);
                    if (!SharedUtils.getProjectReferences(project2).contains(project)) continue;
                    projectCatalogSupport.createCatalogEntry(fileObject2, fileObject);
                }
                catch (Exception exception) {
                    Logger.getLogger(SharedUtils.class.getName()).log(Level.FINE, exception.getMessage());
                }
            }
        }
    }

    private List<Component> getRefactorComponents(Set<RefactoringElementImplementation> set) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (RefactoringElementImplementation refactoringElementImplementation : set) {
            if (!refactoringElementImplementation.isEnabled()) continue;
            arrayList.add((Component)refactoringElementImplementation.getLookup().lookup(Component.class));
        }
        return arrayList;
    }

    private String getModelReference(Component component) {
        String string = null;
        for (XMLRefactoringPlugin xMLRefactoringPlugin : this.plugins) {
            string = xMLRefactoringPlugin.getModelReference(component);
            if (string == null) continue;
            return string;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void undoRenameFile() throws IOException {
        CatalogModel catalogModel = (CatalogModel)((Model)this.target).getModelSource().getLookup().lookup(CatalogModel.class);
        FileObject fileObject = (FileObject)((Model)this.target).getModelSource().getLookup().lookup(FileObject.class);
        if (this.request instanceof RenameRefactoring) {
            String string = (String)this.request.getContext().lookup(String.class);
            if (string == null || string.equals("")) {
                throw new IOException("Unable to undo refactoring. Cannot retrieve old file name");
            }
            fileObject = SharedUtils.renameFile(fileObject, string);
            this.refreshCatalogModel(fileObject);
            return;
        } else if (this.request instanceof MoveRefactoring) {
            XMLRefactoringPlugin xMLRefactoringPlugin;
            URL uRL = (URL)((MoveRefactoring)this.request).getContext().lookup(URL.class);
            if (uRL == null) {
                throw new IOException("Unable to undo refactoring. Cannot retrieve original package location");
            }
            FileObject fileObject2 = SharedUtils.getOrCreateFolder(uRL);
            if (this.movedTargetModelSource == null) throw new IOException("Unable to undo Move Refactoring");
            Model model = null;
            Object object = this.plugins.iterator();
            while (object.hasNext() && (model = (xMLRefactoringPlugin = object.next()).getModel(this.movedTargetModelSource)) == null) {
            }
            if (model != null) {
                if (this.modelsInRefactoring == null) {
                    this.modelsInRefactoring = this.getModels();
                }
                object = this.modelsInRefactoring.keySet();
                this.updateTargetModelReferences(model, fileObject2);
                RefactoringUtil.saveTargetFile(model, (Set<Model>)object);
            }
            if ((fileObject = SharedUtils.moveFile((FileObject)(object = (FileObject)this.movedTargetModelSource.getLookup().lookup(FileObject.class)), fileObject2)) == null) return;
            xMLRefactoringPlugin = Utilities.getModelSource((FileObject)fileObject, (boolean)true);
            model = null;
            for (XMLRefactoringPlugin xMLRefactoringPlugin2 : this.plugins) {
                model = xMLRefactoringPlugin2.getModel((ModelSource)xMLRefactoringPlugin);
                if (model == null) continue;
                this.targetModel = model;
                break;
            }
            this.refreshCatalogModel(fileObject);
            return;
        } else {
            if (!(this.request instanceof SingleCopyRefactoring)) return;
            FileObject fileObject3 = (FileObject)this.movedTargetModelSource.getLookup().lookup(FileObject.class);
            fileObject3.delete();
        }
    }

    public String refactorForPreview(Model model) {
        try {
            Object object;
            if (this.modelsInRefactoring == null) {
                this.modelsInRefactoring = this.getModels();
            }
            Model model2 = null;
            if (model instanceof DocumentModel && (object = ((DocumentModel)model).getRootComponent()) instanceof EmbeddableRoot && ((EmbeddableRoot)object).getForeignParent() != null) {
                model2 = ((EmbeddableRoot)object).getForeignParent().getModel();
            }
            if (model2 == null) {
                model2 = model;
            }
            object = this.modelsInRefactoring.get(model2);
            ArrayList<RefactoringElementImplementation> arrayList = new ArrayList<RefactoringElementImplementation>((Collection<RefactoringElementImplementation>)object);
            if (!(this.target instanceof Model) || !(this.request instanceof RenameRefactoring) && !(this.request instanceof MoveRefactoring)) {
                this.targetModel.startTransaction();
                this.doRefactorTarget();
            }
            if (this.targetModel != model2) {
                model2.startTransaction();
            }
            for (XMLRefactoringPlugin xMLRefactoringPlugin : this.plugins) {
                xMLRefactoringPlugin.doRefactoring(arrayList);
            }
            String string = ((AbstractDocumentModel)model2).getAccess().getCurrentDocumentText();
            if (!(this.target instanceof Model) || !(this.request instanceof RenameRefactoring)) {
                ((AbstractModel)this.targetModel).rollbackTransaction();
            }
            ((AbstractModel)model2).rollbackTransaction();
            return string;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            exception.printStackTrace();
            return "";
        }
    }

    private Map<Model, Set<RefactoringElementImplementation>> getModels() {
        HashMap<Model, Set<RefactoringElementImplementation>> hashMap = new HashMap<Model, Set<RefactoringElementImplementation>>();
        for (RefactoringElementImplementation refactoringElementImplementation : this.elements) {
            Object object;
            Component component = (Component)refactoringElementImplementation.getLookup().lookup(Component.class);
            Model model = null;
            if (component.getModel() instanceof DocumentModel && (object = ((DocumentModel)component.getModel()).getRootComponent()) instanceof EmbeddableRoot && ((EmbeddableRoot)object).getForeignParent() != null) {
                model = ((EmbeddableRoot)object).getForeignParent().getModel();
            }
            if (model == null) {
                model = component.getModel();
            }
            if (model == null) continue;
            object = (Set)hashMap.get(model);
            if (object == null) {
                object = new HashSet();
                object.add(refactoringElementImplementation);
                hashMap.put(model, (Set<RefactoringElementImplementation>)object);
                continue;
            }
            object.add(refactoringElementImplementation);
        }
        return hashMap;
    }

    public synchronized void redo() throws CannotRedoException {
        if (this.modelsInRefactoring == null) {
            this.modelsInRefactoring = this.getModels();
        }
        Set<Model> set = this.modelsInRefactoring.keySet();
        Set<Model> set2 = RefactoringUtil.getDirtyModels(set, this.targetModel);
        if (this.genericChangeUndoManager != null && this.genericChangeUndoManager.canRedo()) {
            this.genericChangeUndoManager.redo();
        }
        if (this.undoManagers != null) {
            for (UndoManager object : this.undoManagers.values()) {
                while (object.canRedo()) {
                    object.redo();
                }
            }
        }
        if (this.undoManagers != null) {
            Set<Model> set3 = this.undoManagers.keySet();
            Iterator iterator = set3.iterator();
            while (iterator.hasNext()) {
                Model model = (Model)iterator.next();
                if (!(model instanceof AbstractDocumentModel)) continue;
                ((AbstractDocumentModel)model).getAccess().flush();
            }
        }
        if (!this.isLocal) {
            RefactoringUtil.save(set, this.targetModel, set2);
        }
    }

    public synchronized boolean canRedo() {
        if (this.undoManagers == null || this.undoManagers.isEmpty()) {
            return false;
        }
        for (UndoManager undoManager : this.undoManagers.values()) {
            if (undoManager.canRedo()) continue;
            return false;
        }
        return this.genericChangeUndoManager == null || this.genericChangeUndoManager.canRedo();
    }

    private synchronized void addUndoableListener(GeneralChangeExecutor generalChangeExecutor) {
        this.genericChangeUndoManager = new UndoManager();
        generalChangeExecutor.addUndoableEditListener(this.genericChangeUndoManager);
    }

    private synchronized void removeUndoableListener(GeneralChangeExecutor generalChangeExecutor) {
        if (!(generalChangeExecutor instanceof GeneralChangeExecutor) || this.genericChangeUndoManager == null || generalChangeExecutor == null) {
            return;
        }
        generalChangeExecutor.removeUndoableEditListener(this.genericChangeUndoManager);
    }

    private void updateTargetModelReferences(Model model, FileObject fileObject) throws IOException {
        this.targetModelRefs = new HashMap<String, FileObject>();
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (XMLRefactoringPlugin xMLRefactoringPlugin : this.plugins) {
            arrayList.addAll(xMLRefactoringPlugin.getExternalReferences(model));
        }
        if (arrayList.size() > 0) {
            XMLRefactoringPlugin xMLRefactoringPlugin;
            boolean bl = !model.isIntransaction();
            xMLRefactoringPlugin = (CatalogModel)model.getModelSource().getLookup().lookup(CatalogModel.class);
            if (bl) {
                model.startTransaction();
            }
            block5: for (Component component : arrayList) {
                try {
                    boolean bl2 = true;
                    for (XMLRefactoringPlugin xMLRefactoringPlugin2 : this.plugins) {
                        String string;
                        FileObject fileObject2;
                        block11: {
                            String string2 = xMLRefactoringPlugin2.getModelReference(component);
                            if (string2 == null) continue;
                            URI uRI = new URI(string2);
                            ModelSource modelSource = null;
                            fileObject2 = null;
                            try {
                                modelSource = xMLRefactoringPlugin.getModelSource(uRI);
                                fileObject2 = (FileObject)modelSource.getLookup().lookup(FileObject.class);
                            }
                            catch (Exception exception) {
                                fileObject2 = SharedUtils.getFileObject(model, uRI);
                                if (fileObject2 == null) break block11;
                                bl2 = SharedUtils.inSameProject(fileObject, fileObject2);
                            }
                        }
                        if (fileObject2 == null) continue block5;
                        if (bl2) {
                            string = SharedUtils.getReferenceURI(fileObject, fileObject2).toString();
                            xMLRefactoringPlugin2.setModelReference(component, string);
                            if (SharedUtils.inSameProject(fileObject, fileObject2)) continue block5;
                            this.targetModelRefs.put(string, fileObject2);
                            continue block5;
                        }
                        string = fileObject2.getURL().toString();
                        xMLRefactoringPlugin2.setModelReference(component, string);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            if (bl && model.isIntransaction()) {
                model.endTransaction();
            }
        }
    }

    private void updateCatalogForTarget(ModelSource modelSource) {
        FileObject fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class);
        ProjectCatalogSupport projectCatalogSupport = SharedUtils.getCatalogSupport(fileObject);
        if (projectCatalogSupport == null) {
            return;
        }
        if (this.targetModelRefs == null || this.targetModelRefs.size() == 0) {
            return;
        }
        Set<String> set = this.targetModelRefs.keySet();
        for (String string : set) {
            FileObject fileObject2 = this.targetModelRefs.get(string);
            if (fileObject2 == null) continue;
            try {
                projectCatalogSupport.createCatalogEntry(fileObject, fileObject2);
            }
            catch (CatalogModelException catalogModelException) {
            }
            catch (IOException iOException) {}
        }
    }

    private void backup() throws IOException {
        boolean bl = false;
        if (this.modelsInRefactoring == null) {
            this.modelsInRefactoring = this.getModels();
        }
        Set<Model> set = this.modelsInRefactoring.keySet();
        for (Model model : set) {
            FileObject fileObject = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
            this.ids.add(BackupFacility.getDefault().backup(new FileObject[]{(FileObject)model.getModelSource().getLookup().lookup(FileObject.class)}));
            if (!model.equals(this.targetModel)) continue;
            bl = true;
        }
        GeneralChangeExecutor generalChangeExecutor = new GeneralChangeExecutor();
        if (!generalChangeExecutor.canChange(this.request.getClass(), this.target) && !bl) {
            this.ids.add(BackupFacility.getDefault().backup(new FileObject[]{(FileObject)this.targetModel.getModelSource().getLookup().lookup(FileObject.class)}));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GeneralChangeExecutor {
        private UndoableEditSupport ues = new UndoableEditSupport(this);

        public <T extends AbstractRefactoring> boolean canChange(Class<T> clazz, Referenceable referenceable) {
            return (clazz == RenameRefactoring.class || clazz == MoveRefactoring.class || clazz == SingleCopyRefactoring.class) && referenceable instanceof Model;
        }

        public void doChange(AbstractRefactoring abstractRefactoring) throws IOException {
            if (abstractRefactoring instanceof RenameRefactoring || abstractRefactoring instanceof MoveRefactoring || abstractRefactoring instanceof SingleCopyRefactoring) {
                XMLRefactoringTransaction.this.refactorFile();
                FileRenameUndoable fileRenameUndoable = new FileRenameUndoable(abstractRefactoring);
                this.fireUndoEvent(fileRenameUndoable);
            }
        }

        public synchronized void addUndoableEditListener(UndoableEditListener undoableEditListener) {
            this.ues.addUndoableEditListener(undoableEditListener);
        }

        public synchronized void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
            this.ues.removeUndoableEditListener(undoableEditListener);
        }

        protected void fireUndoEvent(UndoableEdit undoableEdit) {
            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, undoableEdit);
            for (UndoableEditListener undoableEditListener : this.ues.getUndoableEditListeners()) {
                undoableEditListener.undoableEditHappened(undoableEditEvent);
            }
        }

        class FileRenameUndoable
        extends AbstractUndoableEdit {
            private static final long serialVersionUID = -1L;
            private AbstractRefactoring request;

            public FileRenameUndoable(AbstractRefactoring abstractRefactoring) {
                this.request = abstractRefactoring;
            }

            public void undo() throws CannotUndoException {
                try {
                    XMLRefactoringTransaction.this.undoRenameFile();
                    super.undo();
                }
                catch (IOException iOException) {
                    CannotUndoException cannotUndoException = new CannotUndoException();
                    cannotUndoException.initCause(iOException);
                    throw cannotUndoException;
                }
            }

            public void redo() throws CannotRedoException {
                try {
                    XMLRefactoringTransaction.this.refactorFile();
                    super.redo();
                }
                catch (IOException iOException) {
                    CannotUndoException cannotUndoException = new CannotUndoException();
                    cannotUndoException.initCause(iOException);
                    throw cannotUndoException;
                }
            }
        }
    }
}

