/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.refactoring.spi;

import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.xml.nbprefuse.AnalysisConstants;
import prefuse.Visualization;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.util.ColorLib;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnalysisUtilities {
    public static int[] getHSBPalette(int n, float f, float f2, AnalysisConstants.HSBHues[] hSBHuesArray) {
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            float f3 = 0.0f;
            boolean bl = false;
            block1: while (!bl) {
                f3 = (float)n2++ / (float)n;
                if (hSBHuesArray != null) {
                    for (AnalysisConstants.HSBHues hSBHues : hSBHuesArray) {
                        boolean bl2 = bl = !AnalysisUtilities.isInColorFamily(f3, hSBHues);
                        if (!bl) continue block1;
                    }
                    continue;
                }
                bl = true;
            }
            nArray[i] = ColorLib.hsb((float)f3, (float)f, (float)f2);
        }
        return nArray;
    }

    private static boolean isInColorFamily(float f, AnalysisConstants.HSBHues hSBHues) {
        if (hSBHues == null) {
            return false;
        }
        return f >= hSBHues.low() && f <= hSBHues.high();
    }

    public static void expandCollapseFileNodes(List<NodeItem> list) {
        Predicate predicate = null;
        if (list == null || list.size() < 1 || list.get(0) == null) {
            return;
        }
        Visualization visualization = list.get(0).getVisualization();
        if (list.size() == 1) {
            NodeItem nodeItem = list.get(0);
            nodeItem.setBoolean("is-expanded", true);
            predicate = (Predicate)ExpressionParser.parse((String)("[file-group] = " + nodeItem.getInt("file-node-file-group")));
            visualization.setVisible("graph", predicate, true);
            AnalysisUtilities.setFileEdgeVisible(nodeItem, false);
        } else {
            for (NodeItem nodeItem : list) {
                nodeItem.setBoolean("is-expanded", false);
                predicate = (Predicate)ExpressionParser.parse((String)("[file-group] = " + nodeItem.getInt("file-node-file-group")));
                visualization.setVisible("graph", predicate, false);
                AnalysisUtilities.setFileEdgeVisible(nodeItem, true);
            }
        }
    }

    private static void setFileEdgeVisible(NodeItem nodeItem, boolean bl) {
        Iterator iterator = nodeItem.outEdges();
        while (iterator.hasNext()) {
            EdgeItem edgeItem = (EdgeItem)EdgeItem.class.cast(iterator.next());
            if (!edgeItem.getString("edge-type").equals("file-edge-type")) continue;
            edgeItem.setVisible(bl);
        }
    }

    public static String createHTMLToolTip(ToolTipLine[] toolTipLineArray) {
        if (toolTipLineArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><head></head><body>");
        for (ToolTipLine toolTipLine : toolTipLineArray) {
            if (toolTipLine == null) continue;
            stringBuffer.append("<p style='color: rgb");
            stringBuffer.append(toolTipLine.getColorAsRGBString());
            stringBuffer.append(";text-align:");
            stringBuffer.append(toolTipLine.getHorizontalAlignmentAsString());
            stringBuffer.append(";font-size:");
            stringBuffer.append(toolTipLine.getFontSizePercentageAsString());
            stringBuffer.append("%'>");
            stringBuffer.append(toolTipLine.getText());
            stringBuffer.append("</p>");
        }
        stringBuffer.append("</body></html>");
        return stringBuffer.toString();
    }

    public static class ToolTipLine {
        private String text = "";
        private int fontSizePercentage = 100;
        private int rgbColor = Color.BLACK.getRGB();
        private HorizontalAlignment hAlign = HorizontalAlignment.CENTER;

        public ToolTipLine(String string, int n, int n2, HorizontalAlignment horizontalAlignment) {
            this.text = string;
            this.fontSizePercentage = n;
            this.rgbColor = n2;
            this.hAlign = horizontalAlignment;
        }

        public ToolTipLine(String string, int n) {
            this.text = string;
            this.rgbColor = n;
        }

        public ToolTipLine(String string) {
            this.text = string;
        }

        public String getHorizontalAlignmentAsString() {
            return this.hAlign.toString();
        }

        public String getText() {
            return " " + this.text + " ";
        }

        public String getFontSizePercentageAsString() {
            return String.valueOf(this.fontSizePercentage);
        }

        public String getColorAsRGBString() {
            Color color = new Color(this.rgbColor);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            stringBuilder.append(String.valueOf(color.getRed()));
            stringBuilder.append(",");
            stringBuilder.append(String.valueOf(color.getGreen()));
            stringBuilder.append(",");
            stringBuilder.append(String.valueOf(color.getBlue()));
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum HorizontalAlignment {
            CENTER("center"),
            LEFT("left"),
            RIGHT("right");

            private final String name;

            private HorizontalAlignment(String string2) {
                this.name = string2;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

