/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.refactoring.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.refactoring.ui.MoveFilePanel;
import org.netbeans.modules.xml.refactoring.ui.views.PackageView;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class CopyPanel
extends JPanel
implements ActionListener,
DocumentListener,
CustomRefactoringPanel {
    private static final ListCellRenderer GROUP_CELL_RENDERER = new MoveFilePanel.GroupCellRenderer();
    private static final ListCellRenderer PROJECT_CELL_RENDERER = new MoveFilePanel.ProjectCellRenderer();
    private Project project;
    private ChangeListener parent;
    private FileObject fo;
    private SourceGroup[] groups;
    private String newName;
    private boolean initialized = false;
    protected JPanel bottomPanel;
    private JCheckBox isUpdateReferences;
    private JLabel labelLocation;
    private JLabel labelPackage;
    private JLabel labelProject;
    private JLabel newNameLabel;
    private JTextField newNameTextField;
    private JComboBox packageComboBox;
    private JComboBox projectsComboBox;
    private JComboBox rootComboBox;

    public CopyPanel(ChangeListener changeListener, String string, String string2, FileObject fileObject, String string3) {
        this.setName(string);
        this.fo = fileObject;
        this.parent = changeListener;
        this.newName = string3;
        this.initComponents();
        this.setCombosEnabled(true);
        this.setThisClassVisible(true);
        this.rootComboBox.setRenderer(GROUP_CELL_RENDERER);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.projectsComboBox.setRenderer(PROJECT_CELL_RENDERER);
        this.rootComboBox.addActionListener(this);
        this.packageComboBox.addActionListener(this);
        this.projectsComboBox.addActionListener(this);
        Component component = this.packageComboBox.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            ((JTextField)component).getDocument().addDocumentListener(this);
        }
        this.newNameTextField.getDocument().addDocumentListener(this);
        this.project = this.fo != null ? FileOwnerQuery.getOwner((FileObject)this.fo) : OpenProjects.getDefault().getOpenProjects()[0];
        this.initValues(string2);
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.newName = this.newName + 1;
        this.newNameTextField.setText(this.newName);
        this.newNameTextField.setSelectionStart(0);
        this.newNameTextField.setSelectionEnd(this.newNameTextField.getText().length());
        this.initialized = true;
    }

    public void initValues(String string) {
        Object object;
        Object object2;
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        List<Project> list = Arrays.asList(projectArray);
        ArrayList<Project> arrayList = new ArrayList<Project>();
        SubprojectProvider subprojectProvider = (SubprojectProvider)this.project.getLookup().lookup(SubprojectProvider.class);
        Set set = subprojectProvider.getSubprojects();
        Iterator iterator = set.iterator();
        arrayList.add(this.project);
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = (Project)object2;
            if (!list.contains(object)) continue;
            arrayList.add((Project)object);
        }
        object2 = arrayList.toArray(new Project[arrayList.size()]);
        object = new DefaultComboBoxModel((E[])object2);
        this.projectsComboBox.setModel(object);
        this.projectsComboBox.setSelectedItem(this.project);
        this.updateRoots();
        this.updatePackages();
        if (string != null) {
            this.packageComboBox.setSelectedItem(string);
        }
    }

    public void requestFocus() {
        this.newNameTextField.requestFocus();
    }

    public FileObject getRootFolder() {
        return ((SourceGroup)this.rootComboBox.getSelectedItem()).getRootFolder();
    }

    public String getPackageName() {
        String string = this.packageComboBox.getEditor().getItem().toString();
        return string.replace('.', '/');
    }

    private void fireChange() {
        this.parent.stateChanged(null);
    }

    private void initComponents() {
        this.labelProject = new JLabel();
        this.projectsComboBox = new JComboBox();
        this.labelLocation = new JLabel();
        this.rootComboBox = new JComboBox();
        this.labelPackage = new JLabel();
        this.packageComboBox = new JComboBox();
        this.bottomPanel = new JPanel();
        this.newNameLabel = new JLabel();
        this.newNameTextField = new JTextField();
        this.isUpdateReferences = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.labelProject.setLabelFor(this.projectsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelProject, (String)NbBundle.getMessage(CopyPanel.class, (String)"LBL_Project"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelProject, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.projectsComboBox, gridBagConstraints);
        this.projectsComboBox.getAccessibleContext().setAccessibleDescription(null);
        this.labelLocation.setLabelFor(this.rootComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelLocation, (String)NbBundle.getMessage(CopyPanel.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.labelLocation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.rootComboBox, gridBagConstraints);
        this.rootComboBox.getAccessibleContext().setAccessibleDescription(null);
        this.labelPackage.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.labelPackage, (String)NbBundle.getMessage(CopyPanel.class, (String)"LBL_ToPackage"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.labelPackage, gridBagConstraints);
        this.packageComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.packageComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.newNameLabel, (String)NbBundle.getMessage(CopyPanel.class, (String)"LBL_NewName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.newNameLabel, gridBagConstraints);
        this.newNameTextField.setText("NewClass");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.newNameTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.isUpdateReferences, (String)NbBundle.getMessage(CopyPanel.class, (String)"LBL_CopyWithoutRefactoring"));
        this.isUpdateReferences.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        this.isUpdateReferences.setMargin(new Insets(2, 2, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.isUpdateReferences, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.projectsComboBox == actionEvent.getSource()) {
            this.project = (Project)this.projectsComboBox.getSelectedItem();
            this.updateRoots();
            this.updatePackages();
        } else if (this.rootComboBox == actionEvent.getSource()) {
            this.updatePackages();
        } else if (this.packageComboBox == actionEvent.getSource()) {
            // empty if block
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    private void updatePackages() {
        SourceGroup sourceGroup = (SourceGroup)this.rootComboBox.getSelectedItem();
        this.packageComboBox.setModel(PackageView.createListView(sourceGroup));
    }

    void setCombosEnabled(boolean bl) {
        this.packageComboBox.setEnabled(bl);
        this.rootComboBox.setEnabled(bl);
        this.projectsComboBox.setEnabled(bl);
        this.isUpdateReferences.setVisible(!bl);
    }

    void setThisClassVisible(boolean bl) {
        this.newNameLabel.setVisible(bl);
        this.newNameTextField.setVisible(bl);
    }

    public boolean isUpdateReferences() {
        return !this.isUpdateReferences.isVisible() || !this.isUpdateReferences.isSelected();
    }

    public String getNewName() {
        return this.newNameTextField.getText();
    }

    private void updateRoots() {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        List<String> list = SharedUtils.getSourceGroups();
        for (String string : list) {
            SourceGroup[] sourceGroupArray = sources.getSourceGroups(string);
            if (sourceGroupArray == null) continue;
            for (SourceGroup sourceGroup : sourceGroupArray) {
                arrayList.add(sourceGroup);
            }
        }
        this.groups = arrayList.toArray(new SourceGroup[arrayList.size()]);
        int n = 0;
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.fo == null) continue;
            try {
                if (!this.groups[i].contains(this.fo)) continue;
                n = i;
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.rootComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.groups));
        this.rootComboBox.setSelectedIndex(n);
    }

    public Component getComponent() {
        return this;
    }
}

