/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.refactoring.ui;

import java.awt.Color;
import java.awt.Image;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.netbeans.modules.xml.refactoring.spi.AnalysisUtilities;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.dom.DocumentModel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphHelper {
    private static final ImageIcon FIND_USAGES_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/refactoring/api/resources/findusages.png"));
    public static final Schema FIND_USAGES_NODES_SCHEMA = new Schema();
    public static final Schema FIND_USAGES_EDGES_SCHEMA;
    Graph graph;
    Referenceable queryComponent;
    boolean isPrimitive;

    public GraphHelper(Referenceable referenceable) {
        this.queryComponent = referenceable;
    }

    public Graph loadGraph(ArrayList<TreeElement> arrayList) {
        TreeElement treeElement;
        RefactoringElement refactoringElement;
        this.graph = new Graph(true);
        this.graph.getNodeTable().addColumns(FIND_USAGES_NODES_SCHEMA);
        this.graph.getEdgeTable().addColumns(FIND_USAGES_EDGES_SCHEMA);
        ArrayList<Component> arrayList2 = new ArrayList<Component>();
        ArrayList<FileObject> arrayList3 = new ArrayList<FileObject>();
        Hashtable<FileObject, Node> hashtable = new Hashtable<FileObject, Node>();
        int n = 0;
        boolean bl = false;
        Node node = GraphHelper.createQueryNode(this.graph, this.queryComponent, false, arrayList2, false, n);
        for (int i = 0; i < arrayList.size() && (refactoringElement = (RefactoringElement)(treeElement = arrayList.get(i)).getUserObject()).getLookup().lookup(SimpleRefactoringElementImplementation.class) == null; ++i) {
            TreeElement treeElement2;
            Node node2;
            FileObject fileObject = refactoringElement.getParentFile();
            Node node3 = null;
            if (!arrayList3.contains(fileObject)) {
                node2 = GraphHelper.createFileNode(this.graph, this.queryComponent, fileObject, node, ++n);
                treeElement2 = this.graph.addEdge(node2, node);
                treeElement2.setString("edge-type", "file-edge-type");
                treeElement2.setInt("file-group", n);
                arrayList3.add(fileObject);
                node3 = node2;
                hashtable.put(fileObject, node2);
            } else {
                node3 = (Node)hashtable.get(fileObject);
            }
            node2 = null;
            treeElement2 = treeElement;
            while (treeElement2.getParent(true) instanceof TreeElement) {
                AnalysisUtilities.ToolTipLine toolTipLine;
                Node node4 = null;
                Object object = treeElement2.getUserObject();
                if (object instanceof FileObject) break;
                if (arrayList2.contains(object)) {
                    node4 = GraphHelper.findDup(this.graph, object);
                    assert (node4 != null) : "Cannot find node for User Object" + object;
                }
                if (node4 == null) {
                    node4 = GraphHelper.createNode(treeElement2, this.graph, arrayList2, this.queryComponent, n);
                }
                AnalysisUtilities.ToolTipLine toolTipLine2 = null;
                if (object instanceof RefactoringElement) {
                    node4.setBoolean("is-usage-node", true);
                    node4.set("refactor-element", (Object)((RefactoringElement)object));
                    toolTipLine2 = new AnalysisUtilities.ToolTipLine(MessageFormat.format(NbBundle.getMessage(GraphHelper.class, (String)"LBL_Uses_Component"), node.getString("label")), 100, Color.BLACK.getRGB(), AnalysisUtilities.ToolTipLine.HorizontalAlignment.CENTER);
                    toolTipLine = (Component)((RefactoringElement)object).getLookup().lookup(Component.class);
                    if (toolTipLine != null) {
                        GraphHelper.addApppropriateEdge(this.graph, node4, node, n, Type.REFERENCE);
                    } else {
                        GraphHelper.addApppropriateEdge(this.graph, node4, node, n, null);
                    }
                    node2 = node4;
                    treeElement2 = treeElement2.getParent(true);
                    continue;
                }
                toolTipLine = new AnalysisUtilities.ToolTipLine(GraphHelper.getCompTypeDisplayName(node4), 100, Color.BLACK.getRGB(), AnalysisUtilities.ToolTipLine.HorizontalAlignment.CENTER);
                String string = AnalysisUtilities.createHTMLToolTip(new AnalysisUtilities.ToolTipLine[]{toolTipLine2, toolTipLine});
                node4.setString("tooltip", string);
                GraphHelper.addApppropriateEdge(this.graph, node2, node4, n, null);
                node2 = node4;
                treeElement2 = treeElement2.getParent(true);
            }
            GraphHelper.addApppropriateEdge(this.graph, node2, node3, n, null);
        }
        return this.graph;
    }

    private static Node createQueryNode(Graph graph, Referenceable referenceable, boolean bl, List<Component> list, boolean bl2, int n) {
        Object object;
        Node node = null;
        Component component = null;
        if (referenceable instanceof Component) {
            component = (Component)referenceable;
        } else if (referenceable instanceof DocumentModel) {
            component = ((DocumentModel)referenceable).getRootComponent();
        }
        String string = "";
        if (referenceable instanceof Named) {
            string = ((Named)Named.class.cast(referenceable)).getName();
        } else {
            object = TreeElementFactory.getTreeElement((Object)component);
            string = object.getText(true);
        }
        node = graph.addNode();
        node.setBoolean("is-primitive", bl);
        node.setString("label", string);
        node.setString("component-type-name", "");
        node.set("user-obj", (Object)referenceable);
        node.setInt("file-group", n);
        node.setBoolean("is-query-node", true);
        node.setInt("file-group", -1);
        node.setBoolean("is-primitive", bl);
        object = new AnalysisUtilities.ToolTipLine(bl2 ? NbBundle.getMessage(GraphHelper.class, (String)"LBL_Base_Complex_Type") : NbBundle.getMessage(GraphHelper.class, (String)"LBL_Query_Component"), 100, Color.BLACK.getRGB(), AnalysisUtilities.ToolTipLine.HorizontalAlignment.CENTER);
        String string2 = GraphHelper.getCompTypeDisplayName(node);
        AnalysisUtilities.ToolTipLine toolTipLine = new AnalysisUtilities.ToolTipLine(string2, 100, Color.BLACK.getRGB(), AnalysisUtilities.ToolTipLine.HorizontalAlignment.CENTER);
        String string3 = AnalysisUtilities.createHTMLToolTip(new AnalysisUtilities.ToolTipLine[]{object, toolTipLine});
        node.setString("tooltip", string3);
        return node;
    }

    private static Node createNode(TreeElement treeElement, Graph graph, List list, Referenceable referenceable, int n) {
        Node node = graph.addNode();
        if (list != null) {
            list.add(treeElement.getUserObject());
        }
        node.setBoolean("is-primitive", false);
        node.setString("label", treeElement.getText(true));
        node.set("user-obj", treeElement.getUserObject());
        node.setInt("file-group", n);
        if (treeElement.getIcon() != null) {
            node.set("java-awt-image", (Object)((ImageIcon)treeElement.getIcon()).getImage());
        }
        return node;
    }

    private static String getCompTypeDisplayName(Node node) {
        String string = null;
        string = node.canGetBoolean("is-primitive") && node.getBoolean("is-primitive") ? NbBundle.getMessage(GraphHelper.class, (String)"LBL_Primitive_Type") : node.getString("component-type-name");
        return string;
    }

    private static void addApppropriateEdge(Graph graph, Node node, Node node2, int n, Type type) {
        Edge edge = graph.addEdge(node, node2);
        edge.setInt("file-group", Integer.valueOf(n).intValue());
        if (type == Type.GENERALIZATION) {
            edge.setString("edge-type", "generalization");
        } else if (type == Type.REFERENCE) {
            edge.setString("edge-type", "reference");
            node.setString("label", MessageFormat.format(NbBundle.getMessage(GraphHelper.class, (String)"LBL_References_Ref"), node2.getString("label")));
        } else {
            edge.setString("edge-type", "composition");
        }
    }

    private static Node createFileNode(Graph graph, Referenceable referenceable, FileObject fileObject, Node node, int n) {
        if (referenceable == null || fileObject == null) {
            return null;
        }
        String string = SharedUtils.getXmlFileType(fileObject);
        Node node2 = graph.addNode();
        node2.setString("file-type    ", string);
        node2.setInt("file-node-file-group", n);
        node2.setBoolean("is-expanded", false);
        node2.setBoolean("is-file-node", true);
        node2.set("java-awt-image", (Object)SharedUtils.getImage(fileObject));
        if (fileObject != null) {
            node2.setString("label", fileObject.getName() + "." + fileObject.getExt());
            node2.setString("xml-filename", fileObject.getName() + "." + fileObject.getExt());
            node2.set("file-object", (Object)fileObject);
            AnalysisUtilities.ToolTipLine toolTipLine = new AnalysisUtilities.ToolTipLine(MessageFormat.format(NbBundle.getMessage(GraphHelper.class, (String)"LBL_Xml_File_With_Usages"), SharedUtils.getXmlFileTypeDisplayName(string), node.getString("label")), 100, Color.BLACK.getRGB(), AnalysisUtilities.ToolTipLine.HorizontalAlignment.CENTER);
            AnalysisUtilities.ToolTipLine toolTipLine2 = new AnalysisUtilities.ToolTipLine(FileUtil.getFileDisplayName((FileObject)fileObject), 100, Color.BLACK.getRGB(), AnalysisUtilities.ToolTipLine.HorizontalAlignment.CENTER);
            String string2 = AnalysisUtilities.createHTMLToolTip(new AnalysisUtilities.ToolTipLine[]{toolTipLine, toolTipLine2});
            node2.setString("tooltip", string2);
        }
        return node2;
    }

    private static Node findDup(Graph graph, Object object) {
        Iterator iterator = graph.nodes();
        while (iterator.hasNext()) {
            Node node = (Node)Node.class.cast(iterator.next());
            Object object2 = node.get("user-obj");
            if (!node.canGetBoolean("is-file-node") || node.getBoolean("is-file-node") || object2 == null || object2 != object) continue;
            return node;
        }
        return null;
    }

    static {
        FIND_USAGES_NODES_SCHEMA.addColumn("label", String.class, (Object)"");
        FIND_USAGES_NODES_SCHEMA.addColumn("id", String.class, (Object)"");
        FIND_USAGES_NODES_SCHEMA.addColumn("component-type-name", String.class, (Object)"");
        FIND_USAGES_NODES_SCHEMA.addColumn("element-type", String.class, (Object)"");
        FIND_USAGES_NODES_SCHEMA.addColumn("xml-filename", String.class, (Object)"");
        FIND_USAGES_NODES_SCHEMA.addColumn("file-object", FileObject.class);
        FIND_USAGES_NODES_SCHEMA.addColumn("file-type    ", String.class, (Object)"");
        FIND_USAGES_NODES_SCHEMA.addColumn("tooltip", String.class, (Object)"");
        FIND_USAGES_NODES_SCHEMA.addColumn("user-obj", Object.class);
        FIND_USAGES_NODES_SCHEMA.addColumn("java-awt-image", Image.class);
        FIND_USAGES_NODES_SCHEMA.addColumn("refactor-element", RefactoringElement.class);
        FIND_USAGES_NODES_SCHEMA.addColumn("file-group", Integer.TYPE, (Object)-1);
        FIND_USAGES_NODES_SCHEMA.addColumn("file-node-file-group", Integer.TYPE, (Object)-1);
        FIND_USAGES_NODES_SCHEMA.addColumn("is-primitive", Boolean.TYPE, (Object)false);
        FIND_USAGES_NODES_SCHEMA.addColumn("is-query-node", Boolean.TYPE, (Object)false);
        FIND_USAGES_NODES_SCHEMA.addColumn("is-usage-node", Boolean.TYPE, (Object)false);
        FIND_USAGES_NODES_SCHEMA.addColumn("is-file-node", Boolean.TYPE, (Object)false);
        FIND_USAGES_NODES_SCHEMA.addColumn("is-expanded", Boolean.TYPE, (Object)false);
        FIND_USAGES_NODES_SCHEMA.addColumn("mouseover", Boolean.TYPE, (Object)false);
        FIND_USAGES_EDGES_SCHEMA = new Schema();
        FIND_USAGES_EDGES_SCHEMA.addColumn("label", String.class, (Object)"");
        FIND_USAGES_EDGES_SCHEMA.addColumn("edge-type", String.class, (Object)"");
        FIND_USAGES_EDGES_SCHEMA.addColumn("tooltip", String.class, (Object)"");
        FIND_USAGES_EDGES_SCHEMA.addColumn("file-group", Integer.TYPE, (Object)-1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        REFERENCE,
        GENERALIZATION;

    }
}

