/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsf.framework;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;

public class JSFUtils {
    private static final String LIB_JSF_NAME = "JSF";
    private static final String LIBS_FOLDER = "org-netbeans-api-project-libraries/Libraries";
    private static final String JSF_API_JAR = "jsf-api.jar";
    private static final String JSF_IMPL_JAR = "jsf-impl.jar";
    private static final String DIGESTER_JAR = "commons-digester.jar";
    private static final String LOGGING_JAR = "commons-logging.jar";
    private static final String COLLECTIONS_JAR = "commons-collections.jar";
    private static final String BEANUTILS_JAR = "commons-beanutils.jar";
    public static final String FACES_EXCEPTION = "javax.faces.FacesException";
    public static final String JSF_1_2__API_SPECIFIC_CLASS = "javax.faces.application.StateManagerWrapper";
    public static final String MYFACES_SPAECIFIC_CLASS = "org.apache.myfaces.webapp.StartupServletContextListener";

    public static boolean isJSFInstallFolder(File file) {
        File file2;
        boolean bl = false;
        if (file.exists() && file.isDirectory() && (file2 = new File(file, JSF_IMPL_JAR)).exists()) {
            bl = true;
        }
        return bl;
    }

    public static boolean createJSFUserLibrary(File file, String string) throws IOException {
        assert (file != null);
        File file2 = new File(file.getPath());
        if (!file2.exists() || !file2.isDirectory()) {
            return false;
        }
        final File file3 = new File(file2, JSF_API_JAR);
        final File file4 = new File(file2, JSF_IMPL_JAR);
        final File file5 = new File(file2, DIGESTER_JAR);
        final File file6 = new File(file2, LOGGING_JAR);
        final File file7 = new File(file2, COLLECTIONS_JAR);
        final File file8 = new File(file2, BEANUTILS_JAR);
        if (!(file3.exists() && file4.exists() && file5.exists() && file6.exists() && file7.exists() && file8.exists())) {
            return false;
        }
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        final FileObject fileObject = fileSystem.findResource(LIBS_FOLDER);
        final String string2 = JSFUtils.convertLibraryVersion(string);
        assert (fileObject != null && fileObject.isFolder());
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                String string = "JSF-" + string2;
                FileObject fileObject2 = fileObject.getFileObject(string + ".xml");
                if (fileObject2 == null) {
                    fileObject2 = fileObject.createData(string + ".xml");
                }
                FileLock fileLock = fileObject2.lock();
                try {
                    PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(fileObject2.getOutputStream(fileLock)));
                    try {
                        String[] stringArray = new String[]{FileUtil.getArchiveRoot((URL)file3.toURI().toURL()).toString(), FileUtil.getArchiveRoot((URL)file4.toURI().toURL()).toString(), FileUtil.getArchiveRoot((URL)file5.toURI().toURL()).toString(), FileUtil.getArchiveRoot((URL)file6.toURI().toURL()).toString(), FileUtil.getArchiveRoot((URL)file7.toURI().toURL()).toString(), FileUtil.getArchiveRoot((URL)file8.toURI().toURL()).toString()};
                        JSFUtils.createLibraryFile(printWriter, string, stringArray);
                    }
                    finally {
                        printWriter.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        });
        return true;
    }

    public static Library getJSFLibrary(String string) {
        String string2 = JSFUtils.convertLibraryVersion(string);
        return LibraryManager.getDefault().getLibrary("JSF-" + string2);
    }

    public static String convertLibraryVersion(String string) {
        String string2 = string;
        string2 = string2.replace('.', '-');
        string2 = string2.replace(' ', '_');
        return string2;
    }

    private static void createLibraryFile(PrintWriter printWriter, String string, String[] stringArray) {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println("<!DOCTYPE library PUBLIC \"-//NetBeans//DTD Library Declaration 1.0//EN\" \"http://www.netbeans.org/dtds/library-declaration-1_0.dtd\">");
        printWriter.println("<library version=\"1.0\">");
        printWriter.println("\t<name>" + string + "</name>");
        printWriter.println("\t<type>j2se</type>");
        printWriter.println("\t<volume>");
        printWriter.println("\t\t<type>classpath</type>");
        for (int i = 0; i < stringArray.length; ++i) {
            printWriter.println("\t\t<resource>" + stringArray[i] + "</resource>");
        }
        printWriter.println("\t</volume>");
        printWriter.println("\t<volume>");
        printWriter.println("\t\t<type>src</type>");
        printWriter.println("\t</volume>");
        printWriter.println("\t<volume>");
        printWriter.println("\t\t<type>javadoc</type>");
        printWriter.println("\t</volume>");
        printWriter.println("</library>");
    }
}

