/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsf.services;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.visualweb.api.j2ee.common.RequestedJdbcResource;
import org.netbeans.modules.visualweb.project.jsf.services.DesignTimeDataSourceService;
import org.openide.ErrorManager;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesignTimeDataSourceServiceImpl
implements DesignTimeDataSourceService {
    private static final String DATASOURCE_PREFIX = "java:comp/env/";
    private static final String NON_DEFAULT_DATASOURCE_PREFIX = "java:/";

    @Override
    public boolean updateProjectDataSource(Project project, RequestedJdbcResource requestedJdbcResource) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        HashSet hashSet = null;
        try {
            hashSet = j2eeModuleProvider.getModuleDatasources();
        }
        catch (ConfigurationException configurationException) {
            hashSet = new HashSet();
        }
        boolean bl = true;
        for (Datasource datasource : hashSet) {
            if (!requestedJdbcResource.getResourceName().equals(datasource.getJndiName()) || !requestedJdbcResource.getDriverClassName().equals(datasource.getDriverClassName()) || (requestedJdbcResource.getUrl() == null || !requestedJdbcResource.getUrl().equals(datasource.getUrl())) && (requestedJdbcResource.getUrl() != null || datasource.getUrl() != null) || (requestedJdbcResource.getUsername() == null || !requestedJdbcResource.getUsername().equals(datasource.getUsername())) && (requestedJdbcResource.getUsername() != null || datasource.getUsername() != null) || (requestedJdbcResource.getPassword() == null || !requestedJdbcResource.getPassword().equals(datasource.getPassword())) && (requestedJdbcResource.getPassword() != null || datasource.getPassword() != null)) continue;
            bl = false;
        }
        if (bl) {
            try {
                j2eeModuleProvider.getConfigSupport().createDatasource(requestedJdbcResource.getResourceName(), requestedJdbcResource.getUrl(), requestedJdbcResource.getUsername(), requestedJdbcResource.getPassword(), requestedJdbcResource.getDriverClassName());
            }
            catch (ConfigurationException configurationException) {
            }
            catch (DatasourceAlreadyExistsException datasourceAlreadyExistsException) {
                List list = datasourceAlreadyExistsException.getDatasources();
                if (list.size() != 1) {
                    ErrorManager.getDefault().log(16, "DS - " + requestedJdbcResource.getResourceName() + ": Here should only one DS exist!");
                    ErrorManager.getDefault().notify(1, (Throwable)datasourceAlreadyExistsException);
                    return false;
                }
                Datasource datasource = (Datasource)list.get(0);
                if (datasource.getJndiName().equals(requestedJdbcResource.getResourceName()) && datasource.getDriverClassName().equals(requestedJdbcResource.getDriverClassName()) && (datasource.getUrl() != null && datasource.getUrl().equals(requestedJdbcResource.getUrl()) || datasource.getUrl() == null && requestedJdbcResource.getUrl() == null) && (datasource.getUsername() != null && datasource.getUsername().equals(requestedJdbcResource.getUsername()) || datasource.getUsername() == null && requestedJdbcResource.getUsername() == null) && (datasource.getPassword() != null && datasource.getPassword().equals(requestedJdbcResource.getPassword()) || datasource.getPassword() == null && requestedJdbcResource.getPassword() == null)) {
                    ErrorManager.getDefault().log(1, "DS - " + requestedJdbcResource.getResourceName() + ": OK, we have the same DS on the server already. I hope there is nothing else to configure for this project.");
                }
                ErrorManager.getDefault().log(16, "DS - " + requestedJdbcResource.getResourceName() + ": There is a DS on the server with the same JNDI name but different parameters!  Trouble ahead!!");
                ErrorManager.getDefault().notify(16, (Throwable)datasourceAlreadyExistsException);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean updateResourceReference(Project project, RequestedJdbcResource requestedJdbcResource) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        HashSet hashSet = null;
        try {
            hashSet = j2eeModuleProvider.getModuleDatasources();
        }
        catch (ConfigurationException configurationException) {
            hashSet = new HashSet();
        }
        for (Datasource datasource : hashSet) {
            try {
                if (!requestedJdbcResource.getUrl().equals(datasource.getUrl()) || !requestedJdbcResource.getUsername().equals(datasource.getUsername())) continue;
                j2eeModuleProvider.getConfigSupport().bindDatasourceReference(requestedJdbcResource.getResourceName(), datasource.getJndiName());
            }
            catch (ConfigurationException configurationException) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<RequestedJdbcResource> getServerDataSources(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        HashSet hashSet = null;
        try {
            hashSet = j2eeModuleProvider.getServerDatasources();
        }
        catch (ConfigurationException configurationException) {
            hashSet = new HashSet();
        }
        HashSet<RequestedJdbcResource> hashSet2 = new HashSet<RequestedJdbcResource>();
        for (Datasource datasource : hashSet) {
            RequestedJdbcResource requestedJdbcResource = new RequestedJdbcResource(this.stripDATASOURCE_PREFIX(datasource.getJndiName()), datasource.getDriverClassName(), datasource.getUrl(), datasource.getUsername(), datasource.getPassword());
            hashSet2.add(requestedJdbcResource);
        }
        return hashSet2;
    }

    @Override
    public Set<RequestedJdbcResource> getProjectDataSources(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        HashSet hashSet = null;
        try {
            hashSet = j2eeModuleProvider.getModuleDatasources();
        }
        catch (ConfigurationException configurationException) {
            hashSet = new HashSet();
        }
        HashSet<RequestedJdbcResource> hashSet2 = new HashSet<RequestedJdbcResource>();
        for (Datasource datasource : hashSet) {
            RequestedJdbcResource requestedJdbcResource = new RequestedJdbcResource(this.stripDATASOURCE_PREFIX(datasource.getJndiName()), datasource.getDriverClassName(), datasource.getUrl(), datasource.getUsername(), datasource.getPassword());
            hashSet2.add(requestedJdbcResource);
        }
        return hashSet2;
    }

    private String stripDATASOURCE_PREFIX(String string) {
        if (string == null) {
            return string;
        }
        if (string.startsWith(NON_DEFAULT_DATASOURCE_PREFIX)) {
            return string.substring(NON_DEFAULT_DATASOURCE_PREFIX.length());
        }
        if (!string.startsWith(DATASOURCE_PREFIX)) {
            return string;
        }
        if (string.equals(DATASOURCE_PREFIX)) {
            return string;
        }
        return string.substring(DATASOURCE_PREFIX.length());
    }

    @Override
    public Set<RequestedJdbcResource> getBrokenDatasources(Project project) {
        Object object22;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        HashSet hashSet = null;
        try {
            hashSet = j2eeModuleProvider.getModuleDatasources();
        }
        catch (ConfigurationException configurationException) {
            hashSet = new HashSet();
        }
        HashSet<Object> hashSet2 = new HashSet<Object>();
        for (Object object22 : hashSet) {
            if (this.isFound((Datasource)object22)) continue;
            hashSet2.add(object22);
        }
        object22 = new HashSet();
        for (Datasource datasource : hashSet2) {
            RequestedJdbcResource requestedJdbcResource = new RequestedJdbcResource(datasource.getJndiName(), datasource.getDriverClassName(), datasource.getUrl(), datasource.getUsername(), datasource.getPassword());
            object22.add(requestedJdbcResource);
        }
        return object22;
    }

    private boolean isFound(Datasource datasource) {
        boolean bl = false;
        String string = datasource.getUrl();
        String string2 = datasource.getUsername();
        DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < databaseConnectionArray.length; ++i) {
            DatabaseConnection databaseConnection = databaseConnectionArray[i];
            String string3 = databaseConnection.getDatabaseURL();
            String string4 = databaseConnection.getUser();
            if (!this.matchURL(string, string3, true) || !Utilities.compareObjects((Object)string2, (Object)string4)) continue;
            bl = true;
        }
        return bl;
    }

    private boolean matchURL(String string, String string2, boolean bl) {
        String string3;
        if (bl) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        if (string.equals(string2)) {
            return true;
        }
        if (string.contains("derby") && (string3 = string.substring(0, string.lastIndexOf(":")) + string.substring(string.lastIndexOf("/"))).equals(string2)) {
            return true;
        }
        int n = 0;
        if (string != null && string2 != null) {
            char[] cArray;
            char[] cArray2 = string.toCharArray();
            int n2 = cArray2.length;
            if (n2 > (cArray = string2.toCharArray()).length) {
                n2 = cArray.length;
            }
            for (int i = 0; i < n2 - 1; ++i) {
                if (cArray2[i] != cArray[i] && cArray2[i] == ':') {
                    n = 1;
                    continue;
                }
                if (cArray2[i + n] == cArray[i]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isDatasourceCreationSupported(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        return j2eeModuleProvider.getConfigSupport().isDatasourceCreationSupported();
    }
}

