/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsf.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.visualweb.project.jsf.ui.PageLayoutChooserPanel;
import org.netbeans.modules.visualweb.project.jsf.ui.PageLayoutData;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PageLayoutChooserPanelGUI
extends JPanel
implements HelpCtx.Provider {
    private PageLayoutChooserPanel wizardPanel;
    GridBagConstraints gridBagConstraints;
    private JTextArea descriptionArea;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel previewIcon;
    private JPanel previewPanel;
    private JList templatesList;
    private JPanel templatesListPanel;

    public PageLayoutChooserPanelGUI(PageLayoutChooserPanel pageLayoutChooserPanel) {
        this.initComponents();
        this.wizardPanel = pageLayoutChooserPanel;
        this.templatesList.getSelectionModel().setSelectionMode(0);
        this.templatesList.setListData(this.wizardPanel.getPageLayoutList());
        this.templatesList.setCellRenderer(new CustomCellRenderer());
        this.wizardPanel.setSelectedPageLayout(this.wizardPanel.getPageLayoutList().get(0));
        this.templatesList.setSelectedIndex(0);
        this.descriptionArea.setBackground(this.previewPanel.getBackground());
    }

    public String getName() {
        return NbBundle.getMessage(PageLayoutChooserPanelGUI.class, (String)"LBL_PageLayoutsPanel_Name");
    }

    private void initComponents() {
        this.templatesListPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.templatesList = new JList();
        this.previewPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.previewIcon = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.descriptionArea = new JTextArea();
        this.templatesList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.templatesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PageLayoutChooserPanelGUI.this.templatesListValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.templatesList);
        GroupLayout groupLayout = new GroupLayout((Container)this.templatesListPanel);
        this.templatesListPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 211, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 303, Short.MAX_VALUE).addContainerGap()));
        this.jScrollPane2.setBorder(null);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(PageLayoutChooserPanelGUI.class, (String)"PREVIEW_TITLE")));
        this.jPanel1.setLayout(new GridBagLayout());
        this.previewIcon.setText(NbBundle.getMessage(PageLayoutChooserPanelGUI.class, (String)"NO_PREVIEW_TEXT"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.previewIcon, gridBagConstraints);
        this.jScrollPane2.setViewportView(this.jPanel1);
        this.jScrollPane3.setBorder(null);
        this.descriptionArea.setColumns(15);
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setRows(5);
        this.descriptionArea.setText(NbBundle.getMessage(PageLayoutChooserPanelGUI.class, (String)"NO_DESCRIPTION_TEXT"));
        this.descriptionArea.setBorder(null);
        this.jScrollPane3.setViewportView(this.descriptionArea);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.previewPanel);
        this.previewPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (Component)this.jScrollPane2, -1, 216, Short.MAX_VALUE).add(2, (Component)this.jScrollPane3, 0, 0, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane2, -1, 205, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.jScrollPane3, -2, -1, -2).addContainerGap()));
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.templatesListPanel, -1, -1, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.previewPanel, -2, -1, -2)));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.templatesListPanel, 0, -1, Short.MAX_VALUE).add((Component)this.previewPanel, -1, -1, Short.MAX_VALUE));
    }

    private void templatesListValueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            JList jList = (JList)listSelectionEvent.getSource();
            PageLayoutData pageLayoutData = (PageLayoutData)jList.getSelectedValue();
            this.wizardPanel.setSelectedPageLayout(pageLayoutData);
            if (pageLayoutData.getPreviewImage() != null) {
                this.previewIcon.setIcon(new ImageIcon(pageLayoutData.getPreviewImage()));
                this.previewIcon.setText("");
            } else {
                this.previewIcon.setIcon(null);
                this.previewIcon.setText(NbBundle.getMessage(PageLayoutChooserPanelGUI.class, (String)"NO_PREVIEW_TEXT"));
            }
            this.descriptionArea.setText(pageLayoutData.getDescription());
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(PageLayoutChooserPanelGUI.class);
    }

    class CustomCellRenderer
    extends JLabel
    implements ListCellRenderer {
        CustomCellRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 5));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            PageLayoutData pageLayoutData = (PageLayoutData)object;
            this.setText(pageLayoutData.getName());
            if (pageLayoutData.getIcon() != null) {
                this.setIcon(new ImageIcon(pageLayoutData.getIcon()));
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

