/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ContextAware;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.ProfilingEventListener;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.GlobalProfilingSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.common.filters.DefinedFilterSets;
import org.netbeans.lib.profiler.common.filters.GlobalFilters;
import org.netbeans.lib.profiler.global.CalibrationDataFileIO;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.instrumentation.BadLocationException;
import org.netbeans.lib.profiler.instrumentation.InstrumentationException;
import org.netbeans.lib.profiler.results.CCTProvider;
import org.netbeans.lib.profiler.results.ProfilingResultsDispatcher;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.lib.profiler.results.cpu.marking.MarkingEngine;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryProfilingResultsListener;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModule;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModuleContainer;
import org.netbeans.lib.profiler.ui.monitor.MemoryXYChartModel;
import org.netbeans.lib.profiler.ui.monitor.SurvivingGenerationsXYChartModel;
import org.netbeans.lib.profiler.ui.monitor.ThreadsXYChartModel;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryXYChartModel;
import org.netbeans.lib.profiler.wireprotocol.Response;
import org.netbeans.lib.profiler.wireprotocol.WireIO;
import org.netbeans.modules.profiler.GestureSubmitter;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.ProfilerIDESettings;
import org.netbeans.modules.profiler.ProfilerModule;
import org.netbeans.modules.profiler.ProfilingMonitor;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.TelemetryOverviewPanel;
import org.netbeans.modules.profiler.ThreadsWindow;
import org.netbeans.modules.profiler.actions.RerunAction;
import org.netbeans.modules.profiler.categories.Categorization;
import org.netbeans.modules.profiler.heapwalk.HeapDumpWatch;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.ui.ProfilingPointsWindow;
import org.netbeans.modules.profiler.spi.LoadGenPlugin;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stats.ProjectAwareStatisticalModule;
import org.netbeans.modules.profiler.utils.GoToSourceHelper;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.netbeans.modules.profiler.utils.OutputParameter;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;

public final class NetBeansProfiler
extends Profiler {
    private static final Logger LOGGER = Logger.getLogger(NetBeansProfiler.class.getName());
    private static final String CALIBRATION_FAILED_MESSAGE;
    private static final String CALIBRATION_MISSING_MESSAGE;
    private static final String CALIBRATION_MISSING_SHORT_MESSAGE;
    private static final String PROGRESS_DIALOG_CAPTION;
    private static final String ENTIRE_APPLICATION_PROFILING_WARNING;
    private static final String DIRECTORY_DOES_NOT_EXIST_MESSAGE;
    private static final String DIRECTORY_IS_WRITE_PROTECTED_MESSAGE;
    private static final String ERROR_LOADING_PROFILING_SETTINGS_MESSAGE;
    private static final String ERROR_SAVING_PROFILING_SETTINGS_MESSAGE;
    private static final String ERROR_SAVING_FILTER_SETS_MESSAGE;
    private static final String ERROR_SAVING_ATTACH_SETTINGS_MESSAGE;
    private static final String CANNOT_FIND_LIBS_MSG;
    private static final String ENGINE_INIT_FAILED_MSG;
    private static final String INITIAL_CALIBRATION_MSG;
    private static final String TERMINATE_VM_ON_EXIT_MSG;
    private static final String TAKE_SNAPSHOT_ON_EXIT_MSG;
    private static final String TAKE_SNAPSHOT_ON_EXIT_DIALOG_TITLE;
    private static final String TARGET_APP_NOT_RESPONDING_MSG;
    private static final String TARGET_APP_NOT_RESPONDING_DIALOG_TITLE;
    private static final String MODIFYING_INSTRUMENTATION_MSG;
    static final ErrorManager profilerErrorManager;
    private static final String GLOBAL_FILTERS_FILENAME = "filters";
    private static final String DEFINED_FILTERSETS_FILENAME = "filtersets";
    private static final String DEFAULT_FILE_SUFFIX = "-default";
    private static final String ATTACH_SETTINGS_FILENAME = "attach";
    private static boolean initialized;
    AppStatusHandler.AsyncDialog waitDialog = null;
    boolean shouldDisplayDialog = true;
    private final ProfilerIDESettings ideSettings = ProfilerIDESettings.getInstance();
    private final ProfilingMonitor monitor = new ProfilingMonitor();
    private final TargetAppRunner targetAppRunner;
    private DefinedFilterSets definedFilterSets;
    private FileObject profiledSingleFile;
    private FileObject rerunScript;
    private GlobalFilters globalFilters;
    private final Object setupLock = new Object();
    private ProfilingSettings lastProfilingSettings;
    private Project profiledProject = null;
    private Properties rerunProps;
    private SessionSettings lastSessionSettings;
    private String rerunTarget;
    private StringBuilder logMsgs = new StringBuilder();
    private ThreadsDataManager threadsManager;
    private VMTelemetryDataManager vmTelemetryManager;
    private VMTelemetryXYChartModel memoryXYChartModel;
    private VMTelemetryXYChartModel survivingGenerationsXYChartModel;
    private VMTelemetryXYChartModel threadsXYChartModel;
    private boolean calibrating = false;
    private boolean processesProfilingPoints;
    private boolean silent;
    private boolean threadsMonitoringEnabled = false;
    private boolean waitDialogOpen = false;
    private int lastMode = 1;
    private int profilingMode = 1;
    private int profilingState = 1;

    public NetBeansProfiler() {
        boolean bl = false;
        ProfilerEngineSettings profilerEngineSettings = new ProfilerEngineSettings();
        try {
            String string = IDEUtils.getLibsDir();
            if (string == null) {
                throw new IOException(CANNOT_FIND_LIBS_MSG);
            }
            profilerEngineSettings.initialize(string);
            profilerEngineSettings.setSeparateConsole(System.getProperty("org.netbeans.profiler.separateConsole") != null);
            profilerEngineSettings.setTargetWindowRemains(System.getProperty("org.netbeans.profiler.targetWindowRemains") != null);
        }
        catch (RuntimeException runtimeException) {
            ProfilerLogger.log((Exception)runtimeException);
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)runtimeException.getMessage(), 0));
            bl = true;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().annotate((Throwable)iOException, MessageFormat.format(ENGINE_INIT_FAILED_MSG, iOException.getLocalizedMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            bl = true;
        }
        this.targetAppRunner = new TargetAppRunner(profilerEngineSettings, (AppStatusHandler)new IDEAppStatusHandler(), (ProfilingPointsProcessor)ProfilingPointsManager.getDefault());
        this.targetAppRunner.addProfilingEventListener(new ProfilingEventListener(){

            public void targetAppStarted() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.changeStateTo(4);
            }

            public void targetAppStopped() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.changeStateTo(16);
            }

            public void targetAppSuspended() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.changeStateTo(8);
            }

            public void targetAppResumed() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.changeStateTo(4);
            }

            public void attachedToTarget() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.changeStateTo(4);
            }

            public void detachedFromTarget() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.monitor.stopDisplayingVM();
                NetBeansProfiler.this.changeStateTo(1);
            }

            public void targetVMTerminated() {
                if (NetBeansProfiler.this.calibrating) {
                    return;
                }
                NetBeansProfiler.this.monitor.stopDisplayingVM();
                NetBeansProfiler.this.changeStateTo(1);
            }
        });
        if (!bl) {
            initialized = true;
        }
    }

    public static NetBeansProfiler getDefaultNB() {
        return (NetBeansProfiler)NetBeansProfiler.getDefault();
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public int getAgentState(String string, int n, int n2) {
        if (this.profilingState == 4 && n == this.targetAppRunner.getProfilerEngineSettings().getPortNo()) {
            if (this.targetAppRunner.getProfilerClient().getCurrentAgentId() == n2) {
                return 3;
            }
            return 4;
        }
        Properties properties = this.getAgentProperties(n);
        if (properties == null) {
            return 0;
        }
        try {
            int n3 = Integer.parseInt(properties.getProperty("agent.id"));
            if (n3 == n2) {
                String string2 = properties.getProperty("dynamic");
                if (string2 == null || "false".equals(string2)) {
                    return 2;
                }
                return 1;
            }
            return 4;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public Properties getCurrentProfilingProperties() {
        return this.rerunProps;
    }

    public SessionSettings getCurrentSessionSettings() {
        return this.lastSessionSettings;
    }

    public synchronized DefinedFilterSets getDefinedFilterSets() {
        if (this.definedFilterSets == null) {
            this.loadGlobalFilters();
        }
        return this.definedFilterSets;
    }

    public synchronized GlobalFilters getGlobalFilters() {
        if (this.globalFilters == null) {
            this.loadGlobalFilters();
        }
        return this.globalFilters;
    }

    public GlobalProfilingSettings getGlobalProfilingSettings() {
        return this.ideSettings;
    }

    public ProfilingSettings getLastProfilingSettings() {
        return this.lastProfilingSettings;
    }

    public String getLibsDir() {
        return IDEUtils.getLibsDir();
    }

    public VMTelemetryXYChartModel getMemoryXYChartModel() {
        if (this.memoryXYChartModel == null) {
            this.memoryXYChartModel = new MemoryXYChartModel(this.getVMTelemetryManager());
        }
        return this.memoryXYChartModel;
    }

    public int getPlatformArchitecture(String string) {
        JavaPlatform javaPlatform = IDEUtils.getJavaPlatformByName(string);
        if (javaPlatform == null) {
            return 32;
        }
        return IDEUtils.getPlatformArchitecture(javaPlatform);
    }

    public String getPlatformJDKVersion(String string) {
        JavaPlatform javaPlatform = IDEUtils.getJavaPlatformByName(string);
        if (javaPlatform == null) {
            return null;
        }
        return IDEUtils.getPlatformJDKVersion(javaPlatform);
    }

    public String getPlatformJavaFile(String string) {
        JavaPlatform javaPlatform = IDEUtils.getJavaPlatformByName(string);
        if (javaPlatform == null) {
            return null;
        }
        return IDEUtils.getPlatformJavaFile(javaPlatform);
    }

    public int getProfilingMode() {
        return this.profilingMode;
    }

    public int getProfilingState() {
        return this.profilingState;
    }

    public VMTelemetryXYChartModel getSurvivingGenerationsXYChartModel() {
        if (this.survivingGenerationsXYChartModel == null) {
            this.survivingGenerationsXYChartModel = new SurvivingGenerationsXYChartModel(this.getVMTelemetryManager());
        }
        return this.survivingGenerationsXYChartModel;
    }

    public TargetAppRunner getTargetAppRunner() {
        return this.targetAppRunner;
    }

    public ThreadsDataManager getThreadsManager() {
        if (this.threadsManager == null) {
            this.threadsManager = new ThreadsDataManager();
        }
        return this.threadsManager;
    }

    public void setThreadsMonitoringEnabled(boolean bl) {
        this.getThreadsManager().setThreadsMonitoringEnabled(bl);
        if (this.threadsMonitoringEnabled == bl) {
            return;
        }
        this.threadsMonitoringEnabled = bl;
        this.fireThreadsMonitoringChange();
    }

    public boolean getThreadsMonitoringEnabled() {
        return this.threadsMonitoringEnabled;
    }

    public VMTelemetryXYChartModel getThreadsXYChartModel() {
        if (this.threadsXYChartModel == null) {
            this.threadsXYChartModel = new ThreadsXYChartModel(this.getVMTelemetryManager());
        }
        return this.threadsXYChartModel;
    }

    public VMTelemetryDataManager getVMTelemetryManager() {
        if (this.vmTelemetryManager == null) {
            this.vmTelemetryManager = new VMTelemetryDataManager();
        }
        return this.vmTelemetryManager;
    }

    public boolean attachToApp(final ProfilingSettings profilingSettings, final AttachSettings attachSettings) {
        this.profilingMode = 0;
        final OutputParameter<Boolean> outputParameter = new OutputParameter<Boolean>(Boolean.TRUE);
        new NBSwingWorker(false){
            private ProgressHandle ph;
            {
                super(bl);
                this.ph = null;
            }

            protected void doInBackground() {
                if (NetBeansProfiler.this.getProfilingState() != 1) {
                    if (NetBeansProfiler.this.lastMode == 0) {
                        NetBeansProfiler.this.detachFromApp();
                    } else if (NetBeansProfiler.this.targetAppRunner.targetJVMIsAlive()) {
                        NetBeansProfiler.this.targetAppRunner.terminateTargetJVM();
                    }
                }
                NetBeansProfiler.this.lastProfilingSettings = profilingSettings;
                NetBeansProfiler.this.lastSessionSettings = null;
                NetBeansProfiler.this.lastMode = 0;
                NetBeansProfiler.this.rerunTarget = null;
                NetBeansProfiler.this.rerunProps = null;
                NetBeansProfiler.this.rerunScript = null;
                IDEUtils.runInEventDispatchThread(new Runnable(){

                    public void run() {
                        ((RerunAction)CallableSystemAction.get(RerunAction.class)).updateAction();
                    }
                });
                ProfilerEngineSettings profilerEngineSettings = NetBeansProfiler.this.targetAppRunner.getProfilerEngineSettings();
                profilingSettings.applySettings(profilerEngineSettings);
                attachSettings.applySettings(profilerEngineSettings);
                NetBeansProfiler.this.printDebugMsg("Profiler.attachToApp: ***************************************************", false);
                NetBeansProfiler.this.printDebugMsg("profiling settings --------------------------------", false);
                NetBeansProfiler.this.printDebugMsg(profilingSettings.debug(), false);
                NetBeansProfiler.this.printDebugMsg("attach settings -----------------------------------", false);
                NetBeansProfiler.this.printDebugMsg(attachSettings.debug(), false);
                NetBeansProfiler.this.printDebugMsg("instrumentation filter ----------------------------", false);
                NetBeansProfiler.this.printDebugMsg(profilerEngineSettings.getInstrumentationFilter().debug(), false);
                NetBeansProfiler.this.printDebugMsg("Profiler.attachToApp: ***************************************************", false);
                NetBeansProfiler.this.flushDebugMsgs();
                GestureSubmitter.logAttach(NetBeansProfiler.this.getProfiledProject(), attachSettings);
                GestureSubmitter.logConfig(profilingSettings);
                NetBeansProfiler.this.changeStateTo(2);
                NetBeansProfiler.this.cleanupBeforeProfiling(profilerEngineSettings);
                NetBeansProfiler.this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
                IDEUtils.runInEventDispatchThread(new Runnable(){

                    public void run() {
                        NetBeansProfiler.this.openWindowsOnProfilingStart();
                    }
                });
                if (attachSettings.isDirect()) {
                    boolean bl = false;
                    if (NetBeansProfiler.this.prepareInstrumentation(profilingSettings)) {
                        boolean bl2 = bl = NetBeansProfiler.this.targetAppRunner.initiateSession(1, false) && NetBeansProfiler.this.targetAppRunner.attachToTargetVMOnStartup();
                    }
                    if (!bl) {
                        NetBeansProfiler.this.changeStateTo(1);
                        outputParameter.setValue(false);
                        return;
                    }
                } else if (attachSettings.isDynamic16()) {
                    String string = NetBeansProfiler.this.getLibsDir() + "/jfluid-server-15.jar";
                    String string2 = String.valueOf(attachSettings.getPid());
                    String string3 = String.valueOf(attachSettings.getPort());
                    boolean bl = false;
                    try {
                        this.loadAgentIntTargetJVM(string, string3, string2);
                        if (NetBeansProfiler.this.prepareInstrumentation(profilingSettings)) {
                            bl = NetBeansProfiler.this.targetAppRunner.initiateSession(2, false) && NetBeansProfiler.this.targetAppRunner.attachToTargetVM();
                        }
                    }
                    catch (Exception exception) {
                        NetBeansProfiler.this.displayError(exception.getMessage());
                        ProfilerLogger.log((Exception)exception);
                    }
                    if (!bl) {
                        NetBeansProfiler.this.changeStateTo(1);
                        outputParameter.setValue(false);
                        return;
                    }
                } else {
                    throw new IllegalArgumentException("Invalid settings " + attachSettings);
                }
                if (NetBeansProfiler.this.targetAppRunner.targetAppIsRunning()) {
                    NetBeansProfiler.this.getThreadsManager().setSupportsSleepingStateMonitoring(Platform.supportsThreadSleepingStateMonitoring((String)profilerEngineSettings.getTargetJDKVersionString()));
                    NetBeansProfiler.this.monitor.monitorVM(NetBeansProfiler.this.targetAppRunner);
                    if (NetBeansProfiler.this.threadsMonitoringEnabled) {
                        IDEUtils.runInEventDispatchThread(new Runnable(){

                            public void run() {
                                ThreadsWindow.getDefault().showThreads();
                            }
                        });
                    }
                    outputParameter.setValue(true);
                    return;
                }
                outputParameter.setValue(false);
            }

            private void loadAgentIntTargetJVM(String string, String string2, String string3) throws SecurityException, IllegalArgumentException, IllegalAccessException, NoSuchMethodException, ClassNotFoundException, InvocationTargetException {
                Class<?> clazz = Class.forName("com.sun.tools.attach.VirtualMachine");
                Method method = clazz.getMethod(NetBeansProfiler.ATTACH_SETTINGS_FILENAME, String.class);
                Object object = method.invoke(null, string3);
                Method method2 = clazz.getMethod("loadAgent", String.class, String.class);
                method2.invoke(object, string, string2);
            }

            protected void nonResponding() {
                this.ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"NetBeansProfiler_StartingSession"));
                this.ph.start();
            }

            protected void done() {
                if (this.ph != null) {
                    this.ph.finish();
                    this.ph = null;
                }
            }
        }.execute();
        return outputParameter.getValue();
    }

    public void checkAndUpdateState() {
        boolean bl = this.targetAppRunner.targetJVMIsAlive();
        if (!bl) {
            this.changeStateTo(1);
            return;
        }
        boolean bl2 = this.targetAppRunner.targetAppIsRunning();
        if (!bl2) {
            this.changeStateTo(16);
            return;
        }
        boolean bl3 = this.targetAppRunner.targetAppSuspended();
        if (bl3) {
            this.changeStateTo(8);
        }
    }

    public boolean cleanForProfilingOnPort(int n) {
        if (this.isProfilingRunningOnPort(n)) {
            ProfilerLogger.severe((String)(">>> Profiling session already running on port " + n + ", will cause collision when starting another agent on the same port."));
            return false;
        }
        if (!this.shutdownAgent("localhost", n)) {
            ProfilerLogger.severe((String)(">>> Profiler agent already profiling on port " + n + " (communicating with another IDE?), will cause collision when starting another agent on the same port."));
            return false;
        }
        File file = NetBeansProfiler.getInfoFile(n);
        if (file.exists()) {
            boolean bl = this.waitForDeleteAgentFile(file);
            if (!bl) {
                ProfilerLogger.severe((String)(">>> Profiler agent identification file cannot be deleted for port " + n + ", will cause failure starting a server for profiling on the same port."));
            }
            return bl;
        }
        return true;
    }

    public boolean connectToStartedApp(final ProfilingSettings profilingSettings, final SessionSettings sessionSettings) {
        this.profilingMode = 1;
        this.lastProfilingSettings = profilingSettings;
        this.lastSessionSettings = sessionSettings;
        this.lastMode = 1;
        final OutputParameter<Boolean> outputParameter = new OutputParameter<Boolean>(Boolean.TRUE);
        new NBSwingWorker(false){
            private ProgressHandle ph;
            {
                super(bl);
                this.ph = null;
            }

            protected void doInBackground() {
                if (NetBeansProfiler.this.targetAppRunner.targetJVMIsAlive()) {
                    NetBeansProfiler.this.targetAppRunner.terminateTargetJVM();
                }
                ProfilerEngineSettings profilerEngineSettings = NetBeansProfiler.this.targetAppRunner.getProfilerEngineSettings();
                sessionSettings.applySettings(profilerEngineSettings);
                profilingSettings.applySettings(profilerEngineSettings);
                profilerEngineSettings.setRemoteHost("");
                NetBeansProfiler.this.printDebugMsg("Profiler.connectToStartedApp: **************************************************", false);
                NetBeansProfiler.this.printDebugMsg("profiling settings -------------------------------", false);
                NetBeansProfiler.this.printDebugMsg(profilingSettings.debug(), false);
                NetBeansProfiler.this.printDebugMsg("session settings ---------------------------------", false);
                NetBeansProfiler.this.printDebugMsg(sessionSettings.debug(), false);
                NetBeansProfiler.this.printDebugMsg("instrumentation filter ---------------------------", false);
                NetBeansProfiler.this.printDebugMsg(profilerEngineSettings.getInstrumentationFilter().debug(), false);
                NetBeansProfiler.this.printDebugMsg("Profiler.connectToStartedApp: **************************************************", false);
                NetBeansProfiler.this.flushDebugMsgs();
                GestureSubmitter.logProfileApp(NetBeansProfiler.this.getProfiledProject(), sessionSettings);
                GestureSubmitter.logConfig(profilingSettings);
                NetBeansProfiler.this.changeStateTo(2);
                NetBeansProfiler.this.cleanupBeforeProfiling(profilerEngineSettings);
                NetBeansProfiler.this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
                IDEUtils.runInEventDispatchThread(new Runnable(){

                    public void run() {
                        NetBeansProfiler.this.openWindowsOnProfilingStart();
                    }
                });
                if (!CalibrationDataFileIO.validateCalibrationInput((String)sessionSettings.getJavaVersionString(), (String)sessionSettings.getJavaExecutable())) {
                    NetBeansProfiler.this.displayErrorWithDetailsAndWait(CALIBRATION_MISSING_SHORT_MESSAGE, CALIBRATION_MISSING_MESSAGE);
                    NetBeansProfiler.this.changeStateTo(1);
                    outputParameter.setValue(Boolean.FALSE);
                    return;
                }
                if (!NetBeansProfiler.this.prepareInstrumentation(profilingSettings)) {
                    outputParameter.setValue(Boolean.FALSE);
                    return;
                }
                if (!NetBeansProfiler.this.targetAppRunner.initiateSession(0, false) || !NetBeansProfiler.this.targetAppRunner.connectToStartedVMAndStartTA()) {
                    NetBeansProfiler.this.changeStateTo(1);
                    outputParameter.setValue(Boolean.FALSE);
                    return;
                }
                if (NetBeansProfiler.this.targetAppRunner.targetAppIsRunning()) {
                    NetBeansProfiler.this.getThreadsManager().setSupportsSleepingStateMonitoring(Platform.supportsThreadSleepingStateMonitoring((String)profilerEngineSettings.getTargetJDKVersionString()));
                    IDEUtils.runInEventDispatchThread(new Runnable(){

                        public void run() {
                            NetBeansProfiler.this.monitor.monitorVM(NetBeansProfiler.this.targetAppRunner);
                        }
                    });
                    outputParameter.setValue(Boolean.TRUE);
                    return;
                }
                NetBeansProfiler.this.changeStateTo(1);
                outputParameter.setValue(Boolean.FALSE);
            }

            protected void nonResponding() {
                this.ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"NetBeansProfiler_StartingSession"));
                this.ph.start();
            }

            protected void done() {
                if (this.ph != null) {
                    this.ph.finish();
                    this.ph = null;
                }
            }
        }.execute();
        return outputParameter.getValue();
    }

    public void detachFromApp() {
        this.setTransitionState();
        if (this.targetAppRunner.getProfilingSessionStatus().currentInstrType != 0) {
            try {
                this.targetAppRunner.getProfilerClient().removeAllInstrumentation(false);
            }
            catch (InstrumentationException instrumentationException) {
                this.displayError(instrumentationException.getMessage());
            }
        }
        this.targetAppRunner.detachFromTargetJVM();
    }

    public void displayError(String string) {
        ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
    }

    public void displayErrorAndWait(String string) {
        ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
    }

    public void displayErrorWithDetailsAndWait(String string, String string2) {
        ProfilerDialogs.notify((NotifyDescriptor)new ProfilerDialogs.MessageWithDetails(string, string2, 0, false));
    }

    public void displayInfo(String string) {
        ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 1));
    }

    public void displayInfoAndWait(String string) {
        ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 1));
    }

    public void displayInfoWithDetailsAndWait(String string, String string2) {
        ProfilerDialogs.notify((NotifyDescriptor)new ProfilerDialogs.MessageWithDetails(string, string2, 1, false));
    }

    public void displayWarning(String string) {
        ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 2));
    }

    public void displayWarningAndWait(String string) {
        ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 2));
    }

    public void instrumentSelectedRoots(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) throws ClassNotFoundException, InstrumentationException, BadLocationException, IOException, ClassFormatError, ClientUtils.TargetAppOrVMTerminated {
        ProfilerClient profilerClient = this.targetAppRunner.getProfilerClient();
        if (sourceCodeSelectionArray.length == 0) {
            ClientUtils.SourceCodeSelection sourceCodeSelection = new ClientUtils.SourceCodeSelection(1);
            sourceCodeSelectionArray = new ClientUtils.SourceCodeSelection[]{sourceCodeSelection};
        }
        profilerClient.initiateRecursiveCPUProfInstrumentation(sourceCodeSelectionArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttachSettings loadAttachSettings(Project project) throws IOException {
        FileObject fileObject = IDEUtils.getProjectSettingsFolder(project, false);
        if (fileObject == null) {
            return null;
        }
        FileObject fileObject2 = fileObject.getFileObject(ATTACH_SETTINGS_FILENAME, "xml");
        if (fileObject2 == null) {
            return null;
        }
        InputStream inputStream = fileObject2.getInputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        try {
            Properties properties = new Properties();
            properties.loadFromXML(bufferedInputStream);
            AttachSettings attachSettings = new AttachSettings();
            attachSettings.load((Map)properties);
            AttachSettings attachSettings2 = attachSettings;
            return attachSettings2;
        }
        finally {
            bufferedInputStream.close();
        }
    }

    public void log(int n, String string) {
        switch (n) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 16;
                break;
            }
            case 8: {
                n = 4096;
                break;
            }
            case 16: {
                n = 65536;
                break;
            }
            default: {
                n = 0;
            }
        }
        if (profilerErrorManager.isLoggable(n)) {
            profilerErrorManager.log(n, string);
        }
    }

    public void modifyCurrentProfiling(final ProfilingSettings profilingSettings) {
        this.lastProfilingSettings = profilingSettings;
        if (this.rerunProps != null) {
            this.lastProfilingSettings.store((Map)this.rerunProps);
        }
        if (!this.targetAppRunner.targetJVMIsAlive()) {
            return;
        }
        ProfilerEngineSettings profilerEngineSettings = this.targetAppRunner.getProfilerEngineSettings();
        profilingSettings.applySettings(profilerEngineSettings);
        this.printDebugMsg("Profiler.modifyCurrentProfiling: ***************************************************", false);
        this.printDebugMsg("profiling settings --------------------------------", false);
        this.printDebugMsg(profilingSettings.debug(), false);
        this.printDebugMsg("instrumentation filter ----------------------------", false);
        this.printDebugMsg(profilerEngineSettings.getInstrumentationFilter().debug(), false);
        this.printDebugMsg("Profiler.modifyCurrentProfiling: ***************************************************", false);
        this.flushDebugMsgs();
        GestureSubmitter.logConfig(profilingSettings);
        this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
        IDEUtils.runInProfilerRequestProcessor(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block12: {
                    AppStatusHandler.AsyncDialog asyncDialog;
                    NetBeansProfiler.this.changeStateTo(128);
                    NetBeansProfiler.this.targetAppRunner.getAppStatusHandler().pauseLiveUpdates();
                    ProfilingPointsManager.getDefault().reset();
                    ResultsManager.getDefault().reset();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    NetBeansProfiler.this.waitDialog = NetBeansProfiler.this.targetAppRunner.getAppStatusHandler().getAsyncDialogInstance(MODIFYING_INSTRUMENTATION_MSG, true, false);
                    if (NetBeansProfiler.this.waitDialog != null) {
                        asyncDialog = NetBeansProfiler.this.waitDialog;
                        if (EventQueue.isDispatchThread()) {
                            asyncDialog.display();
                        } else {
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    asyncDialog.display();
                                }
                            });
                        }
                    }
                    try {
                        NetBeansProfiler.this.prepareInstrumentation(profilingSettings);
                        NetBeansProfiler.this.changeStateTo(4);
                        if (NetBeansProfiler.this.waitDialog == null) break block12;
                        asyncDialog = NetBeansProfiler.this.waitDialog;
                    }
                    catch (Throwable throwable) {
                        if (NetBeansProfiler.this.waitDialog != null) {
                            AppStatusHandler.AsyncDialog asyncDialog2 = NetBeansProfiler.this.waitDialog;
                            if (EventQueue.isDispatchThread()) {
                                asyncDialog2.close();
                            } else {
                                EventQueue.invokeLater(new Runnable(asyncDialog2){
                                    final /* synthetic */ AppStatusHandler.AsyncDialog val$dialog;
                                    {
                                        this.val$dialog = asyncDialog;
                                    }

                                    public void run() {
                                        this.val$dialog.close();
                                    }
                                });
                            }
                        }
                        NetBeansProfiler.this.targetAppRunner.getAppStatusHandler().resumeLiveUpdates();
                        throw throwable;
                    }
                    if (EventQueue.isDispatchThread()) {
                        asyncDialog.close();
                    } else {
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                NetBeansProfiler.this.targetAppRunner.getAppStatusHandler().resumeLiveUpdates();
            }
        });
    }

    public void notifyException(int n, Exception exception) {
        switch (n) {
            case 1: {
                profilerErrorManager.notify(1, (Throwable)exception);
                return;
            }
            case 2: {
                profilerErrorManager.notify(16, (Throwable)exception);
                return;
            }
            case 8: {
                profilerErrorManager.notify(4096, (Throwable)exception);
                return;
            }
            case 16: {
                profilerErrorManager.notify(65536, (Throwable)exception);
                return;
            }
        }
        profilerErrorManager.notify(0, (Throwable)exception);
    }

    public void openJavaSource(String string, String string2, String string3) {
        this.openJavaSource(this.getProfiledProject(), string, string2, string3);
    }

    public void openJavaSource(final Project project, final String string, final String string2, String string3) {
        IDEUtils.runInProfilerRequestProcessor(new Runnable(){

            public void run() {
                GoToSourceHelper.openSource(project, string, string2, string);
            }
        });
    }

    public boolean processesProfilingPoints() {
        return this.processesProfilingPoints;
    }

    public boolean profileClass(final ProfilingSettings profilingSettings, final SessionSettings sessionSettings) {
        this.profilingMode = 1;
        this.lastProfilingSettings = profilingSettings;
        this.lastSessionSettings = sessionSettings;
        this.lastMode = 1;
        if (this.targetAppRunner.targetJVMIsAlive()) {
            this.targetAppRunner.terminateTargetJVM();
        }
        final ProfilerEngineSettings profilerEngineSettings = this.targetAppRunner.getProfilerEngineSettings();
        sessionSettings.applySettings(profilerEngineSettings);
        profilingSettings.applySettings(profilerEngineSettings);
        profilerEngineSettings.setRemoteHost("");
        this.printDebugMsg("Profiler.profileClass: **************************************************", false);
        this.printDebugMsg("Profiler.profileClass: profiling settings -------------------------------", false);
        this.printDebugMsg(profilingSettings.debug(), false);
        this.printDebugMsg("Profiler.profileClass: session settings ---------------------------------", false);
        this.printDebugMsg(sessionSettings.debug(), false);
        this.printDebugMsg("Profiler.profileClass: **************************************************", false);
        this.printDebugMsg("Instrumentation filter:\n" + profilerEngineSettings.getInstrumentationFilter().debug(), false);
        this.flushDebugMsgs();
        Project project = FileOwnerQuery.getOwner((FileObject)this.getProfiledSingleFile());
        GestureSubmitter.logProfileClass(project, sessionSettings);
        GestureSubmitter.logConfig(profilingSettings);
        this.changeStateTo(2);
        this.cleanupBeforeProfiling(profilerEngineSettings);
        this.setThreadsMonitoringEnabled(profilingSettings.getThreadsMonitoringEnabled());
        this.openWindowsOnProfilingStart();
        final Frame frame = WindowManager.getDefault().getMainWindow();
        IDEUtils.runInProfilerRequestProcessor(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Cursor cursor = frame.getCursor();
                frame.setCursor(Utilities.createProgressCursor((Component)frame));
                try {
                    if (!NetBeansProfiler.this.runCalibration(true, sessionSettings.getJavaExecutable(), sessionSettings.getJavaVersionString(), sessionSettings.getSystemArchitecture())) {
                        NetBeansProfiler.this.displayError(CALIBRATION_FAILED_MESSAGE);
                        NetBeansProfiler.this.changeStateTo(1);
                        return;
                    }
                    boolean bl = NetBeansProfiler.this.prepareInstrumentation(profilingSettings);
                    boolean bl2 = bl = bl && NetBeansProfiler.this.targetAppRunner.startTargetVM() && NetBeansProfiler.this.targetAppRunner.initiateSession(0, false) && NetBeansProfiler.this.targetAppRunner.connectToStartedVMAndStartTA();
                    if (!bl) {
                        NetBeansProfiler.this.changeStateTo(1);
                        return;
                    }
                    if (NetBeansProfiler.this.targetAppRunner.targetAppIsRunning()) {
                        NetBeansProfiler.this.getThreadsManager().setSupportsSleepingStateMonitoring(Platform.supportsThreadSleepingStateMonitoring((String)profilerEngineSettings.getTargetJDKVersionString()));
                        IDEUtils.runInEventDispatchThread(new Runnable(){

                            public void run() {
                                NetBeansProfiler.this.monitor.monitorVM(NetBeansProfiler.this.targetAppRunner);
                            }
                        });
                    } else {
                        NetBeansProfiler.this.changeStateTo(1);
                    }
                }
                finally {
                    frame.setCursor(cursor);
                }
            }
        });
        return true;
    }

    public boolean rerunAvaliable() {
        return this.rerunTarget != null;
    }

    public void rerunLastProfiling() {
        if (this.rerunTarget != null) {
            NetBeansProfiler.doRunTarget(this.rerunScript, this.rerunTarget, this.rerunProps);
        }
    }

    public boolean runCalibration(boolean bl, String string, String string2, int n) {
        this.calibrating = true;
        ProfilerEngineSettings profilerEngineSettings = this.targetAppRunner.getProfilerEngineSettings();
        int n2 = profilerEngineSettings.getPortNo();
        InstrumentationFilter instrumentationFilter = profilerEngineSettings.getInstrumentationFilter();
        String string3 = profilerEngineSettings.getTargetJVMExeFile();
        String string4 = profilerEngineSettings.getTargetJDKVersionString();
        int n3 = profilerEngineSettings.getSystemArchitecture();
        String string5 = profilerEngineSettings.getMainClassPath();
        if (string != null) {
            profilerEngineSettings.setTargetJVMExeFile(string);
            profilerEngineSettings.setTargetJDKVersionString(string2);
            profilerEngineSettings.setSystemArchitecture(n);
        }
        profilerEngineSettings.setPortNo(this.ideSettings.getCalibrationPortNo());
        profilerEngineSettings.setInstrumentationFilter(new InstrumentationFilter());
        profilerEngineSettings.setMainClassPath("");
        boolean bl2 = false;
        if (bl) {
            bl2 = this.targetAppRunner.readSavedCalibrationData();
            if (!bl2) {
                this.displayInfoAndWait(INITIAL_CALIBRATION_MSG);
                bl2 = this.targetAppRunner.calibrateInstrumentationCode();
            }
        } else {
            bl2 = this.targetAppRunner.calibrateInstrumentationCode();
        }
        this.calibrating = false;
        profilerEngineSettings.setPortNo(n2);
        profilerEngineSettings.setInstrumentationFilter(instrumentationFilter);
        profilerEngineSettings.setTargetJDKVersionString(string4);
        profilerEngineSettings.setSystemArchitecture(n3);
        profilerEngineSettings.setTargetJVMExeFile(string3);
        profilerEngineSettings.setMainClassPath(string5);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAttachSettings(Project project, AttachSettings attachSettings) {
        FileLock fileLock = null;
        try {
            FileObject fileObject = IDEUtils.getProjectSettingsFolder(project, true);
            FileObject fileObject2 = fileObject.getFileObject(ATTACH_SETTINGS_FILENAME, "xml");
            if (fileObject2 == null) {
                fileObject2 = fileObject.createData(ATTACH_SETTINGS_FILENAME, "xml");
            }
            fileLock = fileObject2.lock();
            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            Properties properties = new Properties();
            attachSettings.store((Map)properties);
            properties.storeToXML(bufferedOutputStream, "");
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(ERROR_SAVING_ATTACH_SETTINGS_MESSAGE, exception.getMessage()), 0));
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    public void setProfiledProject(Project project, FileObject fileObject) {
        this.profiledProject = project;
        this.profiledSingleFile = fileObject;
        ProfilerControlPanel2.getDefault().setProfiledProject(project);
    }

    public Project getProfiledProject() {
        return this.profiledProject;
    }

    public FileObject getProfiledSingleFile() {
        return this.profiledSingleFile;
    }

    public void setSilent(boolean bl) {
        this.silent = bl;
    }

    public boolean prepareInstrumentation(ProfilingSettings profilingSettings) {
        this.teardownDispatcher();
        this.setupDispatcher(profilingSettings);
        ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = MarkingEngine.getDefault().getMarkerMethods();
        profilingSettings.setInstrumentationMarkerMethods(sourceCodeSelectionArray);
        boolean bl = super.prepareInstrumentation(profilingSettings);
        return bl;
    }

    public void runTarget(FileObject fileObject, String string, Properties properties) {
        this.rerunScript = fileObject;
        this.rerunTarget = string;
        this.rerunProps = IDEUtils.duplicateProperties(properties);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((RerunAction)RerunAction.get(RerunAction.class)).updateAction();
            }
        });
        NetBeansProfiler.doRunTarget(fileObject, string, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGlobalFilters() {
        Properties properties;
        BufferedOutputStream bufferedOutputStream;
        OutputStream outputStream;
        FileObject fileObject;
        FileObject fileObject2;
        FileLock fileLock = null;
        try {
            fileObject2 = IDEUtils.getSettingsFolder(true);
            fileObject = fileObject2.getFileObject(GLOBAL_FILTERS_FILENAME, "xml");
            if (fileObject == null) {
                fileObject = fileObject2.createData(GLOBAL_FILTERS_FILENAME, "xml");
            }
            fileLock = fileObject.lock();
            outputStream = fileObject.getOutputStream(fileLock);
            bufferedOutputStream = new BufferedOutputStream(outputStream);
            properties = new Properties();
            this.globalFilters.store((Map)properties);
            properties.storeToXML(bufferedOutputStream, "");
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(ERROR_SAVING_PROFILING_SETTINGS_MESSAGE, exception.getMessage()), 0));
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        fileLock = null;
        try {
            fileObject2 = IDEUtils.getSettingsFolder(true);
            fileObject = fileObject2.getFileObject(DEFINED_FILTERSETS_FILENAME, "xml");
            if (fileObject == null) {
                fileObject = fileObject2.createData(DEFINED_FILTERSETS_FILENAME, "xml");
            }
            fileLock = fileObject.lock();
            outputStream = fileObject.getOutputStream(fileLock);
            bufferedOutputStream = new BufferedOutputStream(outputStream);
            properties = new Properties();
            this.definedFilterSets.store((Map)properties);
            properties.storeToXML(bufferedOutputStream, "");
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(ERROR_SAVING_FILTER_SETS_MESSAGE, exception.getMessage()), 0));
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    public void shutdown() {
        this.monitor.stopUpdateThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdownBlockedAgent(String string, int n, int n2) {
        int n3 = this.getAgentState(string, n, n2);
        if (n3 == 2) {
            Socket socket = null;
            ObjectOutputStream objectOutputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                socket = new Socket(string, n);
                socket.setSoTimeout(100);
                socket.setTcpNoDelay(true);
                objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
                objectInputStream = new ObjectInputStream(socket.getInputStream());
                WireIO wireIO = new WireIO(objectOutputStream, objectInputStream);
                wireIO.sendSimpleCommand(12);
                Object object = wireIO.receiveCommandOrResponse();
                if (object instanceof Response && ((Response)object).isOK()) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException iOException) {
                    ProfilerLogger.log((Exception)iOException);
                }
            }
        }
        return false;
    }

    public void stopApp() {
        this.setTransitionState();
        this.getTargetAppRunner().terminateTargetJVM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getAgentProperties(int n) {
        File file = NetBeansProfiler.getInfoFile(n);
        if (!file.exists()) {
            return null;
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            properties.load(bufferedInputStream);
            bufferedInputStream.close();
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException iOException) {
            Properties properties = null;
            return properties;
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private static File getInfoFile(int n) {
        String string = System.getProperty("user.home");
        return new File(string + File.separator + ".nbprofiler" + File.separator + n);
    }

    private boolean isProfilingRunningOnPort(int n) {
        return this.profilingState == 4 && n == this.targetAppRunner.getProfilerEngineSettings().getPortNo();
    }

    private void setTransitionState() {
        this.changeStateTo(128);
    }

    private void changeStateTo(int n) {
        if (this.profilingState == n) {
            return;
        }
        int n2 = this.profilingState;
        this.profilingState = n;
        this.fireProfilingStateChange(n2, this.profilingState);
        if (n == 1 || n == 16) {
            this.cleanupAfterProfiling();
        }
    }

    private void cleanupAfterProfiling() {
        this.stopLoadGenerator();
        this.teardownDispatcher();
        ClassRepository.cleanup();
    }

    private void cleanupBeforeProfiling(ProfilerEngineSettings profilerEngineSettings) {
        Profiler profiler = Profiler.getDefault();
        profiler.getThreadsManager().reset();
        profiler.getVMTelemetryManager().reset();
        ProfilingPointsManager.getDefault().reset();
        ResultsManager.getDefault().reset();
        ClassRepository.clearCache();
        ClassRepository.initClassPaths((String)profilerEngineSettings.getWorkingDir(), (String[])profilerEngineSettings.getVMClassPaths());
    }

    private void closeWaitDialog() {
        if (this.waitDialogOpen) {
            this.waitDialog.close();
            this.waitDialogOpen = false;
        }
    }

    private void displayWaitDialog() {
        this.waitDialogOpen = true;
        this.waitDialog.display();
    }

    private void displayWarningAboutEntireAppProfiling() {
        this.displayWarning(ENTIRE_APPLICATION_PROFILING_WARNING);
    }

    private void flushDebugMsgs() {
        String string = this.logMsgs.toString();
        if (LOGGER.isLoggable(Level.CONFIG) && !this.silent) {
            LOGGER.config(string);
        } else {
            profilerErrorManager.log(string);
        }
    }

    private void loadGlobalFilters() {
        try {
            Object object;
            Object object2;
            Object object3;
            FileObject fileObject = IDEUtils.getSettingsFolder(false);
            FileObject fileObject2 = null;
            String string = IDEUtils.getServicesDir();
            if (string != null) {
                fileObject2 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string)));
            }
            FileObject fileObject3 = null;
            if (fileObject != null && fileObject.isValid()) {
                fileObject3 = fileObject.getFileObject(GLOBAL_FILTERS_FILENAME, "xml");
            }
            if (fileObject3 == null && fileObject2 != null && fileObject2.isValid()) {
                object3 = NbBundle.getLocalizingSuffixes();
                while (object3.hasNext() && fileObject3 == null) {
                    fileObject3 = fileObject2.getFileObject("filters-default" + object3.next(), "xml");
                }
            }
            if (fileObject3 != null) {
                object3 = fileObject3.getInputStream();
                object2 = new BufferedInputStream((InputStream)object3);
                object = new Properties();
                ((Properties)object).loadFromXML((InputStream)object2);
                this.globalFilters = new GlobalFilters();
                this.globalFilters.load((Map)object);
                ((BufferedInputStream)object2).close();
            }
            object3 = null;
            if (fileObject != null && fileObject.isValid()) {
                object3 = fileObject.getFileObject(DEFINED_FILTERSETS_FILENAME, "xml");
            }
            if (object3 == null && fileObject2 != null && fileObject2.isValid()) {
                object2 = NbBundle.getLocalizingSuffixes();
                while (object2.hasNext() && object3 == null) {
                    object3 = fileObject2.getFileObject("filtersets-default" + object2.next(), "xml");
                }
            }
            if (object3 != null) {
                object2 = object3.getInputStream();
                object = new BufferedInputStream((InputStream)object2);
                Properties properties = new Properties();
                properties.loadFromXML((InputStream)object);
                this.definedFilterSets = new DefinedFilterSets();
                this.definedFilterSets.load((Map)properties);
                ((BufferedInputStream)object).close();
            }
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(ERROR_LOADING_PROFILING_SETTINGS_MESSAGE, exception.getMessage()), 0));
        }
    }

    private void openWindowsOnProfilingStart() {
        int n = this.ideSettings.getTelemetryOverviewBehavior();
        int n2 = this.ideSettings.getThreadsViewBehavior();
        boolean bl = this.lastProfilingSettings.getThreadsMonitoringEnabled();
        int n3 = this.lastProfilingSettings.getProfilingType();
        if (n == 1 || n == 2 && n3 == 1) {
            TelemetryOverviewPanel.getDefault().open();
            TelemetryOverviewPanel.getDefault().requestVisible();
        }
        if (bl && (n2 == 1 || n2 == 2 && n3 == 1)) {
            ThreadsWindow.getDefault().open();
            ThreadsWindow.getDefault().requestVisible();
        }
        if (this.ideSettings.getDisplayLiveResultsCPU() && (n3 == 8 || n3 == 16) || this.ideSettings.getDisplayLiveResultsFragment() && n3 == 32 || this.ideSettings.getDisplayLiveResultsMemory() && (n3 == 2 || n3 == 4)) {
            LiveResultsWindow.getDefault().open();
            LiveResultsWindow.getDefault().requestVisible();
        }
        ProfilerControlPanel2 profilerControlPanel2 = ProfilerControlPanel2.getDefault();
        profilerControlPanel2.open();
        profilerControlPanel2.requestActive();
    }

    private void printDebugMsg(String string) {
        this.printDebugMsg(string, true);
    }

    private void printDebugMsg(String string, boolean bl) {
        this.logMsgs.append(string).append('\n');
        if (bl) {
            this.flushDebugMsgs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupDispatcher(ProfilingSettings profilingSettings) {
        Object object = this.setupLock;
        synchronized (object) {
            RuntimeProfilingPoint[] runtimeProfilingPointArray;
            Object object22;
            Object object3;
            ProfilerClient profilerClient;
            Object object4;
            Collection collection3;
            Project project = ((NetBeansProfiler)Profiler.getDefault()).getProfiledProject();
            CCTProvider cCTProvider = null;
            Collection collection2 = null;
            switch (profilingSettings.getProfilingType()) {
                case 8: 
                case 16: 
                case 32: {
                    cCTProvider = (CCTProvider)Lookup.getDefault().lookup(CPUCCTProvider.class);
                    collection2 = Lookup.getDefault().lookupAll(CPUCCTProvider.Listener.class);
                    break;
                }
                case 2: 
                case 4: {
                    cCTProvider = (CCTProvider)Lookup.getDefault().lookup(MemoryCCTProvider.class);
                    collection2 = Lookup.getDefault().lookupAll(MemoryCCTProvider.Listener.class);
                }
            }
            if (cCTProvider != null && collection2 != null && collection2.size() > 0) {
                for (Collection collection3 : collection2) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Adding listener " + collection3.getClass().getName() + " to the provider " + cCTProvider.getClass().getName());
                    }
                    cCTProvider.addListener((CCTProvider.Listener)collection3);
                }
            } else if (LOGGER.isLoggable(Level.WARNING)) {
                if (cCTProvider == null) {
                    LOGGER.warning("Could not find a CCT provider in lookup!");
                } else if (collection2 == null || collection2.size() == 0) {
                    LOGGER.warning("Could not find listeners in lookup!");
                }
            }
            StatisticalModuleContainer statisticalModuleContainer = (StatisticalModuleContainer)Lookup.getDefault().lookup(StatisticalModuleContainer.class);
            collection3 = Lookup.getDefault().lookupAll(StatisticalModule.class);
            if (statisticalModuleContainer != null && collection3 != null) {
                object4 = collection3.iterator();
                while (object4.hasNext()) {
                    profilerClient = (StatisticalModule)object4.next();
                    if (profilerClient instanceof ProjectAwareStatisticalModule) {
                        if (!((ProjectAwareStatisticalModule)profilerClient).supportsProject(project)) continue;
                        statisticalModuleContainer.addModule((StatisticalModule)profilerClient);
                        continue;
                    }
                    statisticalModuleContainer.addModule((StatisticalModule)profilerClient);
                }
            }
            if ((object4 = Lookup.getDefault().lookupAll(ProjectAwareStatisticalModule.class)) != null) {
                profilerClient = object4.iterator();
                while (profilerClient.hasNext()) {
                    object3 = (ProjectAwareStatisticalModule)((Object)profilerClient.next());
                    if (!object3.supportsProject(project)) continue;
                    statisticalModuleContainer.addModule((StatisticalModule)object3);
                }
            }
            profilerClient = this.getTargetAppRunner().getProfilerClient();
            object3 = (CCTResultsFilter)Lookup.getDefault().lookup(CCTResultsFilter.class);
            if (object3 != null) {
                object3.reset();
            }
            Collection collection4 = Lookup.getDefault().lookupAll(ContextAware.class);
            for (Object object22 : collection4) {
                object22.setContext(profilerClient);
            }
            boolean bl = profilingSettings.getProfilingType() == 8 || profilingSettings.getProfilingType() == 16;
            object22 = project != null ? (Categorization)project.getLookup().lookup(Categorization.class) : null;
            if (bl &= object22 != null) {
                object22.reset();
                MarkingEngine.getDefault().configure(object22.getMappings());
            } else {
                MarkingEngine.getDefault().deconfigure();
            }
            Collection collection5 = null;
            if (profilingSettings.getProfilingType() == 16 || profilingSettings.getProfilingType() == 8) {
                collection5 = Lookup.getDefault().lookupAll(CPUProfilingResultListener.class);
                for (CPUProfilingResultListener cPUProfilingResultListener : collection5) {
                    ProfilingResultsDispatcher.getDefault().addListener(cPUProfilingResultListener);
                    cPUProfilingResultListener.startup(this.targetAppRunner.getProfilerClient());
                }
            } else if (profilingSettings.getProfilingType() == 2 || profilingSettings.getProfilingType() == 4) {
                collection5 = Lookup.getDefault().lookupAll(MemoryProfilingResultsListener.class);
                for (MemoryProfilingResultsListener memoryProfilingResultsListener : collection5) {
                    ProfilingResultsDispatcher.getDefault().addListener(memoryProfilingResultsListener);
                    memoryProfilingResultsListener.startup(this.targetAppRunner.getProfilerClient());
                }
            }
            if (profilingSettings.useProfilingPoints() && this.getProfiledProject() != null) {
                runtimeProfilingPointArray = ProfilingPointsManager.getDefault().createCodeProfilingConfiguration(this.getProfiledProject(), profilingSettings);
                this.processesProfilingPoints = runtimeProfilingPointArray.length > 0;
                this.targetAppRunner.getProfilerEngineSettings().setRuntimeProfilingPoints(runtimeProfilingPointArray);
            } else {
                runtimeProfilingPointArray = new RuntimeProfilingPoint[]{};
                this.processesProfilingPoints = false;
                this.targetAppRunner.getProfilerEngineSettings().setRuntimeProfilingPoints(runtimeProfilingPointArray);
            }
            if (this.processesProfilingPoints) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!ProfilingPointsWindow.getInstance().isOpened()) {
                            ProfilingPointsWindow.getInstance().open();
                            ProfilingPointsWindow.getInstance().requestVisible();
                        }
                    }
                });
            }
            ProfilingResultsDispatcher.getDefault().startup(profilerClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shutdownAgent(String string, int n) {
        Socket socket = null;
        ObjectOutputStream objectOutputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            socket = new Socket(string, n);
            socket.setSoTimeout(100);
            socket.setTcpNoDelay(true);
            objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            objectInputStream = new ObjectInputStream(socket.getInputStream());
            WireIO wireIO = new WireIO(objectOutputStream, objectInputStream);
            wireIO.sendSimpleCommand(12);
            try {
                Object object = wireIO.receiveCommandOrResponse();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProfilerLogger.warning((String)(">>> An existing Profiler agent listening on port " + n + " was terminated to allow starting new profiling session on the same port."));
            boolean bl = true;
            return bl;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void stopLoadGenerator() {
        String string;
        LoadGenPlugin loadGenPlugin;
        Properties properties = NetBeansProfiler.getDefaultNB().getCurrentProfilingProperties();
        if (properties != null && (loadGenPlugin = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class)) != null && (string = properties.getProperty("profiler.loadgen.path")) != null) {
            loadGenPlugin.stop(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teardownDispatcher() {
        Object object = this.setupLock;
        synchronized (object) {
            ProfilingResultsDispatcher.getDefault().shutdown();
            StatisticalModuleContainer statisticalModuleContainer = (StatisticalModuleContainer)Lookup.getDefault().lookup(StatisticalModuleContainer.class);
            if (statisticalModuleContainer != null) {
                statisticalModuleContainer.removeAllModules();
            }
            ProfilerClient profilerClient = this.getTargetAppRunner().getProfilerClient();
            profilerClient.registerFlatProfileProvider(null);
            MarkingEngine.getDefault().deconfigure();
        }
    }

    private boolean waitForDeleteAgentFile(File file) {
        if (file.delete()) {
            return true;
        }
        for (int i = 0; i < 5; ++i) {
            if (file.delete()) {
                return true;
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    public static ExecutorTask doRunTarget(FileObject fileObject, String string, Properties properties) {
        try {
            String string2 = properties.getProperty("profiler.info.oomeprotection");
            if (string2 != null && string2.equals("yes")) {
                HeapDumpWatch.getDefault().monitor(properties.getProperty("profiler.info.oomeprotection.dumppath"));
            }
            return ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{string}, (Properties)properties);
        }
        catch (IOException iOException) {
            Profiler.getDefault().notifyException(8, (Exception)iOException);
            return null;
        }
    }

    static {
        if (LOGGER.getLevel() == null || LOGGER.getLevel().intValue() > Level.CONFIG.intValue()) {
            LOGGER.setLevel(Level.CONFIG);
        }
        CALIBRATION_FAILED_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"ProfilerModule_CalibrationFailedMessage");
        CALIBRATION_MISSING_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"NetBeansProfiler_MustCalibrateFirstMsg");
        CALIBRATION_MISSING_SHORT_MESSAGE = NbBundle.getMessage(ProfilerModule.class, (String)"NetBeansProfiler_MustCalibrateFirstShortMsg");
        PROGRESS_DIALOG_CAPTION = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ProgressDialogCaption");
        ENTIRE_APPLICATION_PROFILING_WARNING = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_EntireApplicationProfilingWarning");
        DIRECTORY_DOES_NOT_EXIST_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_DirectoryDoesNotExistMessage");
        DIRECTORY_IS_WRITE_PROTECTED_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_DirectoryIsWriteProtectedMessage");
        ERROR_LOADING_PROFILING_SETTINGS_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ErrorLoadingProfilingSettingsMessage");
        ERROR_SAVING_PROFILING_SETTINGS_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ErrorSavingProfilingSettingsMessage");
        ERROR_SAVING_FILTER_SETS_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ErrorSavingFilterSetsMessage");
        ERROR_SAVING_ATTACH_SETTINGS_MESSAGE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ErrorSavingAttachSettingsMessage");
        CANNOT_FIND_LIBS_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_CannotFindLibsMsg");
        ENGINE_INIT_FAILED_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_EngineInitFailedMsg");
        INITIAL_CALIBRATION_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_InitialCalibrationMsg");
        TERMINATE_VM_ON_EXIT_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TerminateVMOnExitMsg");
        TAKE_SNAPSHOT_ON_EXIT_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TakeSnapshotOnExitMsg");
        TAKE_SNAPSHOT_ON_EXIT_DIALOG_TITLE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TakeSnapshotOnExitDialogTitle");
        TARGET_APP_NOT_RESPONDING_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TargetAppNotRespondingMsg");
        TARGET_APP_NOT_RESPONDING_DIALOG_TITLE = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_TargetAppNotRespondingDialogTitle");
        MODIFYING_INSTRUMENTATION_MSG = NbBundle.getMessage(NetBeansProfiler.class, (String)"NetBeansProfiler_ModifyingInstrumentationMsg");
        profilerErrorManager = ErrorManager.getDefault().getInstance("org.netbeans.modules.profiler");
        initialized = false;
    }

    private final class IDEAppStatusHandler
    implements AppStatusHandler {
        private IDEAppStatusHandler() {
        }

        public AppStatusHandler.AsyncDialog getAsyncDialogInstance(String string, boolean bl, boolean bl2) {
            return new ProgressPanel(string, bl, bl2);
        }

        public boolean confirmWaitForConnectionReply() {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)TARGET_APP_NOT_RESPONDING_MSG, TARGET_APP_NOT_RESPONDING_DIALOG_TITLE, 0, 2);
            return ProfilerDialogs.notify((NotifyDescriptor)confirmation) != ProfilerDialogs.DNSAConfirmation.YES_OPTION;
        }

        public void displayError(String string) {
            NetBeansProfiler.this.printDebugMsg("IDEAppStatusHandler - error: " + string);
            NetBeansProfiler.this.displayError(string);
        }

        public void displayErrorAndWaitForConfirm(String string) {
            NetBeansProfiler.this.printDebugMsg("IDEAppStatusHandler - errorAndWaitForConfirm: " + string);
            NetBeansProfiler.this.displayErrorAndWait(string);
        }

        public void displayErrorWithDetailsAndWaitForConfirm(String string, String string2) {
            NetBeansProfiler.this.displayErrorWithDetailsAndWait(string, string2);
        }

        public void displayNotification(String string) {
            StatusDisplayer.getDefault().setStatusText(string);
        }

        public void displayNotificationAndWaitForConfirm(String string) {
            NetBeansProfiler.this.displayInfoAndWait(string);
        }

        public void displayNotificationWithDetailsAndWaitForConfirm(String string, String string2) {
            NetBeansProfiler.this.displayInfoWithDetailsAndWait(string, string2);
        }

        public void displayWarning(String string) {
            NetBeansProfiler.this.printDebugMsg("IDEAppStatusHandler - warning: " + string);
            NetBeansProfiler.this.displayWarning(string);
        }

        public void displayWarningAndWaitForConfirm(String string) {
            NetBeansProfiler.this.printDebugMsg("IDEAppStatusHandler - warningAndWaitForConfirm: " + string);
            NetBeansProfiler.this.displayWarningAndWait(string);
        }

        public void handleShutdown() {
            if (LiveResultsWindow.hasDefault()) {
                LiveResultsWindow.getDefault().handleShutdown();
            }
            if (Profiler.getDefault().getTargetAppRunner().getProfilerClient().getCurrentInstrType() == 0 || !ResultsManager.getDefault().resultsAvailable()) {
                ProfilerDialogs.DNSAMessage dNSAMessage = new ProfilerDialogs.DNSAMessage("NetBeansProfiler.handleShutdown.noResults", TERMINATE_VM_ON_EXIT_MSG, 1);
                dNSAMessage.setDNSADefault(false);
                ProfilerDialogs.notify((NotifyDescriptor)dNSAMessage);
            } else {
                ProfilerDialogs.DNSAConfirmation dNSAConfirmation = new ProfilerDialogs.DNSAConfirmation("NetBeansProfiler.handleShutdown", (Object)TAKE_SNAPSHOT_ON_EXIT_MSG, TAKE_SNAPSHOT_ON_EXIT_DIALOG_TITLE, 0);
                dNSAConfirmation.setDNSADefault(false);
                if (ProfilerDialogs.notify((NotifyDescriptor)dNSAConfirmation).equals(ProfilerDialogs.DNSAConfirmation.YES_OPTION)) {
                    ResultsManager.getDefault().takeSnapshot();
                }
            }
        }

        public void pauseLiveUpdates() {
            LiveResultsWindow.setPaused(true);
        }

        public void resultsAvailable() {
            ResultsManager.getDefault().resultsBecameAvailable();
        }

        public void resumeLiveUpdates() {
            LiveResultsWindow.setPaused(false);
        }

        public void takeSnapshot() {
            IDEUtils.runInProfilerRequestProcessor(new Runnable(){

                public void run() {
                    ResultsManager.getDefault().takeSnapshot();
                }
            });
        }
    }

    public static final class ProgressPanel
    implements AppStatusHandler.AsyncDialog {
        private static final int DEFAULT_WIDTH = 350;
        private static final int DEFAULT_HEIGHT = 100;
        private static final RequestProcessor commandQueue = new RequestProcessor("Async dialog command queue", 1);
        private Dialog dialog;
        private final Object dialogStateLock = new Object();
        private DialogState dialogState = DialogState.NOT_OPENED;
        private String message;
        private boolean cancelAllowed;
        private boolean cancelled = false;
        private boolean instantiated;
        private boolean showProgress;

        ProgressPanel(String string, boolean bl, boolean bl2) {
            this.message = string;
            this.showProgress = bl;
            this.cancelAllowed = bl2;
            this.dialogState = DialogState.NOT_OPENED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDisplayed() {
            Object object = this.dialogStateLock;
            synchronized (object) {
                return this.dialogState == DialogState.OPEN;
            }
        }

        public boolean cancelPressed() {
            return this.cancelled;
        }

        public synchronized void close() {
            commandQueue.post(new Runnable(){

                public void run() {
                    ProgressPanel.this.dialogClose();
                }
            });
        }

        public synchronized void display() {
            commandQueue.post(new Runnable(){

                public void run() {
                    ProgressPanel.this.instantiate();
                    ProgressPanel.this.dialogShow();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dialogClose() {
            Object object = this.dialogStateLock;
            synchronized (object) {
                if (this.dialogState == DialogState.OPEN) {
                    LOGGER.finest("Closing async dialog");
                    if (this.dialog.isShowing()) {
                        ProfilerDialogs.close(this.dialog);
                    }
                    this.dialogState = DialogState.CLOSED;
                } else if (this.dialogState == DialogState.NOT_OPENED) {
                    LOGGER.fine("Attempting to close async dialog without opening it first");
                    this.dialogState = DialogState.NOT_OPENED_CLOSED;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dialogShow() {
            Object object = this.dialogStateLock;
            synchronized (object) {
                if (this.dialogState == DialogState.NOT_OPENED || this.dialogState == DialogState.CLOSED) {
                    LOGGER.finest("Showing async dialog");
                    Level level = LOGGER.getLevel();
                    ProfilerDialogs.display(this.dialog);
                    this.dialogState = DialogState.OPEN;
                } else if (this.dialogState == DialogState.NOT_OPENED_CLOSED) {
                    LOGGER.fine("Async dialog has been closed before being opened. Setting to CLOSED");
                    this.dialogState = DialogState.CLOSED;
                }
            }
        }

        private void instantiate() {
            Object[] objectArray;
            if (this.instantiated) {
                return;
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(10, 10));
            jPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
            jPanel.add((Component)new JLabel(this.message), "North");
            Dimension dimension = jPanel.getPreferredSize();
            dimension.setSize(Math.max(dimension.getWidth(), 350.0), Math.max(dimension.getHeight(), this.showProgress ? 100.0 : dimension.getHeight()));
            jPanel.setPreferredSize(dimension);
            if (this.showProgress) {
                JProgressBar jProgressBar = new JProgressBar();
                jProgressBar.setIndeterminate(true);
                jPanel.add((Component)jProgressBar, "South");
            }
            String string = PROGRESS_DIALOG_CAPTION;
            if (this.cancelAllowed) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = DialogDescriptor.CANCEL_OPTION;
            } else {
                objectArray = new Object[]{};
            }
            this.dialog = ProfilerDialogs.createDialog(new DialogDescriptor((Object)jPanel, string, true, objectArray, DialogDescriptor.CANCEL_OPTION, 1, null, new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent actionEvent) {
                    ProgressPanel.this.cancelled = true;
                    Object object = ProgressPanel.this.dialogStateLock;
                    synchronized (object) {
                        assert (ProgressPanel.this.dialogState == DialogState.OPEN);
                        LOGGER.finest("Closing async dialog (cancel)");
                        ProgressPanel.this.dialogState = DialogState.CLOSED;
                    }
                }
            }));
            this.instantiated = true;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum DialogState {
            CLOSED,
            NOT_OPENED,
            NOT_OPENED_CLOSED,
            OPEN;

        }
    }
}

