/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.MemoryDiffPanel;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.openide.actions.FindAction;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public final class SnapshotsDiffWindow
extends TopComponent {
    private static final String ALLOC_CAPTION = NbBundle.getMessage(SnapshotResultsWindow.class, (String)"SnapshotDiffWindow_AllocCaption");
    private static final String LIVENESS_CAPTION = NbBundle.getMessage(SnapshotResultsWindow.class, (String)"SnapshotDiffWindow_LivenessCaption");
    private static final String ALLOC_ACCESS_DESCR = NbBundle.getMessage(SnapshotResultsWindow.class, (String)"SnapshotDiffWindow_AllocAccessDescr");
    private static final String LIVENESS_ACCESS_DESCR = NbBundle.getMessage(SnapshotResultsWindow.class, (String)"SnapshotDiffWindow_LivenessAccessDescr");
    private static final Image WINDOW_ICON_MEMORY = Utilities.loadImage((String)"org/netbeans/modules/profiler/actions/resources/compareSnapshots.png");
    private Component lastFocusOwner;

    public SnapshotsDiffWindow() {
        throw new InternalError("This constructor should never be called");
    }

    public SnapshotsDiffWindow(ResultsSnapshot resultsSnapshot, LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2, int n, boolean bl, Project project) {
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        if (resultsSnapshot instanceof AllocMemoryResultsDiff) {
            this.getAccessibleContext().setAccessibleDescription(ALLOC_ACCESS_DESCR);
            this.displayMemoryAllocDiff((MemoryResultsSnapshot)((AllocMemoryResultsDiff)resultsSnapshot), loadedSnapshot, loadedSnapshot2, n, bl, project);
        } else if (resultsSnapshot instanceof LivenessMemoryResultsDiff) {
            this.getAccessibleContext().setAccessibleDescription(LIVENESS_ACCESS_DESCR);
            this.displayMemoryLivenessDiff((MemoryResultsSnapshot)((LivenessMemoryResultsDiff)resultsSnapshot), loadedSnapshot, loadedSnapshot2, n, bl, project);
        }
    }

    public static synchronized SnapshotsDiffWindow get(ResultsSnapshot resultsSnapshot, LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2) {
        return SnapshotsDiffWindow.get(resultsSnapshot, loadedSnapshot, loadedSnapshot2, -1, false, null);
    }

    public static synchronized SnapshotsDiffWindow get(ResultsSnapshot resultsSnapshot, LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2, int n, boolean bl, Project project) {
        return new SnapshotsDiffWindow(resultsSnapshot, loadedSnapshot, loadedSnapshot2, n, bl, project);
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentActivated() {
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        }
    }

    public void componentDeactivated() {
        this.lastFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void displayMemoryAllocDiff(MemoryResultsSnapshot memoryResultsSnapshot, LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2, int n, boolean bl, Project project) {
        MemoryDiffPanel memoryDiffPanel = new MemoryDiffPanel(memoryResultsSnapshot, loadedSnapshot, loadedSnapshot2, n, bl, project);
        this.updateFind(true, memoryDiffPanel);
        this.add(memoryDiffPanel, "Center");
        this.setName(ALLOC_CAPTION);
        this.setIcon(WINDOW_ICON_MEMORY);
    }

    private void displayMemoryLivenessDiff(MemoryResultsSnapshot memoryResultsSnapshot, LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2, int n, boolean bl, Project project) {
        MemoryDiffPanel memoryDiffPanel = new MemoryDiffPanel(memoryResultsSnapshot, loadedSnapshot, loadedSnapshot2, n, bl, project);
        this.updateFind(true, memoryDiffPanel);
        this.add(memoryDiffPanel, "Center");
        this.setName(LIVENESS_CAPTION);
        this.setIcon(WINDOW_ICON_MEMORY);
    }

    private void updateFind(boolean bl, final SnapshotResultsWindow.FindPerformer findPerformer) {
        CallbackSystemAction callbackSystemAction = (CallbackSystemAction)SystemAction.get(FindAction.class);
        Object object = callbackSystemAction.getActionMapKey();
        if (bl) {
            this.getActionMap().put(object, new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    findPerformer.performFind();
                }
            });
        } else {
            this.getActionMap().remove(object);
        }
    }
}

