/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.categories;

import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.categories.Category;
import org.netbeans.modules.profiler.categories.CategoryContainer;
import org.netbeans.modules.profiler.categories.CustomMarker;
import org.netbeans.modules.profiler.categories.definitions.CustomCategoryDefinition;
import org.netbeans.modules.profiler.categories.definitions.PackageCategoryDefinition;
import org.netbeans.modules.profiler.categories.definitions.SingleTypeCategoryDefinition;
import org.netbeans.modules.profiler.categories.definitions.SubtypeCategoryDefinition;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CategoryBuilder {
    private static final Logger LOGGER = Logger.getLogger(CategoryBuilder.class.getName());
    private static final String CATEGORY_ATTRIB_CUSTOM = "custom";
    private static final String CATEGORY_ATTRIB_EXCLUDES = "excludes";
    private static final String CATEGORY_ATTRIB_INCLUDES = "includes";
    private static final String CATEGORY_ATTRIB_INSTANCENAME = "instanceClass";
    private static final String CATEGORY_ATTRIB_PREFIX = ".";
    private static final String CATEGORY_ATTRIB_SUBTYPES = "subtypes";
    private static final String CATEGORY_ATTRIB_TYPE = "type";
    private static final String CATEGORY_ATTRIB_PACKAGE = "package";
    private static final String SHADOW_SUFFIX = "shadow";
    private String projectType;
    private CategoryContainer rootCategory = null;

    public CategoryBuilder(Project project, String string) {
        this.projectType = string;
    }

    public synchronized Category getRootCategory() {
        if (this.rootCategory == null) {
            this.rootCategory = new CategoryContainer("ROOT", NbBundle.getMessage(CategoryBuilder.class, (String)"ROOT_CATEGORY_NAME"), Mark.DEFAULT);
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource("Projects/" + this.projectType + "/NBProfiler/Categories");
            if (fileObject != null) {
                Enumeration enumeration = fileObject.getChildren(false);
                while (enumeration.hasMoreElements()) {
                    FileObject fileObject2 = (FileObject)enumeration.nextElement();
                    this.processCategories(this.rootCategory, fileObject2);
                }
            }
        }
        return this.rootCategory;
    }

    private void processCategories(CategoryContainer categoryContainer, FileObject fileObject) {
        if (SHADOW_SUFFIX.equals(fileObject.getExt())) {
            String string = (String)fileObject.getAttribute("originalFile");
            try {
                FileObject fileObject2 = fileObject.getFileSystem().findResource(string);
                if (fileObject2 != null) {
                    this.processCategories(categoryContainer, fileObject2);
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                LOGGER.severe("Can not process " + fileObject.getPath());
                LOGGER.throwing(CategoryBuilder.class.getName(), "processCategories", fileStateInvalidException);
            }
        } else if (fileObject.isFolder()) {
            String string = (String)fileObject.getAttribute("SystemFileSystem.localizingBundle");
            String string2 = string != null ? NbBundle.getBundle((String)string).getString(fileObject.getPath()) : fileObject.getName();
            CategoryContainer categoryContainer2 = new CategoryContainer(fileObject.getPath(), string2);
            categoryContainer.add(categoryContainer2);
            Enumeration enumeration = fileObject.getFolders(false);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject3 = (FileObject)enumeration.nextElement();
                String string3 = fileObject3.getName();
                if (string3.startsWith(CATEGORY_ATTRIB_PREFIX)) {
                    int n;
                    String[] stringArray;
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    if (string3.endsWith(CATEGORY_ATTRIB_SUBTYPES)) {
                        object5 = fileObject3.getChildren(false);
                        while (object5.hasMoreElements()) {
                            object4 = (FileObject)object5.nextElement();
                            object3 = (String)object4.getAttribute(CATEGORY_ATTRIB_EXCLUDES);
                            object2 = (String)object4.getAttribute(CATEGORY_ATTRIB_INCLUDES);
                            object = object2 != null ? ((String)object2).split(",") : null;
                            String[] stringArray2 = stringArray = object3 != null ? ((String)object3).split(",") : null;
                            if (object != null) {
                                for (n = 0; n < ((String[])object).length; ++n) {
                                    object[n] = object[n].trim();
                                }
                            }
                            if (stringArray != null) {
                                for (n = 0; n < stringArray.length; ++n) {
                                    stringArray[n] = stringArray[n].trim();
                                }
                            }
                            categoryContainer2.getDefinitions().add(new SubtypeCategoryDefinition(categoryContainer2, object4.getNameExt(), (String[])object, stringArray));
                        }
                        continue;
                    }
                    if (string3.endsWith(CATEGORY_ATTRIB_TYPE)) {
                        object5 = fileObject3.getChildren(false);
                        while (object5.hasMoreElements()) {
                            object4 = (FileObject)object5.nextElement();
                            object3 = (String)object4.getAttribute(CATEGORY_ATTRIB_EXCLUDES);
                            object2 = (String)object4.getAttribute(CATEGORY_ATTRIB_INCLUDES);
                            object = object2 != null ? ((String)object2).split(",") : null;
                            String[] stringArray3 = stringArray = object3 != null ? ((String)object3).split(",") : null;
                            if (object != null) {
                                for (n = 0; n < ((String[])object).length; ++n) {
                                    object[n] = object[n].trim();
                                }
                            }
                            if (stringArray != null) {
                                for (n = 0; n < stringArray.length; ++n) {
                                    stringArray[n] = stringArray[n].trim();
                                }
                            }
                            categoryContainer2.getDefinitions().add(new SingleTypeCategoryDefinition(categoryContainer2, object4.getNameExt(), (String[])object, stringArray));
                        }
                        continue;
                    }
                    if (string3.endsWith(CATEGORY_ATTRIB_CUSTOM)) {
                        object5 = (String)fileObject3.getAttribute(CATEGORY_ATTRIB_INSTANCENAME);
                        if (object5 == null) continue;
                        object4 = null;
                        try {
                            object3 = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                            object2 = ((ClassLoader)object3).loadClass((String)object5);
                            object = (CustomMarker)((Class)object2).getConstructor(Project.class, Mark.class).newInstance(NetBeansProfiler.getDefaultNB().getProfiledProject(), categoryContainer2.getAssignedMark());
                            if (object != null) {
                                categoryContainer2.getDefinitions().add(new CustomCategoryDefinition(categoryContainer2, (Marker)object));
                            }
                        }
                        catch (InstantiationException instantiationException) {
                            object4 = instantiationException;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            object4 = illegalAccessException;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            object4 = illegalArgumentException;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            object4 = invocationTargetException;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            object4 = noSuchMethodException;
                        }
                        catch (SecurityException securityException) {
                            object4 = securityException;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            object4 = classNotFoundException;
                        }
                        if (object4 == null) continue;
                        LOGGER.logp(Level.WARNING, CategoryBuilder.class.getName(), "processCategories", "Error while building profiling results categories", (Throwable)object4);
                        continue;
                    }
                    if (!string3.endsWith(CATEGORY_ATTRIB_PACKAGE)) continue;
                    object5 = fileObject3.getChildren(false);
                    while (object5.hasMoreElements()) {
                        object4 = (FileObject)object5.nextElement();
                        object3 = (Boolean)object4.getAttribute("recursive");
                        categoryContainer2.getDefinitions().add(new PackageCategoryDefinition(categoryContainer2, object4.getNameExt(), object3 != null ? (Boolean)object3 : true));
                    }
                    continue;
                }
                this.processCategories(categoryContainer2, fileObject3);
            }
        }
    }
}

