/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.categories;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.marker.ClassMarker;
import org.netbeans.lib.profiler.marker.CompositeMarker;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.marker.MethodMarker;
import org.netbeans.lib.profiler.marker.PackageMarker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;
import org.netbeans.modules.profiler.AbstractProjectTypeProfiler;
import org.netbeans.modules.profiler.categories.CategoryDefinitionProcessor;
import org.netbeans.modules.profiler.categories.definitions.CustomCategoryDefinition;
import org.netbeans.modules.profiler.categories.definitions.PackageCategoryDefinition;
import org.netbeans.modules.profiler.categories.definitions.SingleTypeCategoryDefinition;
import org.netbeans.modules.profiler.categories.definitions.SubtypeCategoryDefinition;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerProcessor
extends CategoryDefinitionProcessor
implements Marker {
    private static final Logger LOGGER = Logger.getLogger(MarkerProcessor.class.getName());
    private MethodMarker mMarker = new MethodMarker();
    private ClassMarker cMarker = new ClassMarker();
    private PackageMarker pMarker = new PackageMarker();
    private CompositeMarker cmMarker = new CompositeMarker();
    private Project project;

    public MarkerProcessor(Project project) {
        this.project = project;
    }

    @Override
    public void process(SubtypeCategoryDefinition subtypeCategoryDefinition) {
        if (subtypeCategoryDefinition.getExcludes() == null && subtypeCategoryDefinition.getIncludes() == null) {
            this.addInterfaceMarker(this.mMarker, subtypeCategoryDefinition.getTypeName(), subtypeCategoryDefinition.getAssignedMark());
        } else {
            if (subtypeCategoryDefinition.getExcludes() != null) {
                this.addInterfaceMarker(this.mMarker, subtypeCategoryDefinition.getTypeName(), subtypeCategoryDefinition.getExcludes(), false, subtypeCategoryDefinition.getAssignedMark());
            }
            if (subtypeCategoryDefinition.getIncludes() != null) {
                this.addInterfaceMarker(this.mMarker, subtypeCategoryDefinition.getTypeName(), subtypeCategoryDefinition.getIncludes(), true, subtypeCategoryDefinition.getAssignedMark());
            }
        }
    }

    @Override
    public void process(SingleTypeCategoryDefinition singleTypeCategoryDefinition) {
        if (singleTypeCategoryDefinition.getExcludes() == null && singleTypeCategoryDefinition.getIncludes() == null) {
            this.cMarker.addClassMark(singleTypeCategoryDefinition.getTypeName(), singleTypeCategoryDefinition.getAssignedMark());
        } else {
            if (singleTypeCategoryDefinition.getExcludes() != null) {
                this.addTypeMarker(this.mMarker, singleTypeCategoryDefinition.getTypeName(), singleTypeCategoryDefinition.getExcludes(), false, singleTypeCategoryDefinition.getAssignedMark());
            }
            if (singleTypeCategoryDefinition.getIncludes() != null) {
                this.addTypeMarker(this.mMarker, singleTypeCategoryDefinition.getTypeName(), singleTypeCategoryDefinition.getIncludes(), true, singleTypeCategoryDefinition.getAssignedMark());
            }
        }
    }

    @Override
    public void process(CustomCategoryDefinition customCategoryDefinition) {
        this.cmMarker.addMarker(customCategoryDefinition.getCustomMarker());
    }

    @Override
    public void process(PackageCategoryDefinition packageCategoryDefinition) {
        this.pMarker.addPackageMark(packageCategoryDefinition.getPackageName(), packageCategoryDefinition.getAssignedMark(), packageCategoryDefinition.isRecursive());
    }

    public MarkMapping[] getMappings() {
        ArrayList<MarkMapping> arrayList = new ArrayList<MarkMapping>();
        arrayList.addAll(Arrays.asList(this.mMarker.getMappings()));
        arrayList.addAll(Arrays.asList(this.cMarker.getMappings()));
        arrayList.addAll(Arrays.asList(this.pMarker.getMappings()));
        arrayList.addAll(Arrays.asList(this.cmMarker.getMappings()));
        return arrayList.toArray(new MarkMapping[arrayList.size()]);
    }

    public Mark[] getMarks() {
        HashSet<Mark> hashSet = new HashSet<Mark>();
        hashSet.addAll(Arrays.asList(this.mMarker.getMarks()));
        hashSet.addAll(Arrays.asList(this.cMarker.getMarks()));
        hashSet.addAll(Arrays.asList(this.pMarker.getMarks()));
        hashSet.addAll(Arrays.asList(this.cmMarker.getMarks()));
        return hashSet.toArray(new Mark[hashSet.size()]);
    }

    protected void addInterfaceMarker(MethodMarker methodMarker, String string, Mark mark) {
        this.addInterfaceMarker(methodMarker, string, null, false, mark);
    }

    protected void addInterfaceMarker(final MethodMarker methodMarker, final String string, final String[] stringArray, final boolean bl, final Mark mark) {
        ClasspathInfo classpathInfo = ProjectUtilities.getClasspathInfo((Project)this.project, (boolean)true);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    MarkerProcessor.this.doAddInterfaceMarker(methodMarker, string, stringArray, bl, mark, compilationController);
                }
            }, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void addInterfaceMarkers(final MethodMarker methodMarker, final String[] stringArray, final Mark mark) {
        ClasspathInfo classpathInfo = ProjectUtilities.getClasspathInfo((Project)this.project, (boolean)true);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    for (String string : stringArray) {
                        MarkerProcessor.this.doAddInterfaceMarker(methodMarker, string, null, false, mark, compilationController);
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void addInterfaceMarkers(final MethodMarker methodMarker, final String[] stringArray, final String[] stringArray2, final boolean bl, final Mark mark) {
        ClasspathInfo classpathInfo = ProjectUtilities.getClasspathInfo((Project)this.project, (boolean)true);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    for (String string : stringArray) {
                        MarkerProcessor.this.doAddInterfaceMarker(methodMarker, string, stringArray2, bl, mark, compilationController);
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void addTypeMarker(MethodMarker methodMarker, String string, Mark mark) {
        this.addTypeMarker(methodMarker, string, new String[0], false, mark);
    }

    protected void addTypeMarker(final MethodMarker methodMarker, final String string, String[] stringArray, final boolean bl, final Mark mark) {
        final ArrayList arrayList = stringArray != null ? Arrays.asList(stringArray) : new ArrayList();
        ClasspathInfo classpathInfo = ProjectUtilities.getClasspathInfo((Project)this.project, (boolean)true);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                    MarkerProcessor.this.addTypeMethods(methodMarker, typeElement, arrayList, bl, mark, compilationController);
                }
            }, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void addImplementorMethods(MethodMarker methodMarker, TypeElement typeElement, List<String> list, boolean bl, Mark mark, CompilationController compilationController) {
        try {
            HashSet hashSet;
            compilationController.toPhase(JavaSource.Phase.RESOLVED);
            HashSet<ClassIndex.SearchKind> hashSet2 = new HashSet<ClassIndex.SearchKind>(Arrays.asList(ClassIndex.SearchKind.IMPLEMENTORS));
            HashSet<ClassIndex.SearchScope> hashSet3 = new HashSet<ClassIndex.SearchScope>(Arrays.asList(ClassIndex.SearchScope.SOURCE));
            HashSet hashSet4 = new HashSet();
            HashSet hashSet5 = compilationController.getClasspathInfo().getClassIndex().getElements(ElementHandle.create((Element)typeElement), hashSet2, hashSet3);
            do {
                hashSet = new HashSet();
                hashSet4.addAll(hashSet5);
                for (Object object : hashSet5) {
                    hashSet.addAll(compilationController.getClasspathInfo().getClassIndex().getElements(object, hashSet2, hashSet3));
                }
            } while (!(hashSet5 = hashSet).isEmpty());
            for (ElementHandle elementHandle : hashSet4) {
                Object object;
                object = (TypeElement)elementHandle.resolve((CompilationInfo)compilationController);
                this.addTypeMethods(methodMarker, (TypeElement)object, list, bl, mark, compilationController);
            }
        }
        catch (IOException iOException) {
            LOGGER.throwing(AbstractProjectTypeProfiler.class.getName(), "addImplementorMethods", iOException);
        }
    }

    private void addTypeMethods(MethodMarker methodMarker, TypeElement typeElement, List<String> list, boolean bl, Mark mark, CompilationController compilationController) {
        if (methodMarker == null || typeElement == null || list == null || mark == null || compilationController == null) {
            return;
        }
        try {
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                if (executableElement.getKind() != ElementKind.METHOD || executableElement.getModifiers().contains((Object)Modifier.ABSTRACT) || (!bl || !list.contains(executableElement.getSimpleName().toString())) && (bl || list.contains(executableElement.getSimpleName().toString()))) continue;
                try {
                    methodMarker.addMethodMark(ElementUtilities.getBinaryName((TypeElement)typeElement), executableElement.getSimpleName().toString(), SourceUtils.getVMMethodSignature((ExecutableElement)executableElement, (CompilationInfo)compilationController), mark);
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.throwing(AbstractProjectTypeProfiler.class.getName(), "addTypeMethods", iOException);
        }
    }

    private void doAddInterfaceMarker(MethodMarker methodMarker, String string, String[] stringArray, boolean bl, Mark mark, CompilationController compilationController) throws IllegalArgumentException {
        ArrayList<String> arrayList = stringArray != null ? Arrays.asList(stringArray) : new ArrayList<String>();
        TypeElement typeElement = compilationController.getElements().getTypeElement(string);
        if (typeElement == null) {
            LOGGER.fine("Couldn't resolve type: " + string);
            return;
        }
        switch (typeElement.getKind()) {
            case INTERFACE: {
                this.addImplementorMethods(methodMarker, typeElement, arrayList, bl, mark, compilationController);
                break;
            }
            case CLASS: {
                this.addTypeMethods(methodMarker, typeElement, arrayList, bl, mark, compilationController);
                if (typeElement.getModifiers().contains((Object)Modifier.FINAL)) break;
                this.addImplementorMethods(methodMarker, typeElement, arrayList, bl, mark, compilationController);
            }
        }
    }
}

