/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ClassPresenterPanel
extends JPanel {
    private static final String INSTANCES_COUNT_STRING = NbBundle.getMessage(ClassPresenterPanel.class, (String)"ClassPresenterPanel_InstancesCountString");
    private static final String INSTANCE_SIZE_STRING = NbBundle.getMessage(ClassPresenterPanel.class, (String)"ClassPresenterPanel_InstanceSizeString");
    private static final String TOTAL_SIZE_STRING = NbBundle.getMessage(ClassPresenterPanel.class, (String)"ClassPresenterPanel_TotalSizeString");
    private static ImageIcon ICON_CLASS = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/class.png"));
    private HeaderRenderer headerRenderer;
    private JLabel detailsRenderer;

    public ClassPresenterPanel() {
        this.initComponents();
    }

    public void setJavaClass(JavaClass javaClass) {
        if (javaClass != null) {
            String string = javaClass.getName();
            String string2 = MessageFormat.format(INSTANCES_COUNT_STRING, javaClass.getInstancesCount());
            String string3 = javaClass.getInstanceSize() != -1 ? "  |  " + MessageFormat.format(INSTANCE_SIZE_STRING, javaClass.getInstanceSize()) : "";
            String string4 = javaClass.getAllInstancesSize() != -1 ? "  |  " + MessageFormat.format(TOTAL_SIZE_STRING, javaClass.getAllInstancesSize()) : "";
            String string5 = javaClass.isArray() ? string2 + string4 : string2 + string3 + string4;
            this.headerRenderer.setText(string);
            this.detailsRenderer.setText(string5);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getLookAndFeel().getID().equals("Metal") ? UIManager.getColor("Button.darkShadow") : UIManager.getColor("Button.shadow")), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.setOpaque(true);
        this.setBackground(new Color(245, 245, 245));
        this.headerRenderer = new HeaderRenderer();
        this.headerRenderer.setIcon(ICON_CLASS);
        this.headerRenderer.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.headerRenderer.setFont(UIManager.getFont("ToolTip.font"));
        this.headerRenderer.setOpaque(false);
        this.detailsRenderer = new JLabel();
        this.detailsRenderer.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.detailsRenderer.setFont(UIManager.getFont("ToolTip.font"));
        this.detailsRenderer.setOpaque(false);
        this.add((Component)this.headerRenderer, "West");
        this.add((Component)this.detailsRenderer, "East");
    }

    private class HeaderRenderer
    extends JLabel {
        private HeaderRenderer() {
        }

        public Dimension getMinimumSize() {
            return new Dimension(0, super.getMinimumSize().height);
        }

        public void setText(String string) {
            int n = string.lastIndexOf(".");
            if (n == -1) {
                super.setText(string);
            } else {
                String string2 = "<html>" + string.substring(0, ++n) + "<b>" + string.substring(n) + "</b>" + "</html>";
                super.setText(string2);
            }
        }
    }
}

