/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.ppoints.ui.ValidityListener;
import org.netbeans.modules.profiler.ppoints.ui.WizardPanel1UI;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ProfilingPointWizard
implements WizardDescriptor.Iterator {
    private static final String ANOTHER_PP_EDITED_MSG = NbBundle.getMessage(ProfilingPointWizard.class, (String)"ProfilingPointWizard_AnotherPpEditedMsg");
    private static final String NO_PPS_FOUND_MSG = NbBundle.getMessage(ProfilingPointWizard.class, (String)"ProfilingPointWizard_NoPpsFoundMsg");
    private static final String WIZARD_TITLE = NbBundle.getMessage(ProfilingPointWizard.class, (String)"ProfilingPointWizard_WizardTitle");
    private static final String WIZARD_STEP1_CAPTION = NbBundle.getMessage(ProfilingPointWizard.class, (String)"ProfilingPointWizard_WizardStep1Caption");
    private static final String WIZARD_STEP2_CAPTION = NbBundle.getMessage(ProfilingPointWizard.class, (String)"ProfilingPointWizard_WizardStep2Caption");
    private static ProfilingPointWizard defaultInstance;
    private static final Dimension DEFAULT_PREFERRED_PANEL_SIZE;
    private Dimension preferredPanelSize = null;
    private ProfilingPoint profilingPoint;
    private Project selectedProject;
    private WizardDescriptor wizardDescriptor;
    private ProfilingPointFactory[] ppFactories;
    private WizardPanel[] wizardPanels;
    private String[] wizardSteps;
    private boolean settingsChanged;
    private int currentPanel;
    private int selectedPPFactoryIndex;

    private ProfilingPointWizard() {
    }

    public static ProfilingPointWizard getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ProfilingPointWizard();
        }
        return defaultInstance;
    }

    public WizardDescriptor getWizardDescriptor() {
        return this.getWizardDescriptor(null);
    }

    public WizardDescriptor getWizardDescriptor(Project project) {
        ValidityAwarePanel validityAwarePanel = ProfilingPointsManager.getDefault().getShowingCustomizer();
        if (validityAwarePanel != null) {
            NetBeansProfiler.getDefaultNB().displayWarningAndWait(ANOTHER_PP_EDITED_MSG);
            SwingUtilities.getWindowAncestor(validityAwarePanel).requestFocus();
            validityAwarePanel.requestFocusInWindow();
            return null;
        }
        this.settingsChanged = true;
        this.currentPanel = 0;
        this.selectedPPFactoryIndex = 0;
        this.selectedProject = project;
        this.initWizardDescriptor();
        this.initWizardPanels();
        if (this.ppFactories.length > 0) {
            this.getCurrentWizardPanel().showing();
            return this.wizardDescriptor;
        }
        NetBeansProfiler.getDefaultNB().displayError(NO_PPS_FOUND_MSG);
        return null;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
    }

    public WizardDescriptor.Panel current() {
        return this.getCurrentWizardPanel();
    }

    public ProfilingPoint finish() {
        ProfilingPoint profilingPoint = this.profilingPoint;
        if (this.wizardPanels != null) {
            this.wizardPanels[this.currentPanel].hiding();
            for (int i = 0; i < this.wizardPanels.length; ++i) {
                this.wizardPanels[i].notifyClosed();
            }
            this.preferredPanelSize = this.wizardPanels[this.currentPanel].getComponent().getSize();
        }
        return profilingPoint;
    }

    public boolean hasNext() {
        return this.currentPanel < this.wizardSteps.length - 1;
    }

    public boolean hasPrevious() {
        return this.currentPanel > 0;
    }

    public String name() {
        return this.getCurrentWizardPanel().getName();
    }

    public void nextPanel() {
        this.getCurrentWizardPanel().hiding();
        this.wizardDescriptor.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(++this.currentPanel));
        this.getCurrentWizardPanel().showing();
    }

    public void previousPanel() {
        this.getCurrentWizardPanel().hiding();
        this.wizardDescriptor.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(--this.currentPanel));
        this.getCurrentWizardPanel().showing();
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
    }

    private WizardPanel getCurrentWizardPanel() {
        return this.wizardPanels[this.currentPanel];
    }

    private void initWizardDescriptor() {
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this);
        this.wizardDescriptor.setTitle(WIZARD_TITLE);
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.wizardDescriptor.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
        this.wizardDescriptor.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
        this.wizardDescriptor.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
        this.wizardDescriptor.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(0));
    }

    private void initWizardPanels() {
        this.ppFactories = ProfilingPointsManager.getDefault().getProfilingPointFactories();
        this.wizardPanels = new WizardPanel[]{new WizardPanel1(), new WizardPanel2()};
        this.wizardSteps = new String[this.wizardPanels.length];
        for (int i = 0; i < this.wizardPanels.length; ++i) {
            this.wizardSteps[i] = this.wizardPanels[i].getName();
        }
        this.wizardDescriptor.putProperty("WizardPanel_contentData", (Object)this.wizardSteps);
        if (this.preferredPanelSize == null) {
            this.preferredPanelSize = new Dimension(DEFAULT_PREFERRED_PANEL_SIZE);
            Dimension dimension = ((WizardPanel1UI)this.wizardPanels[0].getComponent()).getMinSize();
            this.preferredPanelSize.width = Math.max(this.preferredPanelSize.width, dimension.width);
            this.preferredPanelSize.height = Math.max(this.preferredPanelSize.height, dimension.height);
        }
    }

    static {
        DEFAULT_PREFERRED_PANEL_SIZE = new Dimension(440, 330);
    }

    private abstract class WizardPanel
    implements WizardDescriptor.Panel,
    ValidityListener {
        protected boolean valid = true;
        private Component component;
        private EventListenerList listenerList = new EventListenerList();

        private WizardPanel() {
        }

        public abstract String getName();

        public Component getComponent() {
            if (this.component == null) {
                this.component = this.createComponent();
                this.component.setName(this.getName());
                this.component.setPreferredSize(ProfilingPointWizard.this.preferredPanelSize);
            }
            return this.component;
        }

        public void setValid(boolean bl) {
            if (this.valid != bl) {
                this.valid = bl;
                this.fireChangeListenerStateChanged(this);
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        public abstract Component createComponent();

        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.listenerList.add(ChangeListener.class, changeListener);
        }

        public void hiding() {
        }

        public void notifyClosed() {
        }

        public void readSettings(Object object) {
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.listenerList.remove(ChangeListener.class, changeListener);
        }

        public void showing() {
        }

        public void storeSettings(Object object) {
        }

        public void validityChanged(boolean bl) {
            this.setValid(bl);
        }

        protected void fireChangeListenerStateChanged(Object object) {
            ChangeEvent changeEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ChangeListener.class) continue;
                if (changeEvent == null) {
                    changeEvent = new ChangeEvent(object);
                }
                ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
            }
        }
    }

    class WizardPanel2
    extends WizardPanel {
        private ValidityAwarePanel customizer;

        WizardPanel2() {
        }

        public HelpCtx getHelp() {
            if (this.customizer == null || !(this.customizer instanceof HelpCtx.Provider)) {
                return null;
            }
            return ((HelpCtx.Provider)this.customizer).getHelpCtx();
        }

        public String getName() {
            return WIZARD_STEP2_CAPTION;
        }

        public Component createComponent() {
            JScrollPane jScrollPane = new JScrollPane(20, 30);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            jScrollPane.setOpaque(false);
            jScrollPane.getViewport().setOpaque(false);
            return jScrollPane;
        }

        public void hiding() {
            if (ProfilingPointWizard.this.profilingPoint != null && this.customizer != null) {
                ProfilingPointWizard.this.profilingPoint.setValues(this.customizer);
            }
            this.unregisterCustomizerListener();
        }

        public void notifyClosed() {
            this.releaseCurrentCustomizer();
            ProfilingPointWizard.this.profilingPoint = null;
        }

        public void showing() {
            if (this.customizer == null || ProfilingPointWizard.this.settingsChanged) {
                this.releaseCurrentCustomizer();
                this.createNewCustomizer();
                ProfilingPointWizard.this.settingsChanged = false;
            }
            this.setValid(this.customizer.areSettingsValid());
            this.registerCustomizerListener();
        }

        private void createNewCustomizer() {
            ProfilingPointWizard.this.profilingPoint = ProfilingPointWizard.this.ppFactories[ProfilingPointWizard.this.selectedPPFactoryIndex].create(ProfilingPointWizard.this.selectedProject);
            this.customizer = ProfilingPointWizard.this.profilingPoint.getCustomizer();
            ((JScrollPane)this.getComponent()).setViewportView(this.customizer);
        }

        private void registerCustomizerListener() {
            if (this.customizer != null) {
                this.customizer.addValidityListener(this);
            }
        }

        private void releaseCurrentCustomizer() {
            ((JScrollPane)this.getComponent()).setViewportView(null);
            this.customizer = null;
        }

        private void unregisterCustomizerListener() {
            if (this.customizer != null) {
                this.customizer.removeValidityListener(this);
            }
        }
    }

    class WizardPanel1
    extends WizardPanel {
        private Project selectedProjectRef;
        private int selectedPPFactoryIndexRef;

        WizardPanel1() {
        }

        public HelpCtx getHelp() {
            Component component = this.getComponent();
            if (component == null || !(component instanceof HelpCtx.Provider)) {
                return null;
            }
            return ((HelpCtx.Provider)component).getHelpCtx();
        }

        public String getName() {
            return WIZARD_STEP1_CAPTION;
        }

        public Component createComponent() {
            WizardPanel1UI wizardPanel1UI = new WizardPanel1UI();
            wizardPanel1UI.addValidityListener(this);
            wizardPanel1UI.init(ProfilingPointWizard.this.ppFactories);
            this.setValid(wizardPanel1UI.areSettingsValid());
            return wizardPanel1UI;
        }

        public void hiding() {
            ProfilingPointWizard.this.selectedPPFactoryIndex = ((WizardPanel1UI)this.getComponent()).getSelectedIndex();
            if (ProfilingPointWizard.this.selectedPPFactoryIndex != this.selectedPPFactoryIndexRef) {
                ProfilingPointWizard.this.settingsChanged = true;
            }
            ProfilingPointWizard.this.selectedProject = ((WizardPanel1UI)this.getComponent()).getSelectedProject();
            if (ProfilingPointWizard.this.selectedProject == null || !ProfilingPointWizard.this.selectedProject.equals(this.selectedProjectRef)) {
                ProfilingPointWizard.this.settingsChanged = true;
            }
        }

        public void showing() {
            this.selectedPPFactoryIndexRef = ProfilingPointWizard.this.selectedPPFactoryIndex;
            ((WizardPanel1UI)this.getComponent()).setSelectedIndex(ProfilingPointWizard.this.selectedPPFactoryIndex);
            this.selectedProjectRef = ProfilingPointWizard.this.selectedProject;
            if (ProfilingPointWizard.this.selectedProject == null) {
                ProfilingPointWizard.this.selectedProject = Utils.getCurrentProject();
            }
            ((WizardPanel1UI)this.getComponent()).setSelectedProject(ProfilingPointWizard.this.selectedProject);
        }
    }
}

