/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ui.LocationCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.SnapshotCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.ppoints.ui.ValidityListener;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class TakeSnapshotCustomizer
extends ValidityAwarePanel
implements DocumentListener,
ValidityListener,
HelpCtx.Provider {
    private static final String NAME_LABEL_TEXT = NbBundle.getMessage(TakeSnapshotCustomizer.class, (String)"TakeSnapshotCustomizer_NameLabelText");
    private static final String SETTINGS_LABEL_TEXT = NbBundle.getMessage(TakeSnapshotCustomizer.class, (String)"TakeSnapshotCustomizer_SettingsLabelText");
    private static final String LOCATION_LABEL_TEXT = NbBundle.getMessage(TakeSnapshotCustomizer.class, (String)"TakeSnapshotCustomizer_LocationLabelText");
    private static final String HELP_CTX_KEY = "TakeSnapshotCustomizer.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("TakeSnapshotCustomizer.HelpCtx");
    private static int defaultTextComponentHeight = -1;
    private JLabel captionLabel;
    private JLabel locationHeaderLabel;
    private JLabel nameLabel;
    private JLabel settingsHeaderLabel;
    private JPanel captionPanel;
    private JPanel firstLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JSeparator locationHeaderSeparator;
    private JSeparator settingsHeaderSeparator;
    private JTextField nameTextField;
    private LocationCustomizer locationCustomizer;
    private SnapshotCustomizer snapshotCustomizer;

    public TakeSnapshotCustomizer(String string, Icon icon) {
        this.initComponents(string, icon);
        this.normalizeCaptionAreaWidth();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public Component getInitialFocusTarget() {
        return this.nameTextField;
    }

    public void setPPFile(String string) {
        this.snapshotCustomizer.setPPFile(string);
    }

    public String getPPFile() {
        return this.snapshotCustomizer.getPPFile();
    }

    public void setPPLocation(CodeProfilingPoint.Location location) {
        this.locationCustomizer.setPPLocation(location);
    }

    public CodeProfilingPoint.Location getPPLocation() {
        return this.locationCustomizer.getPPLocation();
    }

    public void setPPName(String string) {
        this.nameTextField.setText(string);
    }

    public String getPPName() {
        return this.nameTextField.getText();
    }

    public void setPPResetResults(boolean bl) {
        this.snapshotCustomizer.setPPResetResults(bl);
    }

    public boolean getPPResetResults() {
        return this.snapshotCustomizer.getPPResetResults();
    }

    public void setPPTarget(boolean bl) {
        this.snapshotCustomizer.setPPTarget(bl);
    }

    public boolean getPPTarget() {
        return this.snapshotCustomizer.getPPTarget();
    }

    public void setPPType(boolean bl) {
        this.snapshotCustomizer.setPPType(bl);
    }

    public boolean getPPType() {
        return this.snapshotCustomizer.getPPType();
    }

    public int getPreferredCaptionAreaWidth() {
        int n = this.nameLabel.getPreferredSize().width - 12;
        return Math.max(n, this.locationCustomizer.getPreferredCaptionAreaWidth());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public void initComponents(String string, Icon icon) {
        this.setLayout(new GridBagLayout());
        this.captionPanel = new JPanel(new BorderLayout(0, 0));
        this.captionPanel.setOpaque(true);
        this.captionPanel.setBackground(UIUtils.getProfilerResultsBackground());
        this.captionLabel = new JLabel(string, icon, 10);
        this.captionLabel.setFont(this.captionLabel.getFont().deriveFont(1));
        this.captionLabel.setOpaque(false);
        this.captionLabel.setBorder(BorderFactory.createEmptyBorder(6, 8, 6, 6));
        this.captionPanel.add((Component)this.captionLabel, "West");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 16, 0);
        this.add((Component)this.captionPanel, gridBagConstraints);
        this.nameLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NAME_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 8, 10, 5);
        this.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.firstLineCaptionSpacer, gridBagConstraints);
        this.nameTextField = new JTextField(""){

            public Dimension getPreferredSize() {
                return TakeSnapshotCustomizer.this.getParent() instanceof JViewport ? this.getMinimumSize() : new Dimension(400, super.getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, super.getPreferredSize().height);
            }
        };
        this.nameLabel.setLabelFor(this.nameTextField);
        this.nameTextField.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 13);
        this.add((Component)this.nameTextField, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.settingsHeaderLabel = new JLabel(SETTINGS_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.settingsHeaderLabel, gridBagConstraints);
        this.settingsHeaderSeparator = new JSeparator(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.settingsHeaderSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 5, 8);
        this.add((Component)jPanel, gridBagConstraints);
        this.snapshotCustomizer = new SnapshotCustomizer();
        this.snapshotCustomizer.addValidityListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 12, 13);
        this.add((Component)this.snapshotCustomizer, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.locationHeaderLabel = new JLabel(LOCATION_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel2.add((Component)this.locationHeaderLabel, gridBagConstraints);
        this.locationHeaderSeparator = new JSeparator(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this.locationHeaderSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 5, 8);
        this.add((Component)jPanel2, gridBagConstraints);
        this.locationCustomizer = new LocationCustomizer();
        this.locationCustomizer.addValidityListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 12, 13);
        this.add((Component)this.locationCustomizer, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new FlowLayout(3, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jPanel3, gridBagConstraints);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TakeSnapshotCustomizer takeSnapshotCustomizer = new TakeSnapshotCustomizer("Take Snapshot", null);
        takeSnapshotCustomizer.addValidityListener(new ValidityListener(){

            public void validityChanged(boolean bl) {
                System.err.println(">>> Validity changed to " + bl);
            }
        });
        JFrame jFrame = new JFrame("Customize Profiling Point");
        jFrame.getContentPane().add(takeSnapshotCustomizer);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void normalizeCaptionAreaWidth() {
        int n = this.nameLabel.getPreferredSize().width - 12;
        int n2 = this.getPreferredCaptionAreaWidth() - n;
        int n3 = n2 > 0 ? n2 : 0;
        this.firstLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, n3, 0, 0));
        this.locationCustomizer.normalizeCaptionAreaWidth(this.getPreferredCaptionAreaWidth());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public void validityChanged(boolean bl) {
        this.updateValidity();
    }

    private boolean isNameEmpty() {
        return this.nameTextField.getText().trim().length() == 0;
    }

    private void updateValidity() {
        boolean bl;
        boolean bl2 = bl = !this.isNameEmpty() && this.snapshotCustomizer.areSettingsValid() && this.locationCustomizer.areSettingsValid();
        if (bl != this.areSettingsValid()) {
            this.fireValidityChanged(bl);
        }
    }
}

