/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.jps.JpsProxy;
import org.netbeans.lib.profiler.jps.RunningVM;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

public final class PIDSelectPanel
extends JPanel
implements ActionListener {
    private static final String REFRESH_BUTTON_NAME = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_RefreshButtonName");
    private static final String PID_LABEL_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_PidLabelText");
    private static final String MAIN_CLASS_LABEL_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_MainClassLabelText");
    private static final String ARGUMENTS_LABEL_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_ArgumentsLabelText");
    private static final String VM_ARGUMENTS_LABEL_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_VmArgumentsLabelText");
    private static final String VM_FLAGS_LABEL_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_VmFlagsLabelText");
    private static final String VM_COMBO_ITEM_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_VmComboItemText");
    private static final String PROCESSES_LIST_ITEM_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_ProcessesListItemText");
    private static final String ERROR_GETTING_PROCESSES_ITEM_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_ErrorGettingProcessesItemText");
    private static final String NO_PROCESSES_ITEM_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_NoProcessesItemText");
    private static final String SELECT_PROCESS_ITEM_TEXT = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_SelectProcessItemText");
    private static final String OK_BUTTON_NAME = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_OkButtonName");
    private static final String SELECT_PROCESS_DIALOG_CAPTION = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_SelectProcessDialogCaption");
    private static final String COMBO_ACCESS_NAME = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_ComboAccessName");
    private static final String COMBO_ACCESS_DESCR = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_ComboAccessDescr");
    private static final String BUTTON_ACCESS_DESCR = NbBundle.getMessage(PIDSelectPanel.class, (String)"PIDSelectPanel_ButtonAccessDescr");
    private static final int MAX_WIDTH = 500;
    private JButton button;
    private JButton okButton;
    private JComboBox combo;
    private JLabel argumentsLabel;
    private JLabel mainClassLabel;
    private JLabel pidLabel;
    private JLabel vmArgumentsLabel;
    private JLabel vmFlagsLabel;

    public PIDSelectPanel(JButton jButton) {
        this.okButton = jButton;
        this.combo = new JComboBox();
        this.button = new JButton(REFRESH_BUTTON_NAME);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(3, 5, 0, 5);
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.anchor = 17;
        JLabel jLabel = new JLabel(PID_LABEL_TEXT);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.pidLabel = new JLabel();
        jPanel.add((Component)this.pidLabel, gridBagConstraints2);
        jLabel = new JLabel(MAIN_CLASS_LABEL_TEXT);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.mainClassLabel = new JLabel();
        jPanel.add((Component)this.mainClassLabel, gridBagConstraints2);
        jLabel = new JLabel(ARGUMENTS_LABEL_TEXT);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.argumentsLabel = new JLabel();
        jPanel.add((Component)this.argumentsLabel, gridBagConstraints2);
        jLabel = new JLabel(VM_ARGUMENTS_LABEL_TEXT);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.vmArgumentsLabel = new JLabel();
        jPanel.add((Component)this.vmArgumentsLabel, gridBagConstraints2);
        jLabel = new JLabel(VM_FLAGS_LABEL_TEXT);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.vmFlagsLabel = new JLabel();
        jPanel.add((Component)this.vmFlagsLabel, gridBagConstraints2);
        this.combo.setRenderer(new PIDComboRenderer());
        this.combo.getAccessibleContext().setAccessibleName(COMBO_ACCESS_NAME);
        this.combo.getAccessibleContext().setAccessibleDescription(COMBO_ACCESS_DESCR);
        this.button.getAccessibleContext().setAccessibleDescription(BUTTON_ACCESS_DESCR);
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new BorderLayout(0, 10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 0));
        jPanel2.add((Component)this.combo, "Center");
        jPanel2.add((Component)this.button, "East");
        this.add((Component)jPanel2, "North");
        this.add((Component)jPanel, "Center");
        jButton.setEnabled(false);
        this.refreshCombo();
        this.button.addActionListener(this);
        this.combo.addActionListener(this);
    }

    public int getPID() {
        Object object = this.combo.getSelectedItem();
        if (object != null && object instanceof RunningVM) {
            return ((RunningVM)object).getPid();
        }
        return -1;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(dimension.width, 500), dimension.height);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.button) {
            this.refreshCombo();
        } else if (actionEvent.getSource() == this.combo) {
            this.okButton.setEnabled(this.combo.getSelectedItem() instanceof RunningVM);
            this.updateInfo();
        }
    }

    public static int selectPID() {
        JButton jButton = new JButton(OK_BUTTON_NAME);
        PIDSelectPanel pIDSelectPanel = new PIDSelectPanel(jButton);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)pIDSelectPanel, SELECT_PROCESS_DIALOG_CAPTION, true, new Object[]{jButton, DialogDescriptor.CANCEL_OPTION}, (Object)jButton, 0, null, null);
        Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == jButton) {
            return pIDSelectPanel.getPID();
        }
        return -1;
    }

    private void refreshCombo() {
        this.okButton.setEnabled(false);
        this.combo.setEnabled(false);
        this.combo.setModel(new DefaultComboBoxModel<Object>(new Object[]{PROCESSES_LIST_ITEM_TEXT}));
        new NBSwingWorker(){
            private RunningVM[] vms = JpsProxy.getRunningVMs();
            private Object[] ar = new Object[(this.vms == null ? 0 : this.vms.length) + 1];

            protected void doInBackground() {
                if (this.vms == null) {
                    this.ar[0] = ERROR_GETTING_PROCESSES_ITEM_TEXT;
                } else if (this.vms.length == 0) {
                    this.ar[0] = NO_PROCESSES_ITEM_TEXT;
                } else {
                    this.ar[0] = SELECT_PROCESS_ITEM_TEXT;
                    System.arraycopy(this.vms, 0, this.ar, 1, this.vms.length);
                }
            }

            protected void done() {
                PIDSelectPanel.this.combo.setEnabled(true);
                PIDSelectPanel.this.combo.setModel(new DefaultComboBoxModel<Object>(this.ar));
                PIDSelectPanel.this.updateInfo();
            }
        }.execute();
    }

    private void updateInfo() {
        Object object = this.combo.getSelectedItem();
        if (object != null && object instanceof RunningVM) {
            RunningVM runningVM = (RunningVM)object;
            this.pidLabel.setText("" + runningVM.getPid());
            this.mainClassLabel.setText(runningVM.getMainClass());
            this.argumentsLabel.setText(runningVM.getMainArgs());
            this.vmArgumentsLabel.setText(runningVM.getVMArgs());
            this.vmFlagsLabel.setText(runningVM.getVMFlags());
        } else {
            this.pidLabel.setText("");
            this.mainClassLabel.setText("");
            this.argumentsLabel.setText("");
            this.vmArgumentsLabel.setText("");
            this.vmFlagsLabel.setText("");
        }
    }

    private static class PIDComboRenderer
    extends DefaultListCellRenderer {
        private PIDComboRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof RunningVM) {
                RunningVM runningVM = (RunningVM)object;
                String string = runningVM.getMainArgs();
                string = string == null ? "" : " " + string;
                String string2 = MessageFormat.format(VM_COMBO_ITEM_TEXT, runningVM.getMainClass(), "" + runningVM.getPid());
                return super.getListCellRendererComponent((JList<?>)jList, string2, n, bl, bl2);
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }
}

