/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PreferredInstrFilterPanel
extends JPanel {
    private static final String TO_QUICKFILTER_STRING = NbBundle.getMessage(PreferredInstrFilterPanel.class, (String)"PreferredInstrFilterPanel_ToQuickFilterString");
    private static final String TO_QUICKFILTER_ACCESS_DESCR = NbBundle.getMessage(PreferredInstrFilterPanel.class, (String)"PreferredInstrFilterPanel_ToQuickFilterAccessDescr");
    private static final String CLOSE_BUTTON_STRING = NbBundle.getMessage(PreferredInstrFilterPanel.class, (String)"PreferredInstrFilterPanel_CloseButtonString");
    private static final String PREFERRED_PACKAGES_CAPTION = NbBundle.getMessage(PreferredInstrFilterPanel.class, (String)"PreferredInstrFilterPanel_PreferredPackagesCaption");
    private static final String COMPUTING_FILTER_STRING = NbBundle.getMessage(PreferredInstrFilterPanel.class, (String)"PreferredInstrFilterPanel_ComputingFilterString");
    private static PreferredInstrFilterPanel defaultInstance;
    public JButton CLOSE_BUTTON;
    public JButton OPEN_IN_QUICKFILTER_BUTTON;
    private HTMLTextArea packagesArea;
    private JLabel label;

    private PreferredInstrFilterPanel() {
        this.initComponents();
    }

    public static PreferredInstrFilterPanel getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new PreferredInstrFilterPanel();
        }
        return defaultInstance;
    }

    public void init(final FilterResolver filterResolver) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PreferredInstrFilterPanel.this.OPEN_IN_QUICKFILTER_BUTTON.setEnabled(false);
                PreferredInstrFilterPanel.this.packagesArea.setText(COMPUTING_FILTER_STRING);
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        String[] stringArray = filterResolver.getFilterValues();
                        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
                        for (String string : stringArray) {
                            arrayList.add(string);
                        }
                        Collections.sort(arrayList);
                        final StringBuffer stringBuffer = new StringBuffer(stringArray.length);
                        Iterator iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            stringBuffer.append((String)iterator.next());
                            if (!iterator.hasNext()) continue;
                            stringBuffer.append("<br>");
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                PreferredInstrFilterPanel.this.packagesArea.setText(stringBuffer.toString());
                                PreferredInstrFilterPanel.this.packagesArea.setCaretPosition(0);
                                PreferredInstrFilterPanel.this.OPEN_IN_QUICKFILTER_BUTTON.setEnabled(true);
                            }
                        });
                    }
                });
            }
        });
    }

    private void initComponents() {
        this.OPEN_IN_QUICKFILTER_BUTTON = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.OPEN_IN_QUICKFILTER_BUTTON, (String)TO_QUICKFILTER_STRING);
        this.OPEN_IN_QUICKFILTER_BUTTON.getAccessibleContext().setAccessibleDescription(TO_QUICKFILTER_ACCESS_DESCR);
        this.CLOSE_BUTTON = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.CLOSE_BUTTON, (String)CLOSE_BUTTON_STRING);
        this.label = new JLabel();
        this.packagesArea = new HTMLTextArea();
        this.setLayout(new GridBagLayout());
        this.label.setLabelFor((Component)this.packagesArea);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)PREFERRED_PACKAGES_CAPTION);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(15, 10, 5, 10);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.label, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(350, 200));
        this.packagesArea.setText("");
        jScrollPane.setViewportView((Component)this.packagesArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    public static abstract class FilterResolver {
        private String[] filterValues;

        public synchronized String[] getFilterValues() {
            if (this.filterValues == null) {
                this.filterValues = this.computeFilterValues();
            }
            return this.filterValues;
        }

        protected abstract String[] computeFilterValues();
    }
}

