/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stats.drilldown;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.lib.profiler.results.cpu.cct.TimeCollector;
import org.netbeans.modules.profiler.categories.Categorization;
import org.netbeans.modules.profiler.categories.Category;
import org.netbeans.modules.profiler.categories.CategoryLeaf;
import org.netbeans.modules.profiler.ui.stats.drilldown.DrillDownListener;
import org.netbeans.modules.profiler.utilities.Visitable;
import org.netbeans.modules.profiler.utilities.Visitor;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrillDown
implements CCTResultsFilter.Evaluator {
    private static final String SELF_CATEGORY_ID = "SELF_CATEGORY";
    private final List<Category> ddPath = new ArrayList<Category>(5);
    private final ProfilerClient client;
    private final Set listeners = Collections.synchronizedSet(new HashSet());
    private final boolean secondTime;
    private final boolean validFlag;
    private Category currentCategory;
    private Categorization categorization;
    private final List<Category> subCategories = new ArrayList<Category>();

    public DrillDown(Categorization categorization, ProfilerClient profilerClient, boolean bl) {
        this.secondTime = bl;
        this.client = profilerClient;
        this.categorization = categorization;
        if (this.categorization == null) {
            this.validFlag = false;
        } else {
            this.reset();
            this.validFlag = !this.categorization.getRoot().getSubcategories().isEmpty();
        }
    }

    public DrillDown(Categorization categorization, ProfilerClient profilerClient) {
        this(categorization, profilerClient, false);
    }

    public boolean isCurrent(Category category) {
        return this.currentCategory.equals(category);
    }

    public Category getCurrentCategory() {
        return this.currentCategory != null ? this.currentCategory : null;
    }

    public long getCurrentTime(boolean bl) {
        return this.getCategoryTime(this.currentCategory, bl);
    }

    public List<Category> getDrillDownPath() {
        ArrayList<Category> arrayList = new ArrayList<Category>(this.ddPath);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCategoryTime(Category category, boolean bl) {
        TimeCollector timeCollector = (TimeCollector)Lookup.getDefault().lookup(TimeCollector.class);
        TimeTouple timeTouple = null;
        try {
            long l;
            timeCollector.beginTrans(false);
            if (bl || category.getId().equals(SELF_CATEGORY_ID)) {
                timeTouple = new TimeTouple(timeCollector.getNetTime0(category.getAssignedMark()), timeCollector.getNetTime1(category.getAssignedMark()));
            } else {
                l = 0L;
                long l2 = 0L;
                for (Mark mark : this.categorization.getAllMarks(category)) {
                    l += timeCollector.getNetTime0(mark);
                    l2 += timeCollector.getNetTime1(mark);
                }
                timeTouple = new TimeTouple(l, l2);
            }
            l = timeTouple != null ? (this.secondTime ? timeTouple.time1 : timeTouple.time0) : 0L;
            return l;
        }
        finally {
            timeCollector.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Category> getSubCategories() {
        List<Category> list = this.subCategories;
        synchronized (list) {
            return new ArrayList<Category>(this.subCategories);
        }
    }

    public Category getTopCategory() {
        return this.categorization.getRoot();
    }

    public long getTopTime(boolean bl) {
        return this.getCategoryTime(this.getTopCategory(), bl);
    }

    public boolean isValid() {
        return this.validFlag;
    }

    public void addListener(DrillDownListener drillDownListener) {
        this.listeners.add(drillDownListener);
    }

    public boolean canDrilldown(Category category) {
        if (this.getCurrentCategory().getId().equals(SELF_CATEGORY_ID)) {
            return false;
        }
        return this.getSubCategories().size() > 1;
    }

    public void drilldown(String string) {
        for (Category category : this.subCategories) {
            if (!category.getId().equals(string)) continue;
            if (!this.canDrilldown(category)) break;
            this.currentCategory = category;
            this.ddPath.add(this.currentCategory);
            this.updateSubCategories();
            this.fireDrillDownChange();
            break;
        }
    }

    public void drillup() {
        if (this.ddPath.size() == 1) {
            return;
        }
        this.ddPath.remove(this.ddPath.size() - 1);
        this.currentCategory = this.ddPath.get(this.ddPath.size() - 1);
        this.updateSubCategories();
        this.fireDrillDownChange();
    }

    public void drillup(String string) {
        boolean bl = false;
        ArrayList<Category> arrayList = new ArrayList<Category>();
        for (Category category : this.ddPath) {
            if (!bl) {
                if (!category.getId().equals(string)) continue;
                this.currentCategory = category;
                bl = true;
                continue;
            }
            arrayList.add(category);
        }
        if (bl) {
            this.ddPath.removeAll(arrayList);
            this.updateSubCategories();
            this.fireDrillDownChange();
        }
    }

    public boolean evaluate(Mark mark) {
        if (this.currentCategory == null || this.currentCategory.getAssignedMark() == Mark.DEFAULT && this.currentCategory.getSubcategories().size() > 1) {
            return true;
        }
        Boolean bl = (Boolean)this.currentCategory.accept((Visitor)new Visitor<Visitable<Category>, Boolean, Mark>(){

            public Boolean visit(Visitable<Category> visitable, Mark mark) {
                if (((Category)visitable.getValue()).getAssignedMark().equals((Object)mark)) {
                    return Boolean.TRUE;
                }
                return null;
            }
        }, mark);
        return bl != null ? bl : false;
    }

    public void refresh() {
        this.fireDataChange();
    }

    public void removeListener(DrillDownListener drillDownListener) {
        this.listeners.remove(drillDownListener);
    }

    public void reset() {
        this.ddPath.clear();
        this.ddPath.add(this.categorization.getRoot());
        this.currentCategory = this.categorization.getRoot();
        this.updateSubCategories();
        this.fireDrillDownChange();
    }

    private void fireDataChange() {
        HashSet hashSet = new HashSet(this.listeners);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((DrillDownListener)iterator.next()).dataChanged();
        }
    }

    private void fireDrillDownChange() {
        HashSet hashSet = new HashSet(this.listeners);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((DrillDownListener)iterator.next()).drillDownPathChanged(this.getDrillDownPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSubCategories() {
        List<Category> list = this.subCategories;
        synchronized (list) {
            this.subCategories.clear();
            this.subCategories.addAll(this.currentCategory.getSubcategories());
            if (this.currentCategory.getId().equals(SELF_CATEGORY_ID) || this.currentCategory.getAssignedMark().equals((Object)Mark.DEFAULT)) {
                this.subCategories.add(new CategoryLeaf(SELF_CATEGORY_ID, this.getCurrentCategory().getLabel(), this.getCurrentCategory().getAssignedMark()));
            } else {
                this.subCategories.add(new CategoryLeaf(SELF_CATEGORY_ID, this.getCurrentCategory().getLabel() + "(Self)", this.getCurrentCategory().getAssignedMark()));
            }
        }
    }

    private static class TimeTouple {
        public static final TimeTouple ZERO = new TimeTouple(0L, 0L);
        final long time0;
        final long time1;

        public TimeTouple(long l, long l2) {
            this.time0 = l;
            this.time1 = l2;
        }
    }
}

