/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.basic.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.ui.basic.editors.GlobalReferenceEditor;
import org.netbeans.modules.xml.schema.ui.basic.editors.SchemaComponentSelDialogDesc;
import org.netbeans.modules.xml.schema.ui.basic.editors.SchemaComponentSelectionPanel;
import org.netbeans.modules.xml.schema.ui.nodes.schema.UnionNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberTypesPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    static final long serialVersionUID = 1L;
    private transient SchemaModel model;
    private JButton addButton;
    private JButton downButton;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JList memberTypesList;
    private JButton removeButton;
    private JButton upButton;

    public MemberTypesPanel(SchemaModel schemaModel, Collection<GlobalSimpleType> collection) {
        this.model = schemaModel;
        this.initComponents();
        this.memberTypesList.setModel(new MemberTypesModel(collection));
    }

    private void initComponents() {
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.memberTypesList = new JList();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.jLabel1 = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(MemberTypesPanel.class, (String)"LBL_Add"));
        this.addButton.setToolTipText(NbBundle.getMessage(MemberTypesPanel.class, (String)"HINT_Add"));
        this.addButton.addActionListener(this);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(MemberTypesPanel.class, (String)"LBL_Remove"));
        this.removeButton.setToolTipText(NbBundle.getMessage(MemberTypesPanel.class, (String)"HINT_Remove"));
        this.removeButton.addActionListener(this);
        this.removeButton.setEnabled(false);
        this.memberTypesList.addListSelectionListener(this);
        this.jScrollPane1.setViewportView(this.memberTypesList);
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(MemberTypesPanel.class, (String)"LBL_Up"));
        this.upButton.setToolTipText(NbBundle.getMessage(MemberTypesPanel.class, (String)"HINT_Up"));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(this);
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(MemberTypesPanel.class, (String)"LBL_Down"));
        this.downButton.setToolTipText(NbBundle.getMessage(MemberTypesPanel.class, (String)"HINT_Down"));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(this);
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setLabelFor(this.memberTypesList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MemberTypesPanel.class, (String)"LBL_CurrentlySelectedMemberTypes"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add(26, 26, 26).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1, -2, 117, -2).add((Component)this.jScrollPane1, -2, 209, -2)).add(19, 19, 19).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.addButton, -1, 86, Short.MAX_VALUE).add((Component)this.removeButton, -1, -1, Short.MAX_VALUE)).add((Component)this.downButton, -1, 86, Short.MAX_VALUE).add((Component)this.upButton, -1, 86, Short.MAX_VALUE)).add(87, 87, 87)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(26, 26, 26).add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addButton).add(13, 13, 13).add((Component)this.removeButton).add(15, 15, 15).add((Component)this.upButton).add(15, 15, 15).add((Component)this.downButton)).add((Component)this.jScrollPane1, -2, 144, -2)).addContainerGap(44, Short.MAX_VALUE)));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.addButton)) {
            Dialog dialog = this.getSelectorDialog();
            dialog.setVisible(true);
        } else if (actionEvent.getSource().equals(this.removeButton)) {
            int[] nArray = this.memberTypesList.getSelectedIndices();
            for (int i = nArray.length; i > 0; --i) {
                MemberTypesModel memberTypesModel = (MemberTypesModel)this.memberTypesList.getModel();
                memberTypesModel.removeMember(nArray[i - 1]);
            }
            this.memberTypesList.setSelectedIndex(0);
        } else if (actionEvent.getSource().equals(this.upButton)) {
            int n = this.memberTypesList.getSelectedIndex();
            MemberTypesModel memberTypesModel = (MemberTypesModel)this.memberTypesList.getModel();
            memberTypesModel.moveMember(n, true);
            this.memberTypesList.setSelectedIndex(n - 1);
        } else if (actionEvent.getSource().equals(this.downButton)) {
            int n = this.memberTypesList.getSelectedIndex();
            MemberTypesModel memberTypesModel = (MemberTypesModel)this.memberTypesList.getModel();
            memberTypesModel.moveMember(n, false);
            this.memberTypesList.setSelectedIndex(n + 1);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.memberTypesList)) {
            if (this.memberTypesList.getSelectedIndices() == null || this.memberTypesList.getModel().getSize() == 0) {
                this.removeButton.setEnabled(false);
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            } else {
                this.removeButton.setEnabled(true);
                if (this.memberTypesList.getSelectedIndices().length > 1) {
                    this.upButton.setEnabled(false);
                    this.downButton.setEnabled(false);
                } else {
                    int n = this.memberTypesList.getSelectedIndex();
                    if (n == 0) {
                        this.upButton.setEnabled(false);
                    } else {
                        this.upButton.setEnabled(true);
                    }
                    if (n == this.memberTypesList.getModel().getSize() - 1) {
                        this.downButton.setEnabled(false);
                    } else {
                        this.downButton.setEnabled(true);
                    }
                }
            }
        }
    }

    private Dialog getSelectorDialog() {
        final SchemaComponentSelectionPanel<Object> schemaComponentSelectionPanel = new SchemaComponentSelectionPanel<Object>(this.model, GlobalSimpleType.class, null, Collections.unmodifiableCollection(this.getCurrentSelection()), true);
        SchemaComponentSelDialogDesc schemaComponentSelDialogDesc = new SchemaComponentSelDialogDesc(schemaComponentSelectionPanel, NbBundle.getMessage(GlobalReferenceEditor.class, (String)"LBL_Custom_Property_Editor_Title", (Object[])new Object[]{NbBundle.getMessage(UnionNode.class, (String)"LBL_UnionNode_TypeDisplayName"), NbBundle.getMessage(UnionNode.class, (String)"PROP_MemberTypes_DisplayName")}), true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource().equals(DialogDescriptor.OK_OPTION)) {
                    try {
                        MemberTypesModel memberTypesModel = (MemberTypesModel)MemberTypesPanel.this.memberTypesList.getModel();
                        memberTypesModel.addMember((GlobalSimpleType)schemaComponentSelectionPanel.getCurrentSelection());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, illegalArgumentException.getMessage(), illegalArgumentException.getLocalizedMessage(), null, new Date());
                        throw illegalArgumentException;
                    }
                }
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)schemaComponentSelDialogDesc);
        return dialog;
    }

    public List<GlobalSimpleType> getCurrentSelection() {
        return ((MemberTypesModel)this.memberTypesList.getModel()).getMembers();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemberTypesModel
    extends AbstractListModel {
        static final long serialVersionUID = 1L;
        private List<GlobalSimpleType> members = new ArrayList<GlobalSimpleType>();

        public MemberTypesModel(Collection<GlobalSimpleType> collection) {
            if (collection != null) {
                this.members.addAll(collection);
            }
        }

        @Override
        public int getSize() {
            return this.members.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this.members.isEmpty() ? "" : (this.members.get(n) == null ? "" : this.members.get(n).getName());
        }

        public List<GlobalSimpleType> getMembers() {
            return this.members;
        }

        public void addMember(GlobalSimpleType globalSimpleType) {
            this.members.add(globalSimpleType);
            super.fireIntervalAdded(this, this.getSize(), this.getSize());
        }

        public void removeMember(int n) {
            if (n > -1) {
                this.members.remove(n);
                super.fireIntervalRemoved(this, n, n);
            }
        }

        public void moveMember(int n, boolean bl) {
            GlobalSimpleType globalSimpleType = this.members.remove(n);
            int n2 = bl ? n - 1 : n + 1;
            this.members.add(n2, globalSimpleType);
            super.fireContentsChanged(this, n, n2);
        }
    }
}

