/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.basic.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.schema.ui.basic.editors.NamespaceEditor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespacePanel
extends JPanel
implements ActionListener,
ListSelectionListener,
DocumentListener {
    static final long serialVersionUID = 1L;
    public static final String PROP_VALID_SELECTION = "validSelection";
    private boolean isValid = true;
    public ButtonGroup buttonGroup1;
    public JLabel dummyLabel1;
    public JLabel dummyLabel2;
    public JScrollPane jScrollPane1;
    public JRadioButton noNamespaceRadioButton;
    public JRadioButton otherNamespaceRadioButton;
    public JTextField otherNamespaceTextField;
    public JRadioButton schemaNamespaceRadioButton;
    public JList uriList;

    public NamespacePanel(String string, Collection<String> collection, Collection<NamespaceEditor.Option> collection2) {
        this.initComponents();
        this.initialize(string, collection, collection2);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.noNamespaceRadioButton = new JRadioButton();
        this.schemaNamespaceRadioButton = new JRadioButton();
        this.otherNamespaceRadioButton = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.uriList = new JList();
        this.otherNamespaceTextField = new JTextField();
        this.dummyLabel1 = new JLabel();
        this.dummyLabel2 = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.noNamespaceRadioButton, (String)NbBundle.getMessage(NamespacePanel.class, (String)"LBL_NoNamespace"));
        this.noNamespaceRadioButton.setToolTipText(NbBundle.getMessage(NamespacePanel.class, (String)"HINT_NoNamespace"));
        this.noNamespaceRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noNamespaceRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.noNamespaceRadioButton);
        this.noNamespaceRadioButton.addActionListener(this);
        Mnemonics.setLocalizedText((AbstractButton)this.schemaNamespaceRadioButton, (String)NbBundle.getMessage(NamespacePanel.class, (String)"LBL_SchemaNamespace"));
        this.schemaNamespaceRadioButton.setToolTipText(NbBundle.getMessage(NamespacePanel.class, (String)"HINT_SchemaNamespace"));
        this.schemaNamespaceRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.schemaNamespaceRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.schemaNamespaceRadioButton);
        this.schemaNamespaceRadioButton.addActionListener(this);
        Mnemonics.setLocalizedText((AbstractButton)this.otherNamespaceRadioButton, (String)NbBundle.getMessage(NamespacePanel.class, (String)"LBL_OtherNamespace"));
        this.otherNamespaceRadioButton.setToolTipText(NbBundle.getMessage(NamespacePanel.class, (String)"HINT_OtherNamespace"));
        this.otherNamespaceRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.otherNamespaceRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.otherNamespaceRadioButton);
        this.otherNamespaceRadioButton.addActionListener(this);
        this.uriList.addListSelectionListener(this);
        this.jScrollPane1.setViewportView(this.uriList);
        this.otherNamespaceTextField.setText(NbBundle.getMessage(NamespacePanel.class, (String)"TXT_defaultTNS"));
        this.otherNamespaceTextField.getDocument().addDocumentListener(this);
        this.otherNamespaceTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NamespacePanel.class, (String)"HINT_OtherNamespace"));
        this.otherNamespaceTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NamespacePanel.class, (String)"HINT_OtherNamespace"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((Component)this.otherNamespaceTextField, -1, 363, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((Component)this.jScrollPane1, -1, 363, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.schemaNamespaceRadioButton).addPreferredGap(0).add((Component)this.dummyLabel2)).add((Component)this.otherNamespaceRadioButton).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.noNamespaceRadioButton).addPreferredGap(0).add((Component)this.dummyLabel1))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(11, 11, 11).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.noNamespaceRadioButton).add((Component)this.dummyLabel1)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.schemaNamespaceRadioButton).add((Component)this.dummyLabel2)).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 124, -2).addPreferredGap(0).add((Component)this.otherNamespaceRadioButton).addPreferredGap(0).add((Component)this.otherNamespaceTextField, -2, -1, -2).addContainerGap(94, Short.MAX_VALUE)));
    }

    private void initialize(String string, Collection<String> collection, Collection<NamespaceEditor.Option> collection2) {
        if (collection == null || collection.isEmpty()) {
            this.schemaNamespaceRadioButton.setVisible(false);
            this.uriList.setVisible(false);
            this.jScrollPane1.setVisible(false);
        } else {
            this.uriList.setListData(collection.toArray(new String[collection.size()]));
        }
        if (!collection2.contains((Object)NamespaceEditor.Option.None)) {
            this.noNamespaceRadioButton.setSelected(false);
            this.noNamespaceRadioButton.setVisible(false);
        }
        if (string == null || string.trim().length() == 0) {
            this.uriList.setEnabled(false);
            if (this.noNamespaceRadioButton.isVisible()) {
                this.noNamespaceRadioButton.setSelected(true);
                this.otherNamespaceTextField.setEnabled(false);
            } else if (this.otherNamespaceRadioButton.isVisible()) {
                this.otherNamespaceRadioButton.setSelected(true);
                this.otherNamespaceTextField.setEnabled(true);
            }
        } else if (collection != null && collection.contains(string)) {
            this.schemaNamespaceRadioButton.setSelected(true);
            this.uriList.setSelectedValue(string, true);
            this.uriList.setEnabled(true);
            this.otherNamespaceTextField.setEnabled(false);
        } else {
            this.uriList.setEnabled(false);
            if (this.otherNamespaceRadioButton.isVisible()) {
                this.otherNamespaceRadioButton.setSelected(true);
                this.otherNamespaceTextField.setText(string);
                this.otherNamespaceTextField.setEnabled(true);
            }
        }
    }

    public void checkValidity() {
        boolean bl = false;
        if (this.noNamespaceRadioButton.isSelected()) {
            bl = true;
        } else if (this.schemaNamespaceRadioButton.isSelected()) {
            bl = this.uriList.getSelectedValue() != null;
        } else if (this.otherNamespaceRadioButton.isSelected()) {
            bl = !this.otherNamespaceTextField.getText().equals("");
        }
        this.firePropertyChange(PROP_VALID_SELECTION, this.isValid, bl);
        this.isValid = bl;
    }

    public String getCurrentSelection() {
        String string;
        if (this.schemaNamespaceRadioButton.isSelected()) {
            return (String)this.uriList.getSelectedValue();
        }
        if (this.otherNamespaceRadioButton.isSelected() && (string = this.otherNamespaceTextField.getText().trim()).length() > 0) {
            return string;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.noNamespaceRadioButton)) {
            this.uriList.setEnabled(false);
            this.otherNamespaceTextField.setEnabled(false);
        } else if (object.equals(this.otherNamespaceRadioButton)) {
            this.uriList.setEnabled(false);
            this.otherNamespaceTextField.setEnabled(true);
        } else if (object.equals(this.schemaNamespaceRadioButton)) {
            this.otherNamespaceTextField.setEnabled(false);
            this.uriList.setEnabled(true);
        }
        this.checkValidity();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.checkValidity();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkValidity();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkValidity();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }
}

