/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.basic.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.ui.basic.SchemaModelCookie;
import org.netbeans.modules.xml.schema.ui.basic.UIUtilities;
import org.netbeans.modules.xml.schema.ui.nodes.DefaultExpandedCookie;
import org.netbeans.modules.xml.schema.ui.nodes.ReadOnlyCookie;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.CategorizedSchemaNodeFactory;
import org.netbeans.modules.xml.text.navigator.base.AbstractXMLNavigatorContent;
import org.netbeans.modules.xml.xam.Model;
import org.openide.explorer.ExplorerManager;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public class SchemaNavigatorContent
extends AbstractXMLNavigatorContent
implements Runnable {
    private static final long serialVersionUID = 1L;
    private static Lookup lookup = Lookups.singleton((Object)new ReadOnlyCookie(true));
    private Node explorerRoot;

    public SchemaNavigatorContent() {
        this.setLayout(new BorderLayout());
    }

    protected void expandDefaultNodes() {
        Object object;
        Node node = this.getExplorerManager().getRootContext();
        int n = 0;
        do {
            if (((Node[])(object = node.getChildren().getNodes())).length == 1) {
                this.treeView.expandNode(object[0]);
                node = object[0];
                ++n;
                continue;
            }
            for (Node node2 : object) {
                DefaultExpandedCookie defaultExpandedCookie = (DefaultExpandedCookie)node2.getCookie(DefaultExpandedCookie.class);
                if (defaultExpandedCookie == null || !defaultExpandedCookie.isDefaultExpanded()) continue;
                this.treeView.expandNode(node2);
            }
            node = null;
        } while (node != null && n < 5);
        object = (JTree)this.treeView.getViewport().getView();
        if (((JTree)object).getRowCount() > ((JTree)object).getVisibleRowCount()) {
            node = this.getExplorerManager().getRootContext();
            Enumeration enumeration = node.getChildren().nodes();
            while (enumeration.hasMoreElements()) {
                Node node3 = (Node)enumeration.nextElement();
                this.treeView.collapseNode(node3);
            }
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private SchemaModel getSchemaModel(DataObject dataObject) {
        try {
            SchemaModelCookie schemaModelCookie = (SchemaModelCookie)dataObject.getCookie(SchemaModelCookie.class);
            if (schemaModelCookie == null) {
                return null;
            }
            SchemaModel schemaModel = (SchemaModel)schemaModelCookie.getModel();
            if (schemaModel != null) {
                schemaModel.removePropertyChangeListener((PropertyChangeListener)((Object)this));
                schemaModel.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            }
            return schemaModel;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void navigate(final DataObject dataObject) {
        this.showWaitPanel();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                final SchemaModel schemaModel = SchemaNavigatorContent.this.getSchemaModel(dataObject);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (schemaModel == null || schemaModel.getState() != Model.State.VALID) {
                            SchemaNavigatorContent.this.showError(AbstractXMLNavigatorContent.ERROR_NO_DATA_AVAILABLE);
                        } else {
                            SchemaNavigatorContent.this.show(schemaModel);
                        }
                    }
                });
            }
        });
    }

    public boolean requestFocusInWindow() {
        return this.treeView.requestFocusInWindow();
    }

    public void run() {
        this.getExplorerManager().setRootContext(this.explorerRoot);
        this.expandDefaultNodes();
        this.selectActivatedNodes();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("state".equals(string)) {
            this.onModelStateChanged(propertyChangeEvent);
            return;
        }
        TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, (Component)((Object)this));
        if ("selectedNodes".equals(string) && topComponent == TopComponent.getRegistry().getActivated()) {
            Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            if (nodeArray != null && nodeArray.length >= 1) {
                topComponent.setActivatedNodes(nodeArray);
            }
        } else {
            TopComponent.getRegistry();
            if ("activatedNodes".equals(string) && topComponent != null && topComponent != TopComponent.getRegistry().getActivated()) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        SchemaNavigatorContent.this.selectActivatedNodes();
                    }
                });
            } else {
                TopComponent.getRegistry();
                if ("activated".equals(string) && topComponent == TopComponent.getRegistry().getActivated()) {
                    topComponent.setActivatedNodes(this.getExplorerManager().getSelectedNodes());
                }
            }
        }
    }

    private void selectActivatedNodes() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : nodeArray) {
            List<Node> list;
            SchemaComponent schemaComponent = (SchemaComponent)node.getLookup().lookup(SchemaComponent.class);
            if (schemaComponent == null || (list = UIUtilities.findPathFromRoot(this.getExplorerManager().getRootContext(), schemaComponent)) == null || list.isEmpty()) continue;
            arrayList.add(list.get(list.size() - 1));
        }
        try {
            this.getExplorerManager().setSelectedNodes(arrayList.toArray(new Node[0]));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void onModelStateChanged(PropertyChangeEvent propertyChangeEvent) {
        Model.State state = (Model.State)propertyChangeEvent.getNewValue();
        if (state == Model.State.VALID) {
            SchemaModel schemaModel = (SchemaModel)propertyChangeEvent.getSource();
            this.show(schemaModel);
            return;
        }
        this.showError(AbstractXMLNavigatorContent.ERROR_NO_DATA_AVAILABLE);
    }

    private void show(SchemaModel schemaModel) {
        this.removeAll();
        this.add((Component)this.treeView, "Center");
        CategorizedSchemaNodeFactory categorizedSchemaNodeFactory = new CategorizedSchemaNodeFactory(schemaModel, lookup);
        this.explorerRoot = categorizedSchemaNodeFactory.createRootNode();
        EventQueue.invokeLater(this);
        this.revalidate();
        this.repaint();
    }
}

