/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.basic.search;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.xml.schema.model.AttributeGroupReference;
import org.netbeans.modules.xml.schema.model.AttributeReference;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GroupReference;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.visitor.DeepSchemaVisitor;
import org.netbeans.modules.xml.schema.model.visitor.SchemaVisitor;
import org.netbeans.modules.xml.schema.ui.basic.search.Providers;
import org.netbeans.modules.xml.xam.ui.category.Category;
import org.netbeans.modules.xml.xam.ui.search.Query;
import org.netbeans.modules.xml.xam.ui.search.SearchException;
import org.netbeans.modules.xml.xam.ui.search.SearchProvider;
import org.netbeans.modules.xml.xam.ui.search.WildcardStringMatcher;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameSpaceSearchProvider
extends DeepSchemaVisitor
implements SearchProvider {
    private String phrase;
    private boolean wildcarded;
    private SchemaModel model;
    private List<Object> results;
    private Category category;
    private Pattern pattern;

    public NameSpaceSearchProvider(SchemaModel schemaModel, Category category) {
        this.model = schemaModel;
        this.category = category;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(NameSpaceSearchProvider.class, (String)"LBL_SearchProvider_NameSpace");
    }

    public String getInputDescription() {
        return NbBundle.getMessage(NameSpaceSearchProvider.class, (String)"HELP_SearchProvider_NameSpace");
    }

    public String getShortDescription() {
        return NbBundle.getMessage(NameSpaceSearchProvider.class, (String)"HINT_SearchProvider_NameSpace");
    }

    public List<Object> search(Query query) throws SearchException {
        if (query.isRegularExpression()) {
            try {
                this.pattern = Pattern.compile(query.getQuery());
                this.phrase = null;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new SearchException(patternSyntaxException.getMessage(), (Throwable)patternSyntaxException);
            }
        } else {
            this.pattern = null;
            this.phrase = query.getQuery().toLowerCase();
            this.wildcarded = WildcardStringMatcher.containsWildcards((String)this.phrase);
        }
        this.results = new ArrayList<Object>();
        if (query.useSelected()) {
            SchemaComponent schemaComponent = Providers.getSelectedComponent(this.category);
            if (schemaComponent != null) {
                schemaComponent.accept((SchemaVisitor)this);
            } else {
                Class<? extends SchemaComponent> clazz = Providers.getSelectedChildType(this.category);
                if (clazz != null) {
                    List list = this.model.getSchema().getChildren(clazz);
                    for (SchemaComponent schemaComponent2 : list) {
                        schemaComponent2.accept((SchemaVisitor)this);
                    }
                }
            }
        } else {
            this.model.getSchema().accept((SchemaVisitor)this);
        }
        return this.results;
    }

    private void match(SchemaComponent schemaComponent, String string) {
        if (string != null) {
            Matcher matcher;
            if (this.phrase != null) {
                string = string.toLowerCase();
                if (this.wildcarded) {
                    if (WildcardStringMatcher.match((String)string, (String)this.phrase)) {
                        this.results.add(schemaComponent);
                    }
                } else if (string.indexOf(this.phrase) > -1) {
                    this.results.add(schemaComponent);
                }
            } else if (this.pattern != null && (matcher = this.pattern.matcher(string)).find()) {
                this.results.add(schemaComponent);
            }
        }
    }

    public void visit(AttributeReference attributeReference) {
        super.visit(attributeReference);
        this.match((SchemaComponent)attributeReference, attributeReference.getRef().getEffectiveNamespace());
    }

    public void visit(AttributeGroupReference attributeGroupReference) {
        super.visit(attributeGroupReference);
        this.match((SchemaComponent)attributeGroupReference, attributeGroupReference.getGroup().getEffectiveNamespace());
    }

    public void visit(ElementReference elementReference) {
        super.visit(elementReference);
        this.match((SchemaComponent)elementReference, elementReference.getRef().getEffectiveNamespace());
    }

    public void visit(GroupReference groupReference) {
        super.visit(groupReference);
        this.match((SchemaComponent)groupReference, groupReference.getRef().getEffectiveNamespace());
    }
}

