/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspcompiler;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jspcompiler.SmapFileReader;
import org.netbeans.modules.web.jspcompiler.SmapResolver;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.OutputListener;

public final class JSPJavacAntLogger
extends AntLogger {
    private static final Logger ERR = Logger.getLogger(JSPJavacAntLogger.class.getName());
    private static final boolean LOGGABLE = ERR.isLoggable(Level.FINE);
    private static final String[] TASKS_OF_INTEREST = AntLogger.ALL_TASKS;
    private static final int[] LEVELS_OF_INTEREST = new int[]{2, 1, 0};
    private static final String JAVA_SUFFIX = ".java";
    private static final String SMAP_SUFFIX = ".class.smap";

    public boolean interestedInSession(AntSession antSession) {
        return true;
    }

    public boolean interestedInAllScripts(AntSession antSession) {
        return true;
    }

    public boolean interestedInScript(File file, AntSession antSession) {
        return true;
    }

    public String[] interestedInTargets(AntSession antSession) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession antSession) {
        return TASKS_OF_INTEREST;
    }

    public int[] interestedInLogLevels(AntSession antSession) {
        return LEVELS_OF_INTEREST;
    }

    public void messageLogged(AntEvent antEvent) {
        String string;
        if (antEvent.isConsumed()) {
            return;
        }
        AntSession antSession = antEvent.getSession();
        OutputListener outputListener = JSPJavacAntLogger.findHyperlink(antSession, string = antEvent.getMessage());
        if (outputListener != null) {
            antEvent.getSession().println(string, antEvent.getLogLevel() <= 1, outputListener);
            antEvent.consume();
        }
    }

    private static OutputListener findHyperlink(AntSession antSession, String string) {
        String string2;
        int n;
        if (LOGGABLE) {
            ERR.log(Level.FINE, "line: " + string);
        }
        if (string.startsWith("file:///")) {
            string = string.substring(7);
            if (LOGGABLE) {
                ERR.log(Level.FINE, "removing file:///");
            }
        } else if (string.startsWith("file:")) {
            string = string.substring(5);
            if (LOGGABLE) {
                ERR.log(Level.FINE, "removing file:");
            }
        } else if (string.length() > 0 && string.charAt(0) == '/') {
            if (LOGGABLE) {
                ERR.log(Level.FINE, "result: looks like Unix file");
            }
        } else if (string.length() > 2 && string.charAt(1) == ':' && string.charAt(2) == '\\') {
            if (LOGGABLE) {
                ERR.log(Level.FINE, "result: looks like Windows file");
            }
        } else {
            if (LOGGABLE) {
                ERR.log(Level.FINE, "result: not a file");
            }
            return null;
        }
        if ((n = string.indexOf(58)) == -1) {
            if (LOGGABLE) {
                ERR.log(Level.FINE, "result: no colon found");
            }
            return null;
        }
        String string3 = string.substring(0, n);
        File file = FileUtil.normalizeFile((File)new File(string3));
        if (!file.exists()) {
            if (LOGGABLE) {
                ERR.log(Level.FINE, "result: no FO for " + string3);
            }
            if ((n = string.indexOf(58, n + 1)) == -1) {
                if (LOGGABLE) {
                    ERR.log(Level.FINE, "result: no second colon found");
                }
                return null;
            }
            string3 = string.substring(0, n);
            file = FileUtil.normalizeFile((File)new File(string3));
            if (!file.exists()) {
                if (LOGGABLE) {
                    ERR.log(Level.FINE, "result: no FO for " + string3);
                }
                return null;
            }
        }
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = n + 1;
        int n7 = string.indexOf(58, n + 1);
        if (n7 != -1) {
            try {
                n2 = Integer.parseInt(string.substring(n + 1, n7).trim());
                n6 = n7 + 1;
                int n8 = string.indexOf(58, n7 + 1);
                if (n8 != -1) {
                    n3 = Integer.parseInt(string.substring(n7 + 1, n8).trim());
                    n6 = n8 + 1;
                    int n9 = string.indexOf(58, n8 + 1);
                    if (n9 != -1) {
                        n4 = Integer.parseInt(string.substring(n8 + 1, n9).trim());
                        n6 = n9 + 1;
                        int n10 = string.indexOf(58, n9 + 1);
                        if (n10 != -1) {
                            n5 = Integer.parseInt(string.substring(n9 + 1, n10).trim());
                            if (n5 == n3) {
                                n5 = -1;
                            }
                            n6 = n10 + 1;
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string2 = string.substring(n6).trim()).length() == 0) {
            string2 = null;
        }
        if (LOGGABLE) {
            ERR.log(Level.FINE, "Hyperlink: [" + file + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + string2 + "]");
        }
        File file2 = JSPJavacAntLogger.getSMAPFileForFile(file);
        if (LOGGABLE) {
            ERR.log(Level.FINE, "smapfile: [" + file2 + "]");
        }
        if (file2 != null && file2.exists()) {
            try {
                int n11;
                SmapResolver smapResolver = new SmapResolver(new SmapFileReader(file2));
                String string4 = smapResolver.getJspFileName(n2, n3);
                if (string4 == null) {
                    return null;
                }
                if (LOGGABLE) {
                    ERR.log(Level.FINE, "translate: [" + n2 + ", " + n3 + "]");
                }
                if ((n11 = smapResolver.unmangle(n2, n3)) == -1) {
                    n11 = smapResolver.unmangle(n2 - 1, n3);
                    string4 = smapResolver.getJspFileName(n2 - 1, n3);
                }
                if (n11 == -1) {
                    n11 = smapResolver.unmangle(n2 + 1, n3);
                    string4 = smapResolver.getJspFileName(n2 + 1, n3);
                }
                try {
                    WebModule webModule = WebModule.getWebModule((FileObject)FileUtil.toFileObject((File)file));
                    if (webModule == null) {
                        return null;
                    }
                    FileObject fileObject = webModule.getDocumentBase().getFileObject(string4);
                    if (fileObject != null) {
                        return antSession.createStandardHyperlink(FileUtil.toFile((FileObject)fileObject).toURI().toURL(), string2, n11, -1, -1, -1);
                    }
                    return null;
                }
                catch (MalformedURLException malformedURLException) {
                    assert (false) : malformedURLException;
                    return null;
                }
            }
            catch (IOException iOException) {
                ERR.log(Level.INFO, null, iOException);
                return null;
            }
            catch (Exception exception) {
                ERR.log(Level.INFO, null, exception);
                return null;
            }
        }
        return null;
    }

    public static File getSMAPFileForFile(File file) {
        File file2 = FileUtil.normalizeFile((File)file);
        File file3 = file2.getAbsoluteFile().getParentFile();
        String string = file2.getName();
        if (!string.endsWith(JAVA_SUFFIX)) {
            return null;
        }
        string = string.substring(0, string.length() - JAVA_SUFFIX.length());
        File file4 = new File(file3, string + SMAP_SUFFIX);
        return file4;
    }
}

