/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.web.wizards.Editable;
import org.openide.util.NbBundle;

class DDTable
extends JTable
implements KeyListener {
    private static final Logger LOG = Logger.getLogger(DDTable.class.getName());
    private String titleKey;
    private Editable editable;
    private String[] headers;
    private static final int margin = 6;
    private boolean fontChanged = true;
    private boolean addedRow = true;
    private int rowHeight = 23;
    private static final long serialVersionUID = -155464225493968935L;

    DDTable(String[] stringArray, String string) {
        this(stringArray, string, Editable.BOTH);
    }

    DDTable(String[] stringArray, String string, Editable editable) {
        super(new Object[0][stringArray.length], stringArray);
        this.headers = stringArray;
        this.titleKey = string;
        this.editable = editable;
        this.setModel(new DDTableModel(stringArray, editable));
        this.setColors(editable);
        this.setSelectionMode(0);
        this.setIntercellSpacing(new Dimension(6, 6));
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new CellText(this));
        defaultCellEditor.setClickCountToStart(1);
        this.getColumnModel().getColumn(0).setCellEditor(defaultCellEditor);
        this.getColumnModel().getColumn(1).setCellEditor(defaultCellEditor);
    }

    void setEditable(Editable editable) {
        this.editable = editable;
        this.setColors(editable);
    }

    Editable getEditable() {
        return this.editable;
    }

    int addRow(String[] stringArray) {
        int n = ((DDTableModel)this.getModel()).addRow(stringArray);
        if (n == 0) {
            this.fontChanged = true;
        }
        this.addedRow = true;
        this.invalidate();
        return n;
    }

    void removeRow(int n) {
        if (this.isEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
        ((DDTableModel)this.getModel()).removeRow(n);
        this.invalidate();
        int n2 = this.getRowCount() - 1;
        if (this.getSelectedRow() > n2) {
            if (n2 >= 0) {
                this.setRowSelectionInterval(n2, n2);
            } else {
                this.clearSelection();
            }
        }
    }

    String getColumnKey(int n) {
        return this.headers[n];
    }

    private void setColors(Editable editable) {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        Color color = editable == Editable.NEITHER ? this.getBackground().darker() : Color.white;
        this.setBackground(color);
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        return super.getCellRenderer(n, n2);
    }

    void setData(String string, String string2, int n) {
        if (this.getEditingRow() == n) {
            int n2 = this.getEditingColumn();
            this.getCellEditor(n, n2).cancelCellEditing();
        }
        ((DDTableModel)this.getModel()).setData(string, string2, n);
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.editable == Editable.NEITHER) {
            return false;
        }
        return this.editable != Editable.VALUE || n2 != 0;
    }

    public void paint(Graphics graphics) {
        if (this.fontChanged) {
            LOG.finer("Font changed");
            this.fontChanged = false;
            int n = 0;
            FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
            n = fontMetrics.getHeight() + 6;
            if (n > this.rowHeight) {
                this.rowHeight = n;
            }
            LOG.finer("row height is " + this.rowHeight);
            this.setRowHeight(this.rowHeight);
            return;
        }
        if (this.addedRow) {
            this.addedRow = false;
            LOG.finer("Added row");
            int n = this.getModel().getRowCount() - 1;
            this.editCellAt(n, 0);
            Component component = this.getCellEditor(n, 0).getTableCellEditorComponent(this, this.getValueAt(n, 0), true, n, 0);
            if (component instanceof JTextField) {
                LOG.finer("Trying to request focus");
                ((JTextField)component).requestFocus();
            }
        }
        super.paint(graphics);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        LOG.finer("keyReleased()");
        Object object = keyEvent.getSource();
        String string = null;
        if (object instanceof JTextField) {
            LOG.finer("Found text field");
            string = ((JTextField)object).getText().trim();
        }
        int n = this.getEditingRow();
        int n2 = this.getEditingColumn();
        LOG.finer("row=" + n + ", col=" + n2);
        this.setValueAt(string, n, n2);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    class CellText
    extends JTextField {
        private static final long serialVersionUID = 2674682216176560005L;

        public CellText(DDTable dDTable2) {
            this.addKeyListener(dDTable2);
            this.getAccessibleContext().setAccessibleName(this.getText());
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DDTable.class, (String)"ACSD_ipcell"));
        }
    }

    class DDTableModel
    extends AbstractTableModel {
        private String[] colheaders = null;
        private Object[][] data = null;
        private Editable editable;
        private int numCols;
        private int numRows = 0;
        private static final long serialVersionUID = -5044296029944667379L;

        DDTableModel(String[] stringArray, Editable editable) {
            this.colheaders = stringArray;
            this.editable = editable;
            this.numCols = this.colheaders.length;
            this.data = new Object[this.numRows][this.numCols];
        }

        public String getColumnName(int n) {
            String string = "LBL_".concat(this.colheaders[n]);
            return NbBundle.getMessage(DDTable.class, (String)string);
        }

        public int getRowCount() {
            return this.data.length;
        }

        public int getColumnCount() {
            return this.numCols;
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public int addRow(String[] stringArray) {
            Object[][] objectArray = new Object[this.numRows + 1][this.numCols];
            int n = 0;
            int n2 = 0;
            if (this.numRows > 0) {
                for (n2 = 0; n2 < this.numRows; ++n2) {
                    objectArray[n2] = this.data[n2];
                }
            }
            for (n = 0; n < stringArray.length; ++n) {
                objectArray[n2][n] = stringArray[n];
            }
            this.data = objectArray;
            ++this.numRows;
            return n2;
        }

        public void removeRow(int n) {
            LOG.finer("removeRow(): row is " + n + ", numRows is " + this.numRows);
            Object[][] objectArray = new Object[this.numRows - 1][this.numCols];
            int n2 = 0;
            for (int i = 0; i < this.numRows; ++i) {
                if (i == n) continue;
                objectArray[n2] = this.data[i];
                LOG.finer("newRowIndex is " + ++n2);
            }
            this.data = objectArray;
            this.numRows = --this.numRows;
        }

        void setData(String string, String string2, int n) {
            this.data[n][0] = string;
            this.data[n][1] = string2;
            this.fireTableChanged(new TableModelEvent(this, n));
        }

        public void setValueAt(Object object, int n, int n2) {
            LOG.finer("setValueAt(): value = " + object + " at " + n + ", " + n2);
            this.data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }
    }
}

