/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.web.wizards.DeployData;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.FilterMappingData;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServletData
extends DeployData {
    private static final Logger LOG = Logger.getLogger(ServletData.class.getName());
    private static final Pattern VALID_URI_PATTERN = Pattern.compile("[-_.!~*'();/?:@&=+$,a-zA-Z0-9]+");
    private String errorMessage = null;
    private String name = null;
    private String[] urlMappings = null;
    private List<FilterMappingData> filterMappings = null;
    private String[][] initparams = null;
    private boolean paramOK = true;
    private String duplicitParam = null;
    private FileType fileType = null;
    private boolean addToDD = true;

    ServletData(FileType fileType) {
        this.fileType = fileType;
    }

    String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    void setName(String string) {
        if (string != this.name) {
            if (this.fileType == FileType.FILTER) {
                this.updateFilterMappings(this.getName(), string);
            }
            this.name = string;
        }
    }

    String[] getServletNames() {
        if (this.webApp == null) {
            return new String[0];
        }
        Servlet[] servletArray = this.webApp.getServlet();
        String[] stringArray = new String[servletArray.length];
        for (int i = 0; i < servletArray.length; ++i) {
            try {
                stringArray[i] = servletArray[i].getServletName();
                continue;
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "error", exception);
                stringArray[i] = "";
            }
        }
        return stringArray;
    }

    private List<String> getUrlPatterns() {
        if (this.webApp == null) {
            return new ArrayList<String>();
        }
        ServletMapping[] servletMappingArray = this.webApp.getServletMapping();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < servletMappingArray.length; ++i) {
            arrayList.add(servletMappingArray[i].getUrlPattern());
        }
        return arrayList;
    }

    List<FilterMappingData> getFilterMappings() {
        if (this.webApp == null) {
            return Collections.emptyList();
        }
        if (this.filterMappings != null) {
            return this.filterMappings;
        }
        LOG.finer("Creating the filter mapping list");
        FilterMapping[] filterMappingArray = this.webApp.getFilterMapping();
        LOG.finer("Order of mappings according to DD APIs");
        for (int i = 0; i < filterMappingArray.length; ++i) {
            LOG.finer("Servlet name: " + filterMappingArray[i].getFilterName());
        }
        this.filterMappings = new ArrayList<FilterMappingData>();
        this.filterMappings.add(new FilterMappingData(this.getName()));
        String[] stringArray = null;
        for (int i = 0; i < filterMappingArray.length; ++i) {
            FilterMappingData.Dispatcher[] dispatcherArray;
            FilterMappingData filterMappingData;
            block14: {
                filterMappingData = new FilterMappingData();
                filterMappingData.setName(filterMappingArray[i].getFilterName());
                String string = filterMappingArray[i].getUrlPattern();
                if (string == null || string.length() == 0) {
                    filterMappingData.setType(FilterMappingData.Type.SERVLET);
                    filterMappingData.setPattern(filterMappingArray[i].getServletName());
                } else {
                    filterMappingData.setType(FilterMappingData.Type.URL);
                    filterMappingData.setPattern(string);
                }
                try {
                    if (filterMappingArray[i].sizeDispatcher() == 0) {
                        this.filterMappings.add(filterMappingData);
                    }
                    break block14;
                }
                catch (Exception exception) {
                    LOG.log(Level.FINE, "error", exception);
                    this.filterMappings.add(filterMappingData);
                }
                continue;
            }
            try {
                stringArray = filterMappingArray[i].getDispatcher();
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "error", exception);
            }
            if (stringArray == null) {
                dispatcherArray = new FilterMappingData.Dispatcher[]{};
            } else {
                dispatcherArray = new FilterMappingData.Dispatcher[stringArray.length];
                for (int j = 0; j < stringArray.length; ++j) {
                    dispatcherArray[j] = FilterMappingData.Dispatcher.findDispatcher(stringArray[j]);
                    LOG.finer("Dispatch: " + dispatcherArray[j]);
                }
            }
            filterMappingData.setDispatcher(dispatcherArray);
            this.filterMappings.add(filterMappingData);
        }
        return this.filterMappings;
    }

    void setFilterMappings(List<FilterMappingData> list) {
        this.filterMappings = list;
    }

    private void updateFilterMappings(String string, String string2) {
        for (FilterMappingData filterMappingData : this.getFilterMappings()) {
            if (!filterMappingData.getName().equals(string)) continue;
            filterMappingData.setName(string2);
        }
    }

    private boolean isNameUnique() {
        if (this.webApp == null) {
            return true;
        }
        Servlet[] servletArray = this.webApp.getServlet();
        for (int i = 0; i < servletArray.length; ++i) {
            if (!this.name.equals(servletArray[i].getServletName())) continue;
            return false;
        }
        Filter[] filterArray = this.webApp.getFilter();
        for (int i = 0; i < filterArray.length; ++i) {
            if (!this.name.equals(filterArray[i].getFilterName())) continue;
            return false;
        }
        return true;
    }

    String[] getUrlMappings() {
        if (this.urlMappings == null) {
            return new String[0];
        }
        return this.urlMappings;
    }

    String createDDServletName(String string) {
        if (this.webApp == null) {
            return null;
        }
        String string2 = string;
        Servlet servlet = (Servlet)this.webApp.findBeanByName("Servlet", "ServletName", string2);
        while (servlet != null) {
            string2 = this.findNextId(string2);
            servlet = (Servlet)this.webApp.findBeanByName("Servlet", "ServletName", string2);
        }
        this.setName(string2);
        return string2;
    }

    void createDDServletMapping(String string) {
        if (this.webApp == null) {
            return;
        }
        String string2 = ServletData.getRFC2396URI("/" + string);
        ServletMapping servletMapping = (ServletMapping)this.webApp.findBeanByName("ServletMapping", "UrlPattern", string2);
        while (servletMapping != null) {
            string2 = this.findNextId(string2);
            servletMapping = (ServletMapping)this.webApp.findBeanByName("ServletMapping", "UrlPattern", string2);
        }
        this.urlMappings = new String[]{string2};
    }

    private String findNextId(String string) {
        char c = string.charAt(string.length() - 1);
        String string2 = null;
        if (!Character.isDigit(c)) {
            string2 = string + "_1";
            return string2;
        }
        String string3 = string.substring(string.length() - 1);
        int n = new Integer(string3) + 1;
        string2 = string.substring(0, string.length() - 1) + new Integer(n).toString();
        return string2;
    }

    String getUrlMappingsAsString() {
        int n;
        if (this.urlMappings == null || this.urlMappings.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.urlMappings.length - 1; ++n) {
            stringBuffer.append(this.urlMappings[n]);
            stringBuffer.append(", ");
        }
        stringBuffer.append(this.urlMappings[n]);
        return stringBuffer.toString();
    }

    void parseUrlMappingString(String string) {
        this.urlMappings = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() == 0) continue;
            arrayList.add(string2);
        }
        this.urlMappings = new String[arrayList.size()];
        arrayList.toArray(this.urlMappings);
    }

    String[][] getInitParams() {
        if (this.initparams == null) {
            return new String[0][2];
        }
        return this.initparams;
    }

    void setInitParams(String[][] stringArray, boolean bl, String string) {
        this.initparams = stringArray;
        this.paramOK = bl;
        this.duplicitParam = string;
    }

    @Override
    boolean isValid() {
        this.errorMessage = new String();
        if (this.webApp == null) {
            return true;
        }
        if (!this.isAddToDD()) {
            return true;
        }
        if (this.getName().length() == 0) {
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_no_name");
            return false;
        }
        if (!this.isNameUnique()) {
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_name_unique");
            return false;
        }
        if (this.fileType == FileType.SERVLET) {
            if (!this.checkMappingsForServlet()) {
                return false;
            }
            if (!this.checkServletDuplicitMappings()) {
                return false;
            }
        } else if (this.fileType == FileType.FILTER && !this.checkMappingsForFilter()) {
            return false;
        }
        if (!this.paramOK) {
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_invalid_param");
            return false;
        }
        if (this.duplicitParam != null) {
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_duplicit_param", (Object)this.duplicitParam);
            return false;
        }
        return true;
    }

    private boolean checkMappingsForServlet() {
        this.errorMessage = new String();
        String[] stringArray = this.getUrlMappings();
        if (stringArray == null || stringArray.length == 0) {
            LOG.finer("No URL mappings");
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_no_mapping");
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.checkServletMappig(stringArray[i]);
            if (string == null) continue;
            this.errorMessage = string;
            return false;
        }
        return true;
    }

    private boolean checkServletDuplicitMappings() {
        this.errorMessage = new String();
        String[] stringArray = this.getUrlMappings();
        List<String> list = this.getUrlPatterns();
        for (int i = 0; i < stringArray.length; ++i) {
            for (String string : list) {
                if (!stringArray[i].equals(string)) continue;
                LOG.finer("Duplicit URL mappings");
                this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_url_pattern_unique");
                return false;
            }
            list.add(stringArray[i]);
        }
        return true;
    }

    private boolean checkMappingsForFilter() {
        this.errorMessage = new String();
        if (this.filterMappings == null || this.filterMappings.size() == 0) {
            LOG.finer("No mappings");
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_no_mapping");
            return false;
        }
        Iterator<FilterMappingData> iterator = this.getFilterMappings().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            FilterMappingData filterMappingData = iterator.next();
            if (!filterMappingData.getName().equals(this.getName())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.errorMessage = NbBundle.getMessage(ServletData.class, (String)"MSG_no_mapping");
            return false;
        }
        return true;
    }

    @Override
    void createDDEntries() {
        boolean bl;
        if (this.webApp == null) {
            return;
        }
        if (this.fileType == FileType.SERVLET) {
            boolean bl2 = this.addServlet();
            if (bl2) {
                this.addUrlMappings();
                try {
                    this.writeChanges();
                }
                catch (IOException iOException) {
                    LOG.log(Level.FINE, "error", iOException);
                }
            }
        } else if (this.fileType == FileType.FILTER && (bl = this.addFilter())) {
            this.addFilterMappings();
            try {
                this.writeChanges();
            }
            catch (IOException iOException) {
                LOG.log(Level.FINE, "error", iOException);
            }
        }
    }

    private boolean addServlet() {
        Servlet servlet;
        if (this.webApp == null) {
            return false;
        }
        try {
            servlet = (Servlet)this.webApp.createBean("Servlet");
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.log(Level.FINE, "servlet creation error", classNotFoundException);
            return false;
        }
        servlet.setServletName(this.name);
        servlet.setServletClass(this.className);
        int n = this.getInitParams().length;
        for (int i = 0; i < n; ++i) {
            InitParam initParam;
            try {
                initParam = (InitParam)servlet.createBean("InitParam");
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.log(Level.FINE, "servlet init parameter creation error", classNotFoundException);
                continue;
            }
            initParam.setParamName(this.initparams[i][0]);
            initParam.setParamValue(this.initparams[i][1]);
            servlet.addInitParam(initParam);
        }
        this.webApp.addServlet(servlet);
        return true;
    }

    private boolean addFilter() {
        Filter filter;
        if (this.webApp == null) {
            return false;
        }
        try {
            filter = (Filter)this.webApp.createBean("Filter");
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.log(Level.FINE, "filter creation error", classNotFoundException);
            return false;
        }
        filter.setFilterName(this.name);
        filter.setFilterClass(this.className);
        int n = this.getInitParams().length;
        for (int i = 0; i < n; ++i) {
            InitParam initParam;
            try {
                initParam = (InitParam)filter.createBean("InitParam");
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.log(Level.FINE, "filter init parameter creation error", classNotFoundException);
                continue;
            }
            initParam.setParamName(this.initparams[i][0]);
            initParam.setParamValue(this.initparams[i][1]);
            filter.addInitParam(initParam);
        }
        this.webApp.addFilter(filter);
        return true;
    }

    private void addUrlMappings() {
        if (this.webApp == null) {
            return;
        }
        int n = this.getUrlMappings().length;
        for (int i = 0; i < n; ++i) {
            ServletMapping servletMapping;
            try {
                servletMapping = (ServletMapping)this.webApp.createBean("ServletMapping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.log(Level.FINE, "error", classNotFoundException);
                return;
            }
            servletMapping.setServletName(this.name);
            servletMapping.setUrlPattern(this.urlMappings[i]);
            this.webApp.addServletMapping(servletMapping);
        }
    }

    private void addFilterMappings() {
        if (this.webApp == null) {
            return;
        }
        int n = this.filterMappings.size();
        Iterator<FilterMappingData> iterator = this.filterMappings.iterator();
        FilterMapping[] filterMappingArray = new FilterMapping[n];
        for (int i = 0; i < n; ++i) {
            FilterMappingData filterMappingData = iterator.next();
            try {
                filterMappingArray[i] = (FilterMapping)this.webApp.createBean("FilterMapping");
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.log(Level.FINE, "filter mapping creation error", classNotFoundException);
                return;
            }
            filterMappingArray[i].setFilterName(filterMappingData.getName());
            if (filterMappingData.getType() == FilterMappingData.Type.URL) {
                filterMappingArray[i].setUrlPattern(filterMappingData.getPattern());
            } else {
                filterMappingArray[i].setServletName(filterMappingData.getPattern());
            }
            int n2 = filterMappingData.getDispatcher().length;
            if (n2 == 0) {
                LOG.finer("No dispatcher, continue");
                continue;
            }
            String[] stringArray = new String[n2];
            FilterMappingData.Dispatcher[] dispatcherArray = filterMappingData.getDispatcher();
            for (int j = 0; j < n2; ++j) {
                stringArray[j] = dispatcherArray[j].toString();
            }
            try {
                filterMappingArray[i].setDispatcher(stringArray);
                continue;
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "Failed to set dispatcher", exception);
            }
        }
        this.webApp.setFilterMapping(filterMappingArray);
    }

    @Override
    void setAddToDD(boolean bl) {
        this.addToDD = bl;
    }

    @Override
    boolean isAddToDD() {
        return this.addToDD;
    }

    @Override
    String getErrorMessage() {
        return this.errorMessage;
    }

    private String checkServletMappig(String string) {
        if (!string.matches("[\\*/].*")) {
            return NbBundle.getMessage(ServletData.class, (String)"MSG_WrongUriStart");
        }
        if (string.length() > 1 && string.endsWith("/")) {
            return NbBundle.getMessage(ServletData.class, (String)"MSG_WrongUriEnd");
        }
        if (string.matches(".*\\*.*\\*.*")) {
            return NbBundle.getMessage(ServletData.class, (String)"MSG_TwoAsterisks");
        }
        if (string.matches("..*\\*..*")) {
            return NbBundle.getMessage(ServletData.class, (String)"MSG_AsteriskInTheMiddle");
        }
        if (string.length() > 1 && !ServletData.isRFC2396URI(string.substring(1))) {
            return NbBundle.getMessage(ServletData.class, (String)"MSG_WrongUri");
        }
        return null;
    }

    static String getRFC2396URI(String string) {
        if (ServletData.isRFC2396URI(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (ServletData.isRFC2396URI(stringBuilder.substring(i, i + 1))) continue;
            stringBuilder.replace(i, i + 1, "_");
        }
        return stringBuilder.toString();
    }

    private static boolean isRFC2396URI(String string) {
        return VALID_URI_PATTERN.matcher(string).matches();
    }
}

