/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.io.InputStream;
import org.jruby.util.ByteList;
import org.jvyamlb.DefaultYAMLConfig;
import org.jvyamlb.DefaultYAMLFactory;
import org.jvyamlb.PositioningComposerImpl;
import org.jvyamlb.PositioningParser;
import org.jvyamlb.PositioningParserImpl;
import org.jvyamlb.PositioningScanner;
import org.jvyamlb.PositioningScannerImpl;
import org.jvyamlb.Resolver;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.YAMLConfig;
import org.jvyamlb.YAMLFactory;
import org.jvyamlb.exceptions.PositionedParserException;
import org.jvyamlb.nodes.Node;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParseEvent;
import org.netbeans.modules.gsf.api.ParseListener;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.PositionManager;
import org.netbeans.modules.gsf.api.Severity;
import org.netbeans.modules.gsf.api.SourceFileReader;
import org.netbeans.modules.gsf.spi.DefaultError;
import org.netbeans.modules.languages.yaml.YamlParserResult;
import org.netbeans.modules.languages.yaml.YamlTokenId;

public class YamlParser
implements Parser {
    private static String asString(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return (String)charSequence;
        }
        return ((Object)charSequence).toString();
    }

    public static Node load(String string, InputStream inputStream, YAMLFactory yAMLFactory, YAMLConfig yAMLConfig) {
        ByteList byteList;
        try {
            byteList = new ByteList(ByteList.plain((CharSequence)string), false);
        }
        catch (Exception exception) {
            return null;
        }
        PositioningComposerImpl positioningComposerImpl = new PositioningComposerImpl((PositioningParser)new PositioningParserImpl((PositioningScanner)new PositioningScannerImpl(byteList)), (Resolver)new ResolverImpl());
        return positioningComposerImpl.getNode();
    }

    private ParserResult parse(String string, ParserFile parserFile) {
        try {
            Node node = YamlParser.load(string, null, (YAMLFactory)new DefaultYAMLFactory(), (YAMLConfig)new DefaultYAMLConfig());
            return new YamlParserResult(node, this, parserFile);
        }
        catch (Exception exception) {
            Object object;
            int n = 0;
            if (exception instanceof PositionedParserException) {
                object = (PositionedParserException)exception;
                n = object.getPosition().offset;
            }
            object = new YamlParserResult(null, this, parserFile);
            String string2 = exception.getMessage();
            if (string2 != null) {
                DefaultError defaultError = new DefaultError(null, string2, null, parserFile.getFileObject(), n, n, Severity.ERROR);
                object.addError((Error)defaultError);
            }
            return object;
        }
    }

    public void parseFiles(Parser.Job job) {
        ParseListener parseListener = job.listener;
        SourceFileReader sourceFileReader = job.reader;
        for (ParserFile parserFile : job.files) {
            CharSequence charSequence;
            ParseEvent parseEvent = new ParseEvent(ParseEvent.Kind.PARSE, parserFile, null);
            parseListener.started(parseEvent);
            ParserResult parserResult = null;
            try {
                charSequence = sourceFileReader.read(parserFile);
                String string = YamlParser.asString(charSequence);
                StringBuilder stringBuilder = new StringBuilder();
                TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)string, YamlTokenId.language());
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                int n = 0;
                tokenSequence.move(n);
                while (tokenSequence.moveNext()) {
                    Token token = tokenSequence.token();
                    TokenId tokenId = token.id();
                    if (tokenId == YamlTokenId.RUBY_EXPR) {
                        String string2 = "__";
                        stringBuilder.append(string2);
                        int n2 = token.length() - string2.length();
                        for (int i = 0; i < n2; ++i) {
                            stringBuilder.append(' ');
                        }
                        continue;
                    }
                    if (tokenId == YamlTokenId.RUBY || tokenId == YamlTokenId.RUBYCOMMENT || tokenId == YamlTokenId.DELIMITER) {
                        for (int i = 0; i < token.length(); ++i) {
                            stringBuilder.append(' ');
                        }
                        continue;
                    }
                    stringBuilder.append(((Object)token.text()).toString());
                }
                string = stringBuilder.toString();
                parserResult = this.parse(string, parserFile);
            }
            catch (Exception exception) {
                parseListener.exception(exception);
            }
            charSequence = new ParseEvent(ParseEvent.Kind.PARSE, parserFile, parserResult);
            parseListener.finished((ParseEvent)charSequence);
        }
    }

    public PositionManager getPositionManager() {
        return new YamlPositionManager();
    }

    private class YamlPositionManager
    implements PositionManager {
        private YamlPositionManager() {
        }

        public OffsetRange getOffsetRange(CompilationInfo compilationInfo, ElementHandle elementHandle) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

