/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.builder;

import java.util.ArrayList;
import org.netbeans.modules.jdbcwizard.builder.Parameter;
import org.netbeans.modules.jdbcwizard.builder.ResultSetColumns;

public class Procedure {
    public static final String PROCEDURE = "PROCEDURE";
    public static final String FUNCTION = "FUNCTION";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String IN = "IN";
    public static final String INOUT = "INOUT";
    public static final String OUT = "OUT";
    public static final String RETURN = "RETURN";
    public static final String RESULT = "RESULT";
    public static final String[] PROCTYPES = new String[]{"PROCEDURE", "FUNCTION", "UNKNOWN"};
    public static final String[] PARAMTYPES = new String[]{"IN", "INOUT", "OUT", "RETURN", "RESULT"};
    private String name = "";
    private String javaName = "";
    private String catalog = "";
    private String schema = "";
    private String type = "";
    private int numParameters = 0;
    private Parameter[] parameters;
    private boolean hasReturn = false;
    private ArrayList resultSetColumns = new ArrayList();

    public Procedure(String string, String string2, String string3, String string4) {
        this.name = string;
        this.catalog = string2;
        this.schema = string3;
        this.type = string4;
    }

    public Procedure(String string, String string2, String string3, String string4, String string5) {
        this.name = string;
        this.javaName = string2;
        this.catalog = string3;
        this.schema = string4;
        this.type = string5;
    }

    public Procedure(Procedure procedure) {
        this.name = procedure.getName();
        this.javaName = procedure.getJavaName();
        this.catalog = procedure.getCatalog();
        this.schema = procedure.getSchema();
        this.type = procedure.getType();
        this.hasReturn = procedure.getHasReturn();
        this.cloneParameters(procedure.getParameters());
    }

    public String getName() {
        return this.name;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getType() {
        return this.type;
    }

    public int getNumParameters() {
        return this.numParameters;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public boolean getHasReturn() {
        return this.hasReturn;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setJavaName(String string) {
        this.javaName = string;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setParameters(Parameter[] parameterArray) {
        this.parameters = parameterArray;
        this.numParameters = this.parameters != null ? this.parameters.length : 0;
    }

    public void cloneParameters(Parameter[] parameterArray) {
        if (parameterArray != null) {
            this.numParameters = parameterArray.length;
            if (this.numParameters > 0) {
                this.parameters = new Parameter[this.numParameters];
                for (int i = 0; i < this.numParameters; ++i) {
                    this.parameters[i] = new Parameter(parameterArray[i]);
                }
            }
        }
    }

    public void setHasReturn(boolean bl) {
        this.hasReturn = bl;
    }

    public void setResultSetColumns(ResultSetColumns[] resultSetColumnsArray) {
        this.resultSetColumns = new ArrayList();
        for (int i = 0; i < resultSetColumnsArray.length; ++i) {
            this.resultSetColumns.add(resultSetColumnsArray[i]);
        }
    }

    public void setResultSetColumns(ArrayList arrayList) {
        this.resultSetColumns = arrayList;
    }

    public void addResultSet(ResultSetColumns resultSetColumns) {
        this.resultSetColumns.add(resultSetColumns);
    }

    public boolean removeResultSet(ResultSetColumns resultSetColumns) {
        ResultSetColumns resultSetColumns2 = this.searchResultSetColumns(resultSetColumns.getName());
        if (resultSetColumns2 != null) {
            this.resultSetColumns.remove(resultSetColumns2);
            return true;
        }
        return false;
    }

    public ResultSetColumns[] getResultSetColumnsArray() {
        Object[] objectArray = this.resultSetColumns.toArray();
        ResultSetColumns[] resultSetColumnsArray = new ResultSetColumns[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            ResultSetColumns resultSetColumns;
            resultSetColumnsArray[i] = resultSetColumns = (ResultSetColumns)objectArray[i];
        }
        return resultSetColumnsArray;
    }

    public ArrayList getResultSetColumns() {
        return this.resultSetColumns;
    }

    public ResultSetColumns searchResultSetColumns(String string) {
        if (this.resultSetColumns != null) {
            for (ResultSetColumns resultSetColumns : this.resultSetColumns) {
                if (!resultSetColumns.getName().equals(string)) continue;
                return resultSetColumns;
            }
        }
        return null;
    }
}

