/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.builder.dbmodel.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBColumn;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBTable;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.ForeignKey;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.PrimaryKey;
import org.openide.util.NbBundle;

public class ForeignKeyImpl
implements ForeignKey,
Cloneable {
    private String fkName;
    private String pkName;
    private List fkColumnNames = new ArrayList();
    private List pkColumnNames = new ArrayList();
    private String pkTable;
    private String pkSchema;
    private String pkCatalog;
    private int updateRule;
    private int deleteRule;
    private int deferrability;
    private DBTable parent;

    public ForeignKeyImpl(DBTable dBTable, String string, String string2, String string3, String string4, String string5, int n, int n2, int n3) {
        this.parent = dBTable;
        this.fkName = string;
        this.pkName = string2;
        this.pkTable = string3;
        this.pkSchema = string4;
        this.pkCatalog = string5;
        this.updateRule = n;
        this.deleteRule = n2;
        this.deferrability = n3;
    }

    public ForeignKeyImpl(ForeignKey foreignKey) {
        if (foreignKey == null) {
            ResourceBundle resourceBundle = NbBundle.getBundle(ForeignKeyImpl.class);
            throw new IllegalArgumentException(resourceBundle.getString("ERROR_NULL_FK") + "ERROR_NULL_FK");
        }
        this.copyFrom(foreignKey);
    }

    public String getName() {
        return this.fkName;
    }

    public String getPKName() {
        return this.pkName;
    }

    public List getColumnNames() {
        return Collections.unmodifiableList(this.fkColumnNames);
    }

    public void setColumnNames(Column[] columnArray) {
        this.fkColumnNames.clear();
        this.pkColumnNames.clear();
        if (columnArray == null) {
            return;
        }
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            this.fkColumnNames.add(column.getName());
            this.pkColumnNames.add(column.getPKColumnName());
        }
    }

    public void setColumnNames(List list) {
        this.fkColumnNames.clear();
        this.pkColumnNames.clear();
        if (list == null) {
            return;
        }
        for (Column column : list) {
            this.fkColumnNames.add(column.getName());
            this.pkColumnNames.add(column.getPKColumnName());
        }
    }

    public void setColumnNames(List list, List list2) {
        this.fkColumnNames.clear();
        this.pkColumnNames.clear();
        if (list == null && list2 == null) {
            return;
        }
        if (list.size() != list2.size()) {
            ResourceBundle resourceBundle = NbBundle.getBundle(ForeignKeyImpl.class);
            throw new IllegalArgumentException(resourceBundle.getString("ERROR_SIZE_PK_FK") + "ERROR_SIZE_PK_FK");
        }
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            String string2 = (String)list2.get(listIterator.previousIndex());
            if (string == null || string2 == null) continue;
            this.fkColumnNames.add(string);
            this.pkColumnNames.add(string2);
        }
    }

    public List getPKColumnNames() {
        return Collections.unmodifiableList(this.pkColumnNames);
    }

    public String getMatchingPKColumn(String string) {
        ListIterator listIterator = this.fkColumnNames.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            if (!string2.equals(string.trim())) continue;
            return (String)this.pkColumnNames.get(listIterator.previousIndex());
        }
        return null;
    }

    public String getPKTable() {
        return this.pkTable;
    }

    public String getPKSchema() {
        return this.pkSchema;
    }

    public String getPKCatalog() {
        return this.pkCatalog;
    }

    public int getUpdateRule() {
        return this.updateRule;
    }

    public int getDeleteRule() {
        return this.deleteRule;
    }

    public int getDeferrability() {
        return this.deferrability;
    }

    public DBTable getParent() {
        return this.parent;
    }

    public void setParent(DBTable dBTable) {
        this.parent = dBTable;
    }

    public boolean contains(String string) {
        return this.fkColumnNames.contains(string);
    }

    public boolean contains(DBColumn dBColumn) {
        return this.contains(dBColumn.getName());
    }

    public boolean references(PrimaryKey primaryKey) {
        if (primaryKey == null) {
            return false;
        }
        List list = primaryKey.getColumnNames();
        DBTable dBTable = primaryKey.getParent();
        return this.references(dBTable) && list.containsAll(this.pkColumnNames) && this.pkColumnNames.containsAll(list);
    }

    public boolean references(DBTable dBTable) {
        return dBTable != null ? this.references(dBTable.getName(), dBTable.getSchema(), dBTable.getCatalog()) : false;
    }

    public boolean references(String string, String string2, String string3) {
        boolean bl;
        boolean bl2;
        boolean bl3 = string != null ? string.equals(this.pkTable) : (bl2 = this.pkTable == null);
        boolean bl4 = string2 != null ? string2.equals(this.pkSchema) : (bl = this.pkSchema == null);
        boolean bl5 = string3 != null ? string3.equals(this.pkCatalog) : this.pkCatalog == null;
        return bl2 && bl && bl5;
    }

    public Object clone() {
        try {
            ForeignKeyImpl foreignKeyImpl = (ForeignKeyImpl)super.clone();
            foreignKeyImpl.pkColumnNames = new ArrayList(this.pkColumnNames);
            foreignKeyImpl.fkColumnNames = new ArrayList(this.fkColumnNames);
            return foreignKeyImpl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (!(object instanceof ForeignKeyImpl)) {
            return false;
        }
        ForeignKeyImpl foreignKeyImpl = (ForeignKeyImpl)object;
        boolean bl2 = this.fkName != null ? this.fkName.equals(foreignKeyImpl.fkName) : (bl = foreignKeyImpl.fkName == null);
        bl &= this.pkName != null ? this.pkName.equals(foreignKeyImpl.pkName) : foreignKeyImpl.pkName == null;
        bl &= this.pkTable != null ? this.pkTable.equals(foreignKeyImpl.pkTable) : foreignKeyImpl.pkTable == null;
        bl &= this.pkSchema != null ? this.pkSchema.equals(foreignKeyImpl.pkSchema) : foreignKeyImpl.pkSchema == null;
        bl &= this.pkCatalog != null ? this.pkCatalog.equals(foreignKeyImpl.pkCatalog) : foreignKeyImpl.pkCatalog == null;
        bl &= this.updateRule == foreignKeyImpl.updateRule && this.deleteRule == foreignKeyImpl.deleteRule && this.deferrability == foreignKeyImpl.deferrability;
        bl &= this.pkColumnNames != null ? ((Object)this.pkColumnNames).equals(foreignKeyImpl.pkColumnNames) : foreignKeyImpl.pkColumnNames != null;
        return bl &= this.fkColumnNames != null ? ((Object)this.fkColumnNames).equals(foreignKeyImpl.fkColumnNames) : foreignKeyImpl.fkColumnNames != null;
    }

    public int hashCode() {
        int n = this.fkName != null ? this.fkName.hashCode() : 0;
        n += this.pkName != null ? this.pkName.hashCode() : 0;
        n += this.pkTable != null ? this.pkTable.hashCode() : 0;
        n += this.pkSchema != null ? this.pkSchema.hashCode() : 0;
        n += this.pkCatalog != null ? this.pkCatalog.hashCode() : 0;
        n += this.updateRule + this.deleteRule + this.deferrability;
        n += this.fkColumnNames != null ? ((Object)this.fkColumnNames).hashCode() : 0;
        return n += this.pkColumnNames != null ? ((Object)this.pkColumnNames).hashCode() : 0;
    }

    public int getColumnCount() {
        return this.fkColumnNames.size();
    }

    public String getColumnName(int n) {
        return (String)this.fkColumnNames.get(n);
    }

    public int getSequence(DBColumn dBColumn) {
        if (dBColumn == null || dBColumn.getName() == null) {
            return -1;
        }
        return this.fkColumnNames.indexOf(dBColumn.getName().trim());
    }

    private void copyFrom(ForeignKey foreignKey) {
        this.parent = foreignKey.getParent();
        this.fkName = foreignKey.getName();
        this.fkColumnNames.clear();
        this.fkColumnNames.addAll(foreignKey.getColumnNames());
        this.pkName = foreignKey.getPKName();
        this.pkCatalog = foreignKey.getPKCatalog();
        this.pkSchema = foreignKey.getPKSchema();
        this.pkTable = foreignKey.getPKTable();
        this.pkColumnNames.clear();
        this.pkColumnNames.addAll(foreignKey.getPKColumnNames());
        this.updateRule = foreignKey.getUpdateRule();
        this.deleteRule = foreignKey.getDeleteRule();
        this.deferrability = foreignKey.getDeferrability();
    }

    public static class Column
    implements Comparable {
        private String name;
        private int sequence;
        private String pkColumnName;

        public Column(String string, int n, String string2) {
            ResourceBundle resourceBundle = NbBundle.getBundle(ForeignKeyImpl.class);
            if (string == null || string.trim().length() == 0) {
                throw new IllegalArgumentException(resourceBundle.getString("ERROR_COL_NAME") + "ERROR_COL_NAME");
            }
            if (string2 == null || string2.trim().length() == 0) {
                throw new IllegalArgumentException(resourceBundle.getString("ERROR_PK_COLNAME") + "ERROR_PK_COLNAME");
            }
            if (n <= 0) {
                throw new IllegalArgumentException(resourceBundle.getString("ERROR_COL_SEQ") + "ERROR_COL_SEQ");
            }
            this.name = string.trim();
            this.sequence = n;
            this.pkColumnName = string2.trim();
        }

        public String getName() {
            return this.name;
        }

        public int getSequence() {
            return this.sequence;
        }

        public String getPKColumnName() {
            return this.pkColumnName;
        }

        public int compareTo(Object object) {
            return this.sequence - ((Column)object).sequence;
        }
    }
}

