/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.jdbcwizard.wizards.SimpleTargetChooserPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class SimpleTargetChooserPanel
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private final List listeners = new ArrayList();
    private SimpleTargetChooserPanelGUI gui;
    private Project project;
    private SourceGroup[] folders;
    private final WizardDescriptor.Panel bottomPanel;
    private WizardDescriptor wizard;
    private final boolean isFolder;

    SimpleTargetChooserPanel(Project project, SourceGroup[] sourceGroupArray, WizardDescriptor.Panel panel, boolean bl) {
        this.folders = sourceGroupArray;
        this.project = project;
        this.bottomPanel = panel;
        if (panel != null) {
            panel.addChangeListener((ChangeListener)this);
        }
        this.isFolder = bl;
        this.gui = null;
    }

    public boolean isFinishPanel() {
        return true;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new SimpleTargetChooserPanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), this.isFolder);
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(SimpleTargetChooserPanel.class);
    }

    private String canUseFileName(FileObject fileObject, String string, String string2, String string3) {
        CharSequence charSequence;
        if (string3 != null && string3.length() > 0) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(string2);
            ((StringBuffer)charSequence).append('.');
            ((StringBuffer)charSequence).append(string3);
            string2 = ((StringBuffer)charSequence).toString();
        }
        CharSequence charSequence2 = charSequence = string == null ? string2 : string + "/" + string2;
        if (fileObject == null) {
            return NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        if (!fileObject.canWrite()) {
            return NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_fs_is_readonly");
        }
        if (SimpleTargetChooserPanel.existFileName(fileObject, (String)charSequence)) {
            return NbBundle.getMessage(SimpleTargetChooserPanel.class, (String)"MSG_file_already_exist", (Object)string2);
        }
        return null;
    }

    private static boolean existFileName(FileObject fileObject, String string) {
        boolean bl = false;
        File file = FileUtil.toFile((FileObject)fileObject);
        bl = file.exists() ? new File(file, string).exists() : fileObject.getFileObject(string) != null;
        return bl;
    }

    public boolean isValid() {
        boolean bl;
        boolean bl2 = bl = this.gui != null && this.gui.getTargetName() != null && (this.bottomPanel == null || this.bottomPanel.isValid());
        if (!bl) {
            return false;
        }
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)this.wizard);
        String string = this.canUseFileName(this.gui.getTargetGroup().getRootFolder(), this.gui.getTargetFolder(), this.gui.getTargetName(), fileObject.getExt());
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)string);
        return string == null;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList arrayList;
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList(this.listeners);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            ((ChangeListener)object.next()).stateChanged(changeEvent);
        }
    }

    public void readSettings(Object object) {
        this.wizard = (WizardDescriptor)object;
        if (this.gui == null) {
            this.getComponent();
        }
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        this.gui.initValues(Templates.getTemplate((WizardDescriptor)this.wizard), fileObject);
        Object object2 = this.gui.getClientProperty("NewDtelWizard_Title");
        if (object2 != null) {
            this.wizard.putProperty("NewDtelWizard_Title", object2);
        }
        this.wizard.putProperty("WizardPanel_contentData", (Object)new String[]{NbBundle.getBundle(SimpleTargetChooserPanel.class).getString("LBL_TemplatesPanel_Name"), NbBundle.getBundle(SimpleTargetChooserPanel.class).getString("LBL_SimpleTargetChooserPanel_Name")});
        if (this.bottomPanel != null) {
            this.bottomPanel.readSettings(object);
        }
    }

    public void storeSettings(Object object) {
        if (WizardDescriptor.PREVIOUS_OPTION.equals(((WizardDescriptor)object).getValue())) {
            return;
        }
        if (this.isValid()) {
            if (this.bottomPanel != null) {
                this.bottomPanel.storeSettings(object);
            }
            Templates.setTargetFolder((WizardDescriptor)((WizardDescriptor)object), (FileObject)this.getTargetFolderFromGUI());
            Templates.setTargetName((WizardDescriptor)((WizardDescriptor)object), (String)this.gui.getTargetName());
        }
        ((WizardDescriptor)object).putProperty("collaboration_name", (Object)this.gui.getTargetName());
        ((WizardDescriptor)object).putProperty("targetfolder_path", (Object)FileUtil.toFile((FileObject)this.getTargetFolderFromGUI()).getAbsolutePath());
        ((WizardDescriptor)object).putProperty("NewDtelWizard_Title", null);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChange();
    }

    private FileObject getTargetFolderFromGUI() {
        FileObject fileObject = this.gui.getTargetGroup().getRootFolder();
        String string = this.gui.getTargetFolder();
        FileObject fileObject2 = string == null ? fileObject : fileObject.getFileObject(string);
        if (fileObject2 == null) {
            try {
                fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return fileObject2;
    }
}

