/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.awt.Dialog;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.php.editor.codegen.CGSInfo;
import org.netbeans.modules.php.editor.codegen.Property;
import org.netbeans.modules.php.editor.codegen.ui.ConstructorPanel;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CGSGenerator
implements CodeGenerator {
    protected static final String START_OF_GETTER = "get";
    protected static final String START_OF_SETTER = "set";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String PROPERTY = "${PROPERTY}";
    private static final String PARAMS = "${PARAMS}";
    private static final String ASSIGNMENTS = "${ASSIGNMENT}";
    private static final String CONSTRUCTOR_TEMPLATE = "function __construct(${PARAMS}) {${ASSIGNMENT}" + NEW_LINE + "}" + NEW_LINE;
    private static final String ASSIGNMENT_TEMPLATE = NEW_LINE + "$this->" + "${PROPERTY}" + " = $" + "${PROPERTY}" + ";";
    private static final String UP_FIRST_LETTER_PROPERTY = "${UpFirstLetterProperty}";
    private static final String GETTER_TEMPLATE = "public function get${UpFirstLetterProperty}() {" + NEW_LINE + "return $$this->" + "${PROPERTY}" + ";" + NEW_LINE + "}" + NEW_LINE;
    private static final String SETTER_TEMPLATE = "public function set${UpFirstLetterProperty}($$${PROPERTY}) {" + ASSIGNMENT_TEMPLATE + NEW_LINE + "}" + NEW_LINE;
    private final GenType type;
    private final CGSInfo cgsInfo;
    private final JTextComponent component;

    private CGSGenerator(JTextComponent jTextComponent, CGSInfo cGSInfo, GenType genType) {
        this.type = genType;
        this.cgsInfo = cGSInfo;
        this.component = jTextComponent;
    }

    public void invoke() {
        String string = null;
        String string2 = null;
        List<Property> list = null;
        switch (this.type) {
            case CONSTRUCTOR: {
                string = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_CONSTRUCTOR");
                string2 = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_CONSTRUCTOR");
                list = this.cgsInfo.getProperties();
                break;
            }
            case GETTER: {
                string = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_GETTERS");
                string2 = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_GETTERS");
                list = this.cgsInfo.getPossibleGetters();
                break;
            }
            case SETTER: {
                string = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_SETTERS");
                string2 = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_SETTERS");
                list = this.cgsInfo.getPossibleSetters();
                break;
            }
            case GETTER_AND_SETTER: {
                string = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_TITLE_GETTERS_AND_SETTERS");
                string2 = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_PANEL_GETTERS_AND_SETTERS");
                list = this.cgsInfo.getPossibleGettersSetters();
            }
        }
        ConstructorPanel constructorPanel = new ConstructorPanel(this.cgsInfo.getClassName(), list, string2);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)constructorPanel, string);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        dialog.dispose();
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            CodeTemplateManager codeTemplateManager = CodeTemplateManager.get((Document)this.component.getDocument());
            CodeTemplate codeTemplate = codeTemplateManager.createTemporary(this.getTemplateText());
            codeTemplate.insert(this.component);
        }
    }

    public String getDisplayName() {
        String string = null;
        switch (this.type) {
            case CONSTRUCTOR: {
                string = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_CONSTRUCTOR");
                break;
            }
            case GETTER: {
                string = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_GETTER");
                break;
            }
            case SETTER: {
                string = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_SETTER");
                break;
            }
            case GETTER_AND_SETTER: {
                string = NbBundle.getMessage(CGSGenerator.class, (String)"LBL_GETTER_AND_SETTER");
            }
        }
        return string;
    }

    private String getTemplateText() {
        String string = null;
        switch (this.type) {
            case CONSTRUCTOR: {
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                for (Property property : this.cgsInfo.getProperties()) {
                    String string2 = property.getName();
                    if (!property.isSelected()) continue;
                    stringBuffer.append(", $").append(string2);
                    stringBuffer2.append(ASSIGNMENT_TEMPLATE.replace(PROPERTY, string2));
                }
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(", ");
                }
                string = CONSTRUCTOR_TEMPLATE.replace(PARAMS, stringBuffer.toString().substring(2)).replace(ASSIGNMENTS, stringBuffer2);
                break;
            }
            case GETTER: {
                StringBuffer stringBuffer = new StringBuffer();
                for (Property property : this.cgsInfo.getPossibleGetters()) {
                    if (!property.isSelected()) continue;
                    String string3 = property.getName();
                    stringBuffer.append(GETTER_TEMPLATE.replace(PROPERTY, string3).replace(UP_FIRST_LETTER_PROPERTY, this.upFirstLetter(string3)));
                    stringBuffer.append(NEW_LINE);
                }
                string = stringBuffer.toString();
                break;
            }
            case SETTER: {
                StringBuffer stringBuffer = new StringBuffer();
                for (Property property : this.cgsInfo.getPossibleSetters()) {
                    if (!property.isSelected()) continue;
                    String string4 = property.getName();
                    stringBuffer.append(SETTER_TEMPLATE.replace(PROPERTY, string4).replace(UP_FIRST_LETTER_PROPERTY, this.upFirstLetter(string4)));
                    stringBuffer.append(NEW_LINE);
                }
                string = stringBuffer.toString();
                break;
            }
            case GETTER_AND_SETTER: {
                StringBuffer stringBuffer = new StringBuffer();
                for (Property property : this.cgsInfo.getPossibleSetters()) {
                    if (!property.isSelected()) continue;
                    String string5 = property.getName();
                    stringBuffer.append(GETTER_TEMPLATE.replace(PROPERTY, string5).replace(UP_FIRST_LETTER_PROPERTY, this.upFirstLetter(string5)));
                    stringBuffer.append(NEW_LINE);
                    stringBuffer.append(SETTER_TEMPLATE.replace(PROPERTY, string5).replace(UP_FIRST_LETTER_PROPERTY, this.upFirstLetter(string5)));
                    stringBuffer.append(NEW_LINE);
                }
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    private String upFirstLetter(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup lookup) {
            JTextComponent jTextComponent = (JTextComponent)lookup.lookup(JTextComponent.class);
            ArrayList<CGSGenerator> arrayList = new ArrayList<CGSGenerator>();
            CGSInfo cGSInfo = CGSInfo.getCGSInfo(jTextComponent);
            if (cGSInfo.getClassName() != null) {
                if (!cGSInfo.hasConstructor()) {
                    arrayList.add(new CGSGenerator(jTextComponent, cGSInfo, GenType.CONSTRUCTOR));
                }
                if (cGSInfo.getPossibleGetters().size() > 0) {
                    arrayList.add(new CGSGenerator(jTextComponent, cGSInfo, GenType.GETTER));
                }
                if (cGSInfo.getPossibleSetters().size() > 0) {
                    arrayList.add(new CGSGenerator(jTextComponent, cGSInfo, GenType.SETTER));
                }
                if (cGSInfo.getPossibleGettersSetters().size() > 0) {
                    arrayList.add(new CGSGenerator(jTextComponent, cGSInfo, GenType.GETTER_AND_SETTER));
                }
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GenType {
        CONSTRUCTOR,
        GETTER,
        SETTER,
        GETTER_AND_SETTER;

    }
}

