/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.embedding;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.html.editor.gsf.embedding.CssModel;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;

public class CssPhpModel
extends CssModel {
    private static final Logger LOGGER = Logger.getLogger(CssPhpModel.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);

    public static CssPhpModel get(Document document) {
        CssPhpModel cssPhpModel = (CssPhpModel)((Object)document.getProperty(CssPhpModel.class));
        if (cssPhpModel == null) {
            cssPhpModel = new CssPhpModel(document);
            document.putProperty(CssPhpModel.class, (Object)cssPhpModel);
        }
        return cssPhpModel;
    }

    private CssPhpModel(Document document) {
        super(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCode() {
        if (this.documentDirty) {
            this.documentDirty = false;
            this.codeBlocks.clear();
            StringBuilder stringBuilder = new StringBuilder();
            BaseDocument baseDocument = (BaseDocument)this.doc;
            try {
                baseDocument.readLock();
                this.extractCssFromPHP(this.doc, stringBuilder);
            }
            finally {
                baseDocument.readUnlock();
            }
            this.code = stringBuilder.toString();
        }
        if (LOG) {
            LOGGER.log(Level.FINE, this.dumpCode());
        }
        this.dumpCode();
        return this.code;
    }

    private void extractCssFromPHP(Document document, StringBuilder stringBuilder) {
        HashMap hashMap = new HashMap(6);
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.moveStart();
        block0: while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            if (token.id() == PHPTokenId.T_INLINE_HTML) {
                TokenSequence tokenSequence2 = tokenSequence.embedded();
                tokenSequence2.moveStart();
                this.extractCssFromHTML(tokenSequence2, stringBuilder, hashMap);
                continue;
            }
            if (hashMap.get("in_style") == null && hashMap.get("in_inlined_style") == null) continue;
            int n = tokenSequence.offset();
            while (tokenSequence.moveNext()) {
                token = tokenSequence.token();
                if (token.id() != PHPTokenId.T_INLINE_HTML) continue;
                tokenSequence.movePrevious();
                int n2 = tokenSequence.offset() + tokenSequence.token().length();
                int n3 = stringBuilder.length();
                stringBuilder.append("PHP_CODE");
                int n4 = stringBuilder.length();
                CssModel.CodeBlockData codeBlockData = new CssModel.CodeBlockData((CssModel)this, n, n2, n3, n4);
                this.codeBlocks.add(codeBlockData);
                continue block0;
            }
        }
    }
}

