/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.SourceModel;
import org.netbeans.modules.gsf.api.SourceModelFactory;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.nav.SemiAttribute;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.GlobalStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.StaticStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratingBracketCompleter {
    static final String TYPE_PLACEHOLDER = "<type>";
    private static final SemiAttribute.AttributedType PRINT_NO_TYPE = new SemiAttribute.AttributedType(){

        public String getTypeName() {
            return null;
        }
    };

    static void generateDocTags(final BaseDocument baseDocument, final int n, final int n2) {
        FileObject fileObject = NavUtils.getFile((Document)baseDocument);
        if (fileObject == null) {
            return;
        }
        SourceModel sourceModel = SourceModelFactory.getInstance().getModel(fileObject);
        try {
            sourceModel.runUserActionTask((CancellableTask)new CancellableTask<CompilationInfo>(){

                public void cancel() {
                }

                public void run(final CompilationInfo compilationInfo) throws Exception {
                    class Result
                    extends Error {
                        private ASTNode node;

                        public Result(ASTNode aSTNode) {
                            this.node = aSTNode;
                        }
                    }
                    SemiAttribute.AttributedElement attributedElement;
                    Assignment assignment;
                    ASTNode aSTNode = null;
                    try {
                        new DefaultVisitor(){

                            public void scan(ASTNode aSTNode) {
                                Comment comment;
                                if (aSTNode != null && (comment = Utils.getCommentForNode(Utils.getRoot(compilationInfo), aSTNode)) != null && comment.getStartOffset() <= n && n <= comment.getEndOffset()) {
                                    throw new Result(aSTNode);
                                }
                                super.scan(aSTNode);
                            }
                        }.scan(Utils.getRoot(compilationInfo));
                    }
                    catch (Result result) {
                        aSTNode = result.node;
                    }
                    if (aSTNode == null) {
                        return;
                    }
                    if (aSTNode instanceof FunctionDeclaration) {
                        GeneratingBracketCompleter.generateFunctionDoc(baseDocument, n, n2, compilationInfo, (FunctionDeclaration)aSTNode);
                    }
                    if (aSTNode instanceof MethodDeclaration) {
                        GeneratingBracketCompleter.generateFunctionDoc(baseDocument, n, n2, compilationInfo, ((MethodDeclaration)aSTNode).getFunction());
                    }
                    if (aSTNode instanceof ExpressionStatement && ((ExpressionStatement)aSTNode).getExpression() instanceof Assignment && (assignment = (Assignment)((ExpressionStatement)aSTNode).getExpression()).getLeftHandSide() instanceof ArrayAccess && (attributedElement = SemiAttribute.semiAttribute(compilationInfo).getElement(assignment.getLeftHandSide())) != null && attributedElement.getKind() == SemiAttribute.AttributedElement.Kind.VARIABLE) {
                        GeneratingBracketCompleter.generateVariableDoc(baseDocument, n, n2, compilationInfo, attributedElement);
                    }
                    if (aSTNode instanceof FieldsDeclaration) {
                        GeneratingBracketCompleter.generateFieldDoc(baseDocument, n, n2, compilationInfo, (FieldsDeclaration)aSTNode);
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static void generateFunctionDoc(BaseDocument baseDocument, int n, int n2, CompilationInfo compilationInfo, FunctionDeclaration functionDeclaration) throws BadLocationException {
        StringBuilder stringBuilder = new StringBuilder();
        ScannerImpl scannerImpl = new ScannerImpl(compilationInfo, functionDeclaration);
        scannerImpl.scan(functionDeclaration);
        GeneratingBracketCompleter.addVariables(stringBuilder, "@global", n2, scannerImpl.globals);
        GeneratingBracketCompleter.addVariables(stringBuilder, "@staticvar", n2, scannerImpl.staticvars);
        for (FormalParameter formalParameter : functionDeclaration.getFormalParameters()) {
            Variable variable;
            String string = "";
            if (formalParameter.getParameterName() instanceof Variable && (variable = (Variable)formalParameter.getParameterName()).getName() instanceof Identifier) {
                string = ((Identifier)variable.getName()).getName();
            }
            GeneratingBracketCompleter.generateDocEntry(stringBuilder, "@param", n2, "$" + string, null);
        }
        if (scannerImpl.hasReturn) {
            GeneratingBracketCompleter.generateDocEntry(stringBuilder, "@return", n2, null, null);
        }
        baseDocument.insertString(n - 1, stringBuilder.toString(), null);
    }

    private static void addVariables(StringBuilder stringBuilder, String string, int n, List<Pair<SemiAttribute.AttributedElement, SemiAttribute.AttributedType>> list) {
        for (Pair<SemiAttribute.AttributedElement, SemiAttribute.AttributedType> pair : list) {
            GeneratingBracketCompleter.generateDocEntry(stringBuilder, string, n, "$" + pair.getA().getName(), pair.getB());
        }
    }

    private static void generateDocEntry(StringBuilder stringBuilder, String string, int n, String string2, SemiAttribute.AttributedType attributedType) {
        stringBuilder.append("\n");
        LexUtilities.indent(stringBuilder, n);
        stringBuilder.append(" * ");
        stringBuilder.append(string);
        if (attributedType != null) {
            if (attributedType != PRINT_NO_TYPE) {
                stringBuilder.append(" ");
                stringBuilder.append(attributedType.getTypeName());
            }
        } else {
            stringBuilder.append(" ");
            stringBuilder.append(TYPE_PLACEHOLDER);
        }
        if (string2 != null) {
            stringBuilder.append(" ");
            stringBuilder.append(string2);
        }
    }

    private static void generateVariableDoc(BaseDocument baseDocument, int n, int n2, CompilationInfo compilationInfo, SemiAttribute.AttributedElement attributedElement) throws BadLocationException {
        StringBuilder stringBuilder = new StringBuilder();
        GeneratingBracketCompleter.generateDocEntry(stringBuilder, "@global", n2, "$GLOBALS['" + attributedElement.getName() + "']", null);
        GeneratingBracketCompleter.generateDocEntry(stringBuilder, "@name", n2, "$" + attributedElement.getName(), PRINT_NO_TYPE);
        baseDocument.insertString(n - 1, stringBuilder.toString(), null);
    }

    private static void generateFieldDoc(BaseDocument baseDocument, int n, int n2, CompilationInfo compilationInfo, FieldsDeclaration fieldsDeclaration) throws BadLocationException {
        StringBuilder stringBuilder = new StringBuilder();
        GeneratingBracketCompleter.generateDocEntry(stringBuilder, "@var", n2, null, null);
        baseDocument.insertString(n - 1, stringBuilder.toString(), null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Pair<A, B> {
        private A a;
        private B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public A getA() {
            return this.a;
        }

        public B getB() {
            return this.b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScannerImpl
    extends DefaultVisitor {
        private List<Pair<SemiAttribute.AttributedElement, SemiAttribute.AttributedType>> globals = new LinkedList<Pair<SemiAttribute.AttributedElement, SemiAttribute.AttributedType>>();
        private List<Pair<SemiAttribute.AttributedElement, SemiAttribute.AttributedType>> staticvars = new LinkedList<Pair<SemiAttribute.AttributedElement, SemiAttribute.AttributedType>>();
        private boolean hasReturn;
        private SemiAttribute.AttributedType returnType;
        private SemiAttribute sa;
        private FunctionDeclaration decl;

        public ScannerImpl(CompilationInfo compilationInfo, FunctionDeclaration functionDeclaration) {
            this.sa = SemiAttribute.semiAttribute(compilationInfo);
            this.decl = functionDeclaration;
        }

        @Override
        public void visit(GlobalStatement globalStatement) {
            for (Variable variable : globalStatement.getVariables()) {
                this.handleVariable(variable, this.globals);
            }
            super.visit(globalStatement);
        }

        @Override
        public void visit(ReturnStatement returnStatement) {
            this.hasReturn = true;
            this.returnType = null;
        }

        @Override
        public void visit(StaticStatement staticStatement) {
            for (Variable variable : staticStatement.getVariables()) {
                this.handleVariable(variable, this.staticvars);
            }
            super.visit(staticStatement);
        }

        private void handleVariable(Variable variable, List<Pair<SemiAttribute.AttributedElement, SemiAttribute.AttributedType>> list) {
            SemiAttribute.AttributedElement attributedElement = this.sa.getElement(variable);
            if (attributedElement != null) {
                list.add(new Pair<SemiAttribute.AttributedElement, Object>(attributedElement, null));
            }
        }

        @Override
        public void visit(FunctionDeclaration functionDeclaration) {
            if (functionDeclaration == this.decl) {
                super.visit(functionDeclaration);
            }
        }

        @Override
        public void visit(ClassDeclaration classDeclaration) {
        }
    }
}

