/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.IndentTask;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;

public class PHPIndentTask
implements IndentTask {
    private Context context;

    PHPIndentTask(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindent() throws BadLocationException {
        BaseDocument baseDocument = (BaseDocument)this.context.document();
        baseDocument.atomicLock();
        baseDocument.putProperty((Object)"HTML_FORMATTER_ACTS_ON_TOP_LEVEL", (Object)Boolean.TRUE);
        try {
            if (this.context.isIndent()) {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                tokenSequence.move(this.context.caretOffset());
                if (!tokenSequence.moveNext()) {
                    return;
                }
                while (tokenSequence.embedded() != null) {
                    tokenSequence = tokenSequence.embedded();
                    tokenSequence.move(this.context.caretOffset());
                    tokenSequence.moveNext();
                }
                if (tokenSequence.language() != PHPTokenId.language()) {
                    return;
                }
                int n = Utilities.getLineOffset((BaseDocument)baseDocument, (int)this.context.startOffset());
                int n2 = 0;
                if (n > 0) {
                    int n3 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n - 1));
                    n2 = this.context.lineIndent(n3);
                }
                this.context.modifyIndent(Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n), n2);
            }
        }
        finally {
            baseDocument.atomicUnlock();
        }
    }

    public ExtraLock indentLock() {
        return null;
    }
}

