/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.php.editor.index.FunctionElement;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.PHPIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedFunction
extends IndexedElement
implements FunctionElement {
    private String arguments;
    private String[] args;
    private List<String> parameters;
    private int[] optionalArgs;
    private String returnType;

    public IndexedFunction(String string, String string2, PHPIndex pHPIndex, String string3, String string4, int n, int n2, ElementKind elementKind) {
        super(string, string2, pHPIndex, string3, n, n2, elementKind);
        this.arguments = string4;
    }

    public String toString() {
        return this.getSignature() + ":" + this.getFilenameUrl();
    }

    @Override
    public String getSignature() {
        if (this.textSignature == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.in != null) {
                stringBuilder.append(this.in);
                stringBuilder.append('.');
            }
            stringBuilder.append(this.name);
            stringBuilder.append("(");
            List<String> list = this.getParameters();
            if (list.size() > 0) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(list.get(i));
                }
            }
            stringBuilder.append(")");
            this.textSignature = stringBuilder.toString();
        }
        return this.textSignature;
    }

    public String[] getArgs() {
        if (this.args == null) {
            if (this.arguments == null || this.arguments.length() == 0) {
                return new String[0];
            }
            this.args = this.arguments.split(",");
        }
        return this.args;
    }

    @Override
    public List<String> getParameters() {
        if (this.parameters == null) {
            String[] stringArray = this.getArgs();
            if (stringArray != null && stringArray.length > 0) {
                this.parameters = new ArrayList<String>(stringArray.length);
                for (String string : stringArray) {
                    this.parameters.add(string);
                }
            } else {
                this.parameters = Collections.emptyList();
            }
        }
        return this.parameters;
    }

    public boolean isDeprecated() {
        return false;
    }

    @Override
    public String getDisplayName() {
        String string = this.getModifiersString();
        return string.length() == 0 ? this.getSignature() : this.getModifiersString() + " " + this.getSignature();
    }

    @Override
    public Set<Modifier> getModifiers() {
        return super.getModifiers();
    }

    public int[] getOptionalArgs() {
        return this.optionalArgs;
    }

    public void setOptionalArgs(int[] nArray) {
        this.optionalArgs = nArray;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String string) {
        this.returnType = string;
    }
}

