/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.text.Document;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.php.editor.nav.SemiAttribute;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.ParenthesisExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavUtils {
    public static List<ASTNode> underCaret(CompilationInfo compilationInfo, final int n) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Result
        extends Error {
            private Stack<ASTNode> result;

            public Result(Stack<ASTNode> stack) {
                this.result = stack;
            }

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        }
        try {
            new DefaultVisitor(){
                private Stack<ASTNode> s = new Stack();

                public void scan(ASTNode aSTNode) {
                    if (aSTNode == null) {
                        return;
                    }
                    if (aSTNode.getStartOffset() <= n && n <= aSTNode.getEndOffset()) {
                        this.s.push(aSTNode);
                        super.scan(aSTNode);
                        throw new Result(this.s);
                    }
                }
            }.scan(Utils.getRoot(compilationInfo));
        }
        catch (Result result) {
            return new LinkedList<ASTNode>(result.result);
        }
        return Collections.emptyList();
    }

    public static SemiAttribute.AttributedElement findElement(CompilationInfo compilationInfo, List<ASTNode> list, int n, SemiAttribute semiAttribute) {
        if (list.size() == 0) {
            return null;
        }
        list = new LinkedList<ASTNode>(list);
        Collections.reverse(list);
        SemiAttribute.AttributedElement attributedElement = null;
        ASTNode aSTNode = null;
        for (ASTNode aSTNode2 : list) {
            Object object;
            if (aSTNode2 instanceof Variable && !(aSTNode2 instanceof ArrayAccess)) {
                attributedElement = semiAttribute.getElement(aSTNode2);
                aSTNode = aSTNode2;
                continue;
            }
            if (aSTNode2 instanceof ArrayAccess && attributedElement == null) {
                return semiAttribute.getElement(aSTNode2);
            }
            if (aSTNode2 instanceof FunctionInvocation && ((FunctionInvocation)(object = (FunctionInvocation)aSTNode2)).getFunctionName().getStartOffset() <= n && n <= ((FunctionInvocation)object).getFunctionName().getEndOffset()) {
                return semiAttribute.getElement(aSTNode2);
            }
            if (aSTNode2 instanceof ClassInstanceCreation) {
                return semiAttribute.getElement(aSTNode2);
            }
            if (aSTNode2 instanceof Scalar && (object = semiAttribute.getElement(aSTNode2)) != null) {
                return object;
            }
            if (aSTNode2 instanceof FunctionDeclaration && ((FunctionDeclaration)aSTNode2).getFunctionName() == aSTNode) {
                return semiAttribute.getElement(aSTNode2);
            }
            if (aSTNode2 instanceof ClassDeclaration && ((ClassDeclaration)aSTNode2).getName() == aSTNode) {
                return semiAttribute.getElement(aSTNode2);
            }
            if (aSTNode2 instanceof FieldAccess && ((FieldAccess)(object = (FieldAccess)aSTNode2)).getMember().getStartOffset() <= n && n <= ((FieldAccess)object).getMember().getEndOffset()) {
                return semiAttribute.getElement(aSTNode2);
            }
            if (attributedElement != null) {
                return attributedElement;
            }
            aSTNode = aSTNode2;
        }
        return null;
    }

    public static boolean isQuoted(String string) {
        return !(string.length() < 2 || !string.startsWith("\"") && !string.startsWith("'") || !string.endsWith("\"") && !string.endsWith("'"));
    }

    public static String dequote(String string) {
        assert (NavUtils.isQuoted(string));
        return string.substring(1, string.length() - 1);
    }

    public static FileObject resolveInclude(CompilationInfo compilationInfo, Include include) {
        Scalar scalar;
        Expression expression = include.getExpression();
        if (expression instanceof ParenthesisExpression) {
            expression = ((ParenthesisExpression)expression).getExpression();
        }
        if (expression instanceof Scalar && Scalar.Type.STRING == (scalar = (Scalar)expression).getScalarType()) {
            String string = scalar.getStringValue();
            string = string.length() >= 2 ? string.substring(1, string.length() - 1) : string;
            return NavUtils.resolveRelativeFile(compilationInfo, string);
        }
        return null;
    }

    private static FileObject resolveRelativeFile(CompilationInfo compilationInfo, String string) {
        while (true) {
            FileObject fileObject;
            if ((fileObject = PhpSourcePath.resolveFile((FileObject)compilationInfo.getFileObject().getParent(), (String)string)) != null) {
                return fileObject;
            }
            int n = string.indexOf(47);
            if (n == -1) break;
            string = string.substring(n + 1);
        }
        return null;
    }

    public static FileObject getFile(Document document) {
        Object object = document.getProperty("stream");
        if (object instanceof DataObject) {
            DataObject dataObject = (DataObject)object;
            return dataObject.getPrimaryFile();
        }
        return null;
    }
}

