/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OccurrencesFinder;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.nav.SemiAttribute;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OccurrencesFinderImpl
implements OccurrencesFinder {
    private int offset;
    private Map<OffsetRange, ColoringAttributes> range2Attribs;

    public void setCaretPosition(int n) {
        this.offset = n;
        this.range2Attribs = new HashMap<OffsetRange, ColoringAttributes>();
    }

    public Map<OffsetRange, ColoringAttributes> getOccurrences() {
        return this.range2Attribs;
    }

    public void cancel() {
    }

    public void run(CompilationInfo compilationInfo) throws Exception {
        for (OffsetRange offsetRange : OccurrencesFinderImpl.compute(compilationInfo, this.offset)) {
            this.range2Attribs.put(offsetRange, ColoringAttributes.MARK_OCCURRENCES);
        }
    }

    static Collection<OffsetRange> compute(CompilationInfo compilationInfo, int n) {
        SemiAttribute semiAttribute;
        LinkedList<OffsetRange> linkedList = new LinkedList<OffsetRange>();
        List<ASTNode> list = NavUtils.underCaret(compilationInfo, n);
        final SemiAttribute.AttributedElement attributedElement = NavUtils.findElement(compilationInfo, list, n, semiAttribute = SemiAttribute.semiAttribute(compilationInfo));
        if (attributedElement == null) {
            return linkedList;
        }
        final LinkedList linkedList2 = new LinkedList();
        new DefaultVisitor(){

            public void visit(FunctionDeclaration functionDeclaration) {
                if (attributedElement == semiAttribute.getElement(functionDeclaration)) {
                    linkedList2.add(functionDeclaration.getFunctionName());
                }
                super.visit(functionDeclaration);
            }

            public void visit(ClassDeclaration classDeclaration) {
                if (attributedElement == semiAttribute.getElement(classDeclaration)) {
                    linkedList2.add(classDeclaration.getName());
                }
                super.visit(classDeclaration);
            }

            public void visit(FunctionInvocation functionInvocation) {
                if (attributedElement == semiAttribute.getElement(functionInvocation)) {
                    linkedList2.add(functionInvocation.getFunctionName());
                }
                super.visit(functionInvocation);
            }

            public void visit(Variable variable) {
                if (attributedElement == semiAttribute.getElement(variable)) {
                    linkedList2.add(variable);
                }
                super.visit(variable);
            }

            public void visit(ArrayAccess arrayAccess) {
                if (attributedElement == semiAttribute.getElement(arrayAccess)) {
                    linkedList2.add(arrayAccess);
                }
                super.visit(arrayAccess);
            }

            public void visit(Scalar scalar) {
                if (attributedElement == semiAttribute.getElement(scalar)) {
                    linkedList2.add(scalar);
                }
                super.visit(scalar);
            }

            public void visit(ClassInstanceCreation classInstanceCreation) {
                if (attributedElement == semiAttribute.getElement(classInstanceCreation)) {
                    linkedList2.add(classInstanceCreation.getClassName());
                }
                super.visit(classInstanceCreation);
            }
        }.scan(Utils.getRoot(compilationInfo));
        for (ASTNode aSTNode : linkedList2) {
            OffsetRange offsetRange = OccurrencesFinderImpl.forNode(aSTNode, attributedElement.getKind());
            if (offsetRange == null) continue;
            linkedList.add(offsetRange);
        }
        return linkedList;
    }

    private static OffsetRange forNode(ASTNode aSTNode, SemiAttribute.AttributedElement.Kind kind) {
        OffsetRange offsetRange = null;
        if (aSTNode instanceof Scalar && ((Scalar)aSTNode).getScalarType() == Scalar.Type.STRING && NavUtils.isQuoted(((Scalar)aSTNode).getStringValue())) {
            offsetRange = new OffsetRange(aSTNode.getStartOffset() + 1, aSTNode.getEndOffset() - 1);
        } else if (aSTNode instanceof Variable && ((Variable)aSTNode).isDollared()) {
            offsetRange = new OffsetRange(aSTNode.getStartOffset() + 1, aSTNode.getEndOffset());
        } else if (aSTNode instanceof ArrayAccess && kind == SemiAttribute.AttributedElement.Kind.VARIABLE) {
            ArrayAccess arrayAccess = (ArrayAccess)aSTNode;
            Expression expression = arrayAccess.getIndex();
            offsetRange = OccurrencesFinderImpl.forNode(expression, kind);
        } else {
            offsetRange = new OffsetRange(aSTNode.getStartOffset(), aSTNode.getEndOffset());
        }
        return offsetRange;
    }
}

